/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.mss;

import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumns;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbIndex;
import com.sap.dictionary.database.dbs.DbIndexColumnInfo;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbSchema;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.ExType;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.XmlHelper;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.dictionary.database.mss.DbMssEnvironment;
import com.sap.sql.NativeSQLAccess;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class DbMssIndex
extends DbIndex {
    private String dataFilegroup = "DEFAULT";
    private boolean isClustered = false;
    private boolean withPadindex = false;
    private int withFillfactor = 0;
    private static Location loc = Logger.getLocation("mss.DbMssIndex");

    public DbMssIndex() {
    }

    public DbMssIndex(DbFactory factory) {
        super(factory);
    }

    public DbMssIndex(DbFactory factory, DbIndex other) {
        super(factory, other);
    }

    public DbMssIndex(DbFactory factory, String tableName, String indexName) {
        super(factory, tableName, indexName);
    }

    public DbMssIndex(DbFactory factory, DbSchema schema, String tableName, String indexName) {
        super(factory, schema, tableName, indexName);
    }

    public void setSpecificContentViaXml(XmlMap xmlMap) throws JddException {
        loc.entering("setSpecificContentViaXml");
        try {
            XmlMap storage = xmlMap.getXmlMap("storage-parameters");
            if (storage.isEmpty()) {
                return;
            }
            this.dataFilegroup = storage.getString("filegroup");
            this.isClustered = storage.getBoolean("is-clustered");
            this.withFillfactor = storage.getInt("fillfactor");
            this.withPadindex = this.withFillfactor > 0 && this.withFillfactor < 100 ? storage.getBoolean("padindex") : false;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setSpecificContentViaXml failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        loc.exiting();
    }

    public void setCommonContentViaDb() throws JddException {
        loc.entering("setCommonContentViaDb");
        Connection con = this.getDbFactory().getConnection();
        String name = this.getName();
        String tabname = this.getTableName();
        boolean isUnique = false;
        ArrayList<DbIndexColumnInfo> columnList = new ArrayList<DbIndexColumnInfo>();
        Object dbmd = null;
        long sqlServerVersion = 7L;
        int status = 0;
        int indid = 0;
        int id = 0;
        int colcnt = 0;
        try {
            Statement dstmt = NativeSQLAccess.createNativeStatement((Connection)con);
            ResultSet drs = dstmt.executeQuery("select @@microsoftversion / (1024*1024*16) ");
            if (drs.next()) {
                sqlServerVersion = drs.getLong(1);
            }
            drs.close();
            dstmt.close();
        }
        catch (SQLException ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setCommonContentViaDb failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        String schemaName = null;
        schemaName = this.retrieveSchemaName(con);
        try {
            Statement dstmt = NativeSQLAccess.createNativeStatement((Connection)con);
            String uidFct = "";
            uidFct = schemaName != null ? "user_id('" + schemaName + "')" : "user_id()";
            ResultSet drs = dstmt.executeQuery("select si.status, si.indid, si.id, si.keycnt from sysindexes si, sysobjects so where so.name = '" + tabname + "' and so.uid = " + uidFct + " and so.id = si.id and " + "si.name = '" + name + "'");
            if (!drs.next()) {
                Object[] arguments = new Object[]{tabname, name};
                drs.close();
                dstmt.close();
                loc.errorT("index {0}.{1} doesn't exist on database", arguments);
                loc.exiting();
                throw new JddException(ExType.NOT_ON_DB, "index " + tabname + "." + name + " doesn't exist on db");
            }
            status = drs.getInt(1);
            indid = drs.getInt(2);
            id = drs.getInt(3);
            colcnt = drs.getInt(4);
            drs.close();
            dstmt.close();
        }
        catch (SQLException ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setCommonContentViaDb failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        isUnique = (status & 2) > 0;
        StringBuffer queryBuffer = new StringBuffer("select index_col('" + tabname + "', " + indid + ", 1)");
        if (sqlServerVersion > 7L) {
            queryBuffer.append(", indexkey_property(" + id + ", " + indid + ", 1, 'IsDescending')");
        }
        int col_i = 2;
        while (col_i <= 16) {
            queryBuffer.append(", index_col('" + tabname + "', " + indid + ", " + col_i + ")");
            if (sqlServerVersion > 7L) {
                queryBuffer.append(", indexkey_property(" + id + ", " + indid + ", " + col_i + ", 'IsDescending')");
            }
            ++col_i;
        }
        String query = queryBuffer.toString();
        int factor = sqlServerVersion > 7L ? 2 : 1;
        String colName = null;
        boolean isDescending = false;
        try {
            Statement dstmt = NativeSQLAccess.createNativeStatement((Connection)con);
            ResultSet drs = dstmt.executeQuery(query);
            if (drs.next()) {
                int col_i2 = 0;
                while (col_i2 < 16) {
                    colName = drs.getString(col_i2 * factor + 1);
                    if (colName == null) break;
                    if (sqlServerVersion > 7L) {
                        isDescending = drs.getInt(col_i2 * factor + 2) == 1;
                    }
                    columnList.add(new DbIndexColumnInfo(colName, isDescending));
                    ++col_i2;
                }
            }
            drs.close();
            dstmt.close();
        }
        catch (SQLException ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setCommonContentViaDb failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        this.setContent(isUnique, columnList);
        loc.exiting();
    }

    public void setSpecificContentViaDb() throws JddException {
        loc.entering("setSpecificContentViaDb");
        Connection con = this.getDbFactory().getConnection();
        String schemaName = null;
        schemaName = this.retrieveSchemaName(con);
        try {
            Statement dstmt = NativeSQLAccess.createNativeStatement((Connection)con);
            String uidFct = "";
            uidFct = schemaName != null ? "user_id('" + schemaName + "')" : "user_id()";
            ResultSet drs = dstmt.executeQuery("select sf.groupname, si.indid, si.OrigFillFactor from sysindexes si, sysobjects so, sysfilegroups sf  where so.name = '" + this.getTableName() + "' and so.uid = " + uidFct + " and " + "si.groupid = sf.groupid and " + "si.id = so.id and " + "si.name = '" + this.getName() + "'");
            if (drs.next()) {
                String hlp = drs.getString(1);
                this.dataFilegroup = hlp.equals("PRIMARY") ? "DEFAULT" : hlp;
                this.isClustered = drs.getInt(2) == 1;
                this.withFillfactor = drs.getInt(3);
            }
            drs.close();
            dstmt.close();
            super.setDbSpecificIsSet(true);
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setSpecificContentViaDb failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        loc.exiting();
    }

    public void writeSpecificContentToXmlFile(PrintWriter file, String offset0) throws JddException {
        loc.entering("writeSpecificContentToXmlFile");
        try {
            file.println(offset0 + "<index name=" + "\"" + this.getName() + "\"" + ">");
            String offset1 = offset0 + XmlHelper.tabulate();
            String offset2 = offset1 + XmlHelper.tabulate();
            file.println(offset1 + "<storage-parameters>");
            file.println(offset2 + "<filegroup>" + this.dataFilegroup + "</filegroup>");
            file.println(offset2 + "<is-clustered>" + this.isClustered + "</is-clustered>");
            file.println(offset2 + "<fillfactor>" + this.withFillfactor + "</fillfactor>");
            file.println(offset2 + "<index-padded>" + this.withPadindex + "</index-padded>");
            file.println(offset1 + "</storage-parameters>");
            file.println(offset0 + "</index>");
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("writeSpecificContentToXmlFile failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        loc.exiting();
    }

    public DbObjectSqlStatements getDdlStatementsForCreate() {
        loc.entering("getDdlStatementsForCreate");
        DbObjectSqlStatements indexDef = new DbObjectSqlStatements(this.getName());
        DbSqlStatement createStatement = new DbSqlStatement();
        String uniqueStr = this.isUnique() ? " UNIQUE " : " ";
        String clusteredStr = this.isClustered ? " CLUSTERED " : " ";
        String schemaName = null;
        if (this.getSchema() != null) {
            schemaName = this.getSchema().getSchemaName();
        }
        String userdot = "";
        if (schemaName != null) {
            userdot = schemaName + ".";
        }
        createStatement.addLine("CREATE" + uniqueStr + clusteredStr + " INDEX [" + this.getName() + "]  ON " + userdot + "[" + this.getTableName() + "]");
        createStatement.merge(this.getDdlColumnsClause());
        indexDef.add(createStatement);
        loc.exiting();
        return indexDef;
    }

    public DbSqlStatement getDdlColumnsClause() {
        loc.entering("getDdlColumnsClause");
        DbSqlStatement colDef = new DbSqlStatement();
        colDef.addLine("(");
        Iterator icIterator = ((AbstractList)this.getColumnNames()).iterator();
        DbIndexColumnInfo indColumn = null;
        String sep = ",";
        while (icIterator.hasNext()) {
            indColumn = (DbIndexColumnInfo)icIterator.next();
            if (!icIterator.hasNext()) {
                sep = "";
            }
            if (indColumn.isDescending()) {
                colDef.addLine("  [" + indColumn.getName() + "] DESC" + sep);
                continue;
            }
            colDef.addLine("  [" + indColumn.getName() + "]" + sep);
        }
        colDef.addLine(")");
        if (this.withPadindex || this.withFillfactor > 0) {
            colDef.addLine("WITH ");
            if (this.withPadindex) {
                colDef.addLine("PADINDEX,");
            }
            if (this.withFillfactor > 0) {
                colDef.addLine("FILLFACTOR = " + this.withFillfactor);
            }
        }
        return colDef;
    }

    public DbObjectSqlStatements getDdlStatementsForDrop() {
        loc.entering("getDdlStatementsForDrop");
        DbObjectSqlStatements dropDef = new DbObjectSqlStatements(this.getName());
        DbSqlStatement dropLine = new DbSqlStatement(true);
        String schemaName = null;
        if (this.getSchema() != null) {
            schemaName = this.getSchema().getSchemaName();
        }
        String userdot = "";
        if (schemaName != null) {
            userdot = schemaName + ".";
        }
        dropLine.addLine("DROP INDEX " + userdot + "[" + this.getTableName() + "].[" + this.getName() + "]");
        dropDef.add(dropLine);
        loc.exiting();
        return dropDef;
    }

    public boolean checkWidth() {
        loc.entering("checkWidth");
        Iterator iter = ((AbstractList)this.getColumnNames()).iterator();
        String colName = null;
        DbColumns columns = this.getIndexes().getTable().getColumns();
        boolean check = true;
        int total = 0;
        while (iter.hasNext()) {
            colName = ((DbIndexColumnInfo)iter.next()).getName();
            DbColumn column = columns.getColumn(colName);
            if (column == null) {
                check = false;
                Object[] arguments = new Object[]{this.getName(), colName, this.getTableName()};
                loc.errorT("checkWidth {0}: no column {1} in table {2} ", arguments);
                continue;
            }
            switch (column.getJavaSqlType()) {
                case -4: 
                case -1: 
                case 2004: 
                case 2005: {
                    check = false;
                    Object[] arguments = new Object[]{this.getName(), colName};
                    loc.errorT("checkWidth {0}: column of type LOB/LONGVAR ({1}) not allowed in index", arguments);
                    break;
                }
                case -5: {
                    total += 8;
                    break;
                }
                case -3: 
                case -2: {
                    total = (int)((long)total + column.getLength());
                    break;
                }
                case 1: 
                case 12: {
                    total = (int)((long)total + column.getLength() * 2L);
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    total += 8;
                    break;
                }
                case 2: 
                case 3: {
                    long prec = column.getLength();
                    if (prec < 10L) {
                        total += 5;
                        break;
                    }
                    if (prec < 20L) {
                        total += 9;
                        break;
                    }
                    if (prec < 29L) {
                        total += 13;
                        break;
                    }
                    total += 17;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    total += 8;
                    break;
                }
                case 4: {
                    total += 4;
                    break;
                }
                case 5: {
                    total += 4;
                    break;
                }
                case -6: {
                    total += 8;
                }
            }
        }
        if (total > 900) {
            check = false;
            Object[] arguments = new Object[]{this.getName(), new Integer(total)};
            loc.errorT("checkWidth {0}: total width of index ({1}) greater than allowed maximum (900)", arguments);
        }
        loc.exiting();
        return check;
    }

    public boolean checkNameLength() {
        boolean check;
        loc.entering("checkNameLength");
        int nameLen = this.getName().length();
        boolean bl = check = nameLen > 0 && nameLen <= 128;
        if (!check) {
            Object[] arguments = new Object[]{this.getName(), new Integer(nameLen)};
            loc.errorT("checkNameLength {0}: length {1} invalid (valid range [1..128])", arguments);
        }
        loc.exiting();
        return check;
    }

    public boolean checkNameForReservedWord() {
        boolean check;
        loc.entering("checkNameForReservedWord");
        boolean bl = check = !DbMssEnvironment.isReservedWord(this.getName());
        if (!check) {
            Object[] arguments = new Object[]{this.getName()};
            loc.errorT("{0} is a reserved word", arguments);
        }
        loc.exiting();
        return check;
    }

    public boolean checkNumberOfColumns() {
        boolean check;
        loc.entering("checkNumberOfColumns");
        int numCols = this.getColumnNames().size();
        boolean bl = check = numCols > 0 && numCols <= 16;
        if (!check) {
            Object[] arguments = new Object[]{this.getName(), new Integer(numCols)};
            loc.errorT("checkNumberOfColumns{0}: column count {1} not in allowed range [1..16]", arguments);
        }
        loc.exiting();
        return check;
    }

    private String retrieveSchemaName(Connection con) throws JddException {
        String schemaName = null;
        if (this.getSchema() != null) {
            schemaName = this.getSchema().getSchemaName();
        } else {
            try {
                Statement schStmt = NativeSQLAccess.createNativeStatement((Connection)con);
                ResultSet rs = schStmt.executeQuery("select user");
                rs.next();
                schemaName = rs.getString(1);
                rs.close();
                schStmt.close();
            }
            catch (Exception ex) {
                Object[] arguments = new Object[]{ex.getMessage()};
                loc.errorT("retrieveSchemaName failed: {0}", arguments);
                loc.exiting();
                throw JddException.createInstance(ex);
            }
        }
        return schemaName;
    }
}

