/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.dbs;

import com.sap.dictionary.database.dbs.DbMsgHandler;
import com.sap.dictionary.database.dbs.ExType;
import com.sap.dictionary.database.dbs.GenExceptionInfo;
import com.sap.dictionary.database.dbs.IGenException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;

public class JddRuntimeException
extends RuntimeException
implements IGenException {
    GenExceptionInfo info = null;
    private static final ExType EX_TYPE_NULL = null;
    private static final Throwable CAUSE_NULL = null;
    private static final Object[] ARGS_NULL = null;

    public JddRuntimeException() {
        this.info = new GenExceptionInfo(this, EX_TYPE_NULL, CAUSE_NULL);
    }

    public JddRuntimeException(String message) {
        super(message);
        this.info = new GenExceptionInfo(this, EX_TYPE_NULL, CAUSE_NULL);
    }

    public JddRuntimeException(ExType exType, String message) {
        this.info = new GenExceptionInfo(this, exType, CAUSE_NULL);
    }

    public JddRuntimeException(ExType exType, String message, Throwable cause) {
        super(message);
        this.info = new GenExceptionInfo(this, exType, cause);
    }

    public JddRuntimeException(Object msgCode, Category cat, int severity, Location loc) {
        this(EX_TYPE_NULL, CAUSE_NULL, msgCode, ARGS_NULL, cat, severity, loc);
    }

    public JddRuntimeException(Object msgCode, Object[] args, Category cat, int severity, Location loc) {
        this(EX_TYPE_NULL, CAUSE_NULL, msgCode, args, cat, severity, loc);
    }

    public JddRuntimeException(Throwable cause, Object msgCode, Category cat, int severity, Location loc) {
        this(EX_TYPE_NULL, cause, msgCode, ARGS_NULL, cat, severity, loc);
    }

    public JddRuntimeException(Throwable cause, Object msgCode, Object[] args, Category cat, int severity, Location loc) {
        this(EX_TYPE_NULL, cause, msgCode, args, cat, severity, loc);
    }

    public JddRuntimeException(ExType exType, Object msgCode, Category cat, int severity, Location loc) {
        this(exType, CAUSE_NULL, msgCode, ARGS_NULL, cat, severity, loc);
    }

    public JddRuntimeException(ExType exType, Object msgCode, Object[] args, Category cat, int severity, Location loc) {
        this(exType, CAUSE_NULL, msgCode, args, cat, severity, loc);
    }

    public JddRuntimeException(ExType exType, Throwable cause, Object msgCode, Category cat, int severity, Location loc) {
        this(exType, cause, msgCode, ARGS_NULL, cat, severity, loc);
    }

    public JddRuntimeException(ExType exType, Throwable cause, Object msgCode, Object[] args, Category cat, int severity, Location loc) {
        super((msgCode == null ? "" : DbMsgHandler.get(msgCode, args)) + (cause == null ? "" : " Caused by: " + cause.getMessage()));
        this.info = new GenExceptionInfo(this, exType, cause, msgCode, args, cat, severity, loc);
    }

    public void printStackTrace() {
        if (this.info.getCause() != null) {
            this.info.getCause().printStackTrace();
        } else {
            super.printStackTrace();
        }
    }

    public static JddRuntimeException createInstance(Throwable cause) {
        if (cause instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)cause).getTargetException();
        }
        if (cause instanceof JddRuntimeException) {
            return (JddRuntimeException)cause;
        }
        if (cause instanceof SQLException) {
            return new JddRuntimeException(ExType.SQL_ERROR, cause.getMessage(), cause);
        }
        return new JddRuntimeException(ExType.OTHER, cause.getMessage(), cause);
    }

    public static JddRuntimeException createInstance(Throwable cause, Category cat, int severity, Location loc) {
        if (cause instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)cause).getTargetException();
        }
        if (cause instanceof IGenException) {
            IGenException iGenCause = (IGenException)((Object)cause);
            iGenCause.getInfo().intLog(cat, severity, loc);
        }
        if (cause instanceof JddRuntimeException) {
            return (JddRuntimeException)cause;
        }
        if (cause instanceof SQLException) {
            return new JddRuntimeException(ExType.SQL_ERROR, cause, null, null, cat, severity, loc);
        }
        return new JddRuntimeException(ExType.OTHER, cause, null, null, cat, severity, loc);
    }

    public static void log(Throwable cause, Category cat, int severity, Location loc) {
        JddRuntimeException.createInstance(cause, cat, severity, loc);
    }

    public static void log(Throwable cause, Object msgCode, Category cat, int severity, Location loc) {
        JddRuntimeException.log(cause, msgCode, null, cat, severity, loc);
    }

    public static void log(Throwable cause, Object msgCode, Object[] args, Category cat, int severity, Location loc) {
        cat.log(severity, loc, msgCode, args);
        JddRuntimeException.createInstance(cause, cat, severity, loc);
    }

    public String getStackTraceString() {
        return this.info.getStackTraceString();
    }

    public ExType getExType() {
        return this.info.getExType();
    }

    public GenExceptionInfo getInfo() {
        return this.info;
    }
}

