/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.dbs;

import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbDeploymentInfo;
import com.sap.dictionary.database.dbs.DbDeploymentStatus;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbIndexColumnInfo;
import com.sap.dictionary.database.dbs.DbMsgHandler;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbPrimaryKeyDifference;
import com.sap.dictionary.database.dbs.DbSchema;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.DbTable;
import com.sap.dictionary.database.dbs.DbsConstants;
import com.sap.dictionary.database.dbs.ExType;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.XmlHelper;
import com.sap.dictionary.database.dbs.XmlMap;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

public abstract class DbPrimaryKey
implements DbsConstants {
    private DbFactory factory = null;
    private DbSchema schema = null;
    private String tableName = " ";
    private boolean tableNameIsCaseSensitive = false;
    private DbDeploymentInfo deploymentInfo = null;
    private DbDeploymentStatus deploymentStatus = null;
    private ArrayList columnsInfo = null;
    private boolean dbSpecificIsSet = false;
    private DbTable dbTable = null;
    private boolean isSet = false;

    public DbPrimaryKey() {
    }

    public DbPrimaryKey(DbFactory factory, DbPrimaryKey other) {
        this.factory = factory;
    }

    public DbPrimaryKey(DbFactory factory) {
        this.factory = factory;
    }

    public DbPrimaryKey(DbFactory factory, DbSchema schema, String tableName) {
        this.factory = factory;
        this.schema = schema;
        this.tableName = tableName;
    }

    public DbPrimaryKey(DbFactory factory, String tableName) {
        this.factory = factory;
        this.tableName = tableName;
    }

    public void setContent(ArrayList columnsInfo) {
        this.columnsInfo = columnsInfo;
        this.isSet = true;
    }

    public void setCommonContentViaXml(XmlMap xmlMap) throws JddException {
        try {
            if (xmlMap.isEmpty()) {
                return;
            }
            this.tableName = xmlMap.getString("tabname");
            this.tableName = XmlHelper.checkAndGetName(this.tableName, "Table");
            if (this.tableName == null || this.tableName.trim().equalsIgnoreCase("")) {
                throw new JddException(ExType.XML_ERROR, DbMsgHandler.get(DbsConstants.RTXML_PRKEYTABNAME_MISS));
            }
            this.deploymentInfo = new DbDeploymentInfo(xmlMap, this.factory);
            this.deploymentStatus = DbDeploymentStatus.getInstance(xmlMap.getString("deployment-status"));
            XmlMap columns = xmlMap.getXmlMap("columns");
            String nextColumnName = null;
            this.columnsInfo = new ArrayList();
            int i = 0;
            while ((nextColumnName = columns.getString("column" + (i == 0 ? "" : "" + i))) != null) {
                this.columnsInfo.add(new DbIndexColumnInfo(nextColumnName, false));
                ++i;
            }
            if (this.columnsInfo.isEmpty()) {
                throw new JddException(ExType.XML_ERROR, DbMsgHandler.get(DbsConstants.RTXML_PRKEYCOLS_MISS));
            }
            this.isSet = true;
        }
        catch (Exception ex) {
            throw JddException.createInstance(ex);
        }
    }

    public abstract void setSpecificContentViaXml(XmlMap var1) throws JddException;

    public abstract void setCommonContentViaDb() throws JddException;

    public abstract void setSpecificContentViaDb() throws JddException;

    public void setDbSpecificIsSet(boolean dbSpecificIsSet) {
        this.dbSpecificIsSet = dbSpecificIsSet;
    }

    public DbFactory getDbFactory() {
        return this.factory;
    }

    public String getTableName() {
        return this.tableName;
    }

    public ArrayList getColumnNames() {
        return this.columnsInfo;
    }

    public int getKeyCnt() {
        return this.columnsInfo.size();
    }

    public String getKeyFieldName(int position) {
        if (position <= 0) {
            return null;
        }
        return ((DbIndexColumnInfo)this.columnsInfo.get(--position)).getName();
    }

    public int getKeyFieldPosition(String name) {
        ListIterator iter = ((AbstractList)this.columnsInfo).listIterator();
        while (iter.hasNext()) {
            if (!((DbIndexColumnInfo)iter.next()).getName().equalsIgnoreCase(name)) continue;
            return iter.nextIndex();
        }
        return 0;
    }

    public boolean isPrimaryKeyField(String name) {
        return this.getKeyFieldPosition(name) > 0;
    }

    public boolean getDbSpecificIsSet() {
        return this.dbSpecificIsSet;
    }

    public DbSchema getDbSchema() {
        return this.schema;
    }

    public void setColumnNames(ArrayList columnsInfo) {
        this.columnsInfo = columnsInfo;
    }

    public String toString() {
        String columnsInfoString = "";
        int i = 0;
        while (i < this.columnsInfo.size()) {
            columnsInfoString = columnsInfoString + (DbIndexColumnInfo)this.columnsInfo.get(i);
            ++i;
        }
        return "PrimaryKey = \nTableName             : " + this.tableName + "\n" + this.deploymentInfo + "\n" + this.deploymentStatus + columnsInfoString + "\n";
    }

    public void writeCommonContentToXmlFile(PrintWriter file, String offset0) throws JddException {
        try {
            file.println(offset0 + "<primary-key" + ">");
            String offset1 = offset0 + XmlHelper.tabulate();
            file.println(offset1 + "<tabname>" + this.tableName + "</tabname>");
            file.println(offset1 + "<columns>");
            String offset2 = offset1 + XmlHelper.tabulate();
            int i = 0;
            while (i < this.columnsInfo.size()) {
                file.println(offset2 + "<column>" + ((DbIndexColumnInfo)this.columnsInfo.get(i)).getName() + "</column>");
                ++i;
            }
            file.println(offset1 + "</columns>");
            file.println(offset0 + "</primary-key>");
        }
        catch (Exception ex) {
            throw JddException.createInstance(ex);
        }
    }

    public abstract DbObjectSqlStatements getDdlStatementsForCreate();

    public abstract DbObjectSqlStatements getDdlStatementsForDrop();

    public DbSqlStatement getDdlColumnsClause() {
        String line = "";
        Iterator iter = ((AbstractList)this.columnsInfo).iterator();
        DbSqlStatement colDef = new DbSqlStatement();
        colDef.addLine("(");
        while (iter.hasNext()) {
            DbIndexColumnInfo dbIndexColumnInfo = (DbIndexColumnInfo)iter.next();
            line = dbIndexColumnInfo.getName();
            if (iter.hasNext()) {
                line = line + ", ";
            }
            colDef.addLine(line);
        }
        colDef.addLine(")");
        return colDef;
    }

    public DbPrimaryKeyDifference compareTo(DbPrimaryKey target) throws JddException {
        DbPrimaryKeyDifference difference = null;
        try {
            if (target.columnsInfo.size() != this.columnsInfo.size()) {
                difference = this.factory.makeDbPrimaryKeyDifference(this, target, Action.DROP_CREATE);
                return difference;
            }
            int i = 0;
            while (i < this.columnsInfo.size()) {
                if (!((DbIndexColumnInfo)this.columnsInfo.get(i)).equals((DbIndexColumnInfo)target.columnsInfo.get(i))) {
                    difference = this.factory.makeDbPrimaryKeyDifference(this, target, Action.DROP_CREATE);
                }
                ++i;
            }
            return difference;
        }
        catch (Exception ex) {
            throw JddException.createInstance(ex);
        }
    }

    public void setTable(DbTable dbTable) {
        this.dbTable = dbTable;
    }

    public DbTable getTable() {
        return this.dbTable;
    }

    public boolean isEmpty() {
        if (this.columnsInfo == null) {
            return true;
        }
        return this.columnsInfo.isEmpty();
    }

    public boolean check() {
        return this.checkWidth() & this.checkNumberOfColumns() & this.checkColumnsNotNull();
    }

    public boolean checkWidth() {
        return true;
    }

    public boolean checkNumberOfColumns() {
        return true;
    }

    public boolean checkColumnsNotNull() {
        return true;
    }
}

