/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.dbs;

import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbDeploymentInfo;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbTable;
import com.sap.dictionary.database.dbs.DbTableDifference;
import com.sap.dictionary.database.dbs.DbsConstants;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.XmlExtractor;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.InputStream;
import java.sql.Connection;
import org.xml.sax.InputSource;

public class DbObjectModificationAnalyser
implements DbsConstants {
    private static final Location loc = Location.getLocation((Class)(class$com$sap$dictionary$database$dbs$DbObjectModificationAnalyser == null ? (class$com$sap$dictionary$database$dbs$DbObjectModificationAnalyser = DbObjectModificationAnalyser.class$("com.sap.dictionary.database.dbs.DbObjectModificationAnalyser")) : class$com$sap$dictionary$database$dbs$DbObjectModificationAnalyser));
    private static final Category cat = Category.getCategory((String)"/Jddic/Database");
    InputStream stream = null;
    Connection con = null;
    boolean positionIsRelevant = false;
    Action action = null;
    DbObjectSqlStatements statements = null;
    DbFactory factory = null;
    XmlMap tableMap = new XmlMap();
    static /* synthetic */ Class class$com$sap$dictionary$database$dbs$DbObjectModificationAnalyser;

    public DbObjectModificationAnalyser(DbFactory factory, InputStream stream) {
        this.stream = stream;
        this.con = factory.getConnection();
        this.factory = factory;
        XmlExtractor extractor = new XmlExtractor();
        this.tableMap = extractor.map(new InputSource(stream));
    }

    public DbObjectModificationAnalyser(DbFactory factory, XmlMap xmlMap) {
        this.con = factory.getConnection();
        this.factory = factory;
        this.tableMap = xmlMap;
    }

    public DbObjectSqlStatements modify() throws JddException {
        DbTable tabViaXml = null;
        DbTable tabViaDb = null;
        boolean doNotCreate = false;
        boolean deleteIfExisting = false;
        loc.entering("dbs.modify()");
        try {
            tabViaXml = this.factory.makeTable();
            tabViaXml.setCommonContentViaXml(this.tableMap);
            String tableName = tabViaXml.getName();
            if (tabViaXml != null) {
                DbDeploymentInfo info = tabViaXml.getDeploymentInfo();
                doNotCreate = info.doNotCreate();
                deleteIfExisting = info.deleteIfExisting();
            }
            cat.info(loc, DbsConstants.TABLE_ANALYSE_START, new Object[]{tableName});
            this.action = tabViaXml.getDeploymentInfo().getPredefinedAction();
            tabViaDb = this.factory.makeTable(tableName);
            tabViaDb.setCommonContentViaDb(this.factory);
            if (this.action == Action.DROP) {
                cat.info(loc, DbsConstants.ACTION, new Object[]{this.action});
                this.statements = tabViaXml.getDdlStatementsForDrop();
            } else if (this.action == Action.DROP_CREATE) {
                cat.info(loc, DbsConstants.ACTION, new Object[]{this.action});
                this.statements = tabViaXml.getDdlStatementsForDrop();
                if (!doNotCreate) {
                    this.statements.merge(tabViaXml.getDdlStatementsForCreate());
                }
            } else if (tabViaDb.getColumns() == null) {
                if (doNotCreate) {
                    cat.info(loc, DbsConstants.TABLE_CREATE_FORBID, new Object[]{this.factory.getDatabaseName()});
                } else {
                    this.action = Action.CREATE;
                    cat.info(loc, DbsConstants.ACTION, new Object[]{this.action});
                    this.statements = tabViaXml.getDdlStatementsForCreate();
                }
            } else if (tabViaXml == null) {
                this.action = Action.DROP;
                cat.info(loc, DbsConstants.ACTION, new Object[]{this.action});
                this.statements = tabViaXml.getDdlStatementsForDrop();
            } else if (doNotCreate) {
                if (deleteIfExisting) {
                    cat.info(loc, DbsConstants.TABLE_DELETE, new Object[]{this.factory.getDatabaseName()});
                    this.action = Action.DROP;
                    cat.info(loc, DbsConstants.ACTION, new Object[]{this.action});
                    this.statements = tabViaXml.getDdlStatementsForDrop();
                }
            } else {
                DbTableDifference difference = tabViaDb.compareTo(tabViaXml);
                if (difference != null) {
                    this.action = difference.getAction();
                    if (this.action == Action.ALTER || this.action == Action.CONVERT) {
                        if (!tabViaDb.existsData()) {
                            this.action = Action.DROP_CREATE;
                            cat.info(loc, DbsConstants.ACTION, new Object[]{this.action});
                            this.statements = tabViaXml.getDdlStatementsForDrop();
                            this.statements.merge(tabViaXml.getDdlStatementsForCreate());
                        } else if (this.action == Action.ALTER) {
                            cat.info(loc, DbsConstants.ACTION, new Object[]{this.action});
                            this.statements = difference.getDdlStatements(tableName);
                        } else {
                            cat.info(loc, DbsConstants.ACTION, new Object[]{this.action});
                            cat.info(loc, DbsConstants.TABLE_TOCONVERT);
                        }
                    }
                }
            }
            if (this.action == null) {
                this.action = Action.NOTHING;
                cat.info(loc, DbsConstants.TABLE_NOACTION);
            }
        }
        catch (Exception ex) {
            throw JddException.createInstance(ex);
        }
        loc.exiting();
        return this.statements;
    }

    public Action getAction() {
        return this.action;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

