/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.dbs;

import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbDeploymentInfo;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbIndex;
import com.sap.dictionary.database.dbs.DbIndexDifference;
import com.sap.dictionary.database.dbs.DbIndexIterator;
import com.sap.dictionary.database.dbs.DbIndexesDifference;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbTable;
import com.sap.dictionary.database.dbs.DbsConstants;
import com.sap.dictionary.database.dbs.XmlHelper;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class DbIndexes
implements DbsConstants {
    private DbFactory factory = null;
    private final HashMap indexesViaName = new HashMap();
    private DbIndex previous = null;
    private DbIndex first = null;
    private DbTable dbTable = null;
    private static final Location loc = Location.getLocation((Class)(class$com$sap$dictionary$database$dbs$DbIndexes == null ? (class$com$sap$dictionary$database$dbs$DbIndexes = DbIndexes.class$("com.sap.dictionary.database.dbs.DbIndexes")) : class$com$sap$dictionary$database$dbs$DbIndexes));
    private static final Category cat = Category.getCategory((String)"/Jddic/Database");
    static /* synthetic */ Class class$com$sap$dictionary$database$dbs$DbIndexes;

    public DbIndexes() {
    }

    public DbIndexes(DbFactory factory) {
        this.factory = factory;
    }

    public DbIndexes(DbFactory factory, DbIndexes other) {
        this.factory = factory;
    }

    public DbIndexes(DbFactory factory, XmlMap xmlMap) throws Exception {
        this.factory = factory;
        XmlMap nextIndexMap = null;
        DbIndex nextDbIndex = null;
        int i = 0;
        while (!(nextIndexMap = xmlMap.getXmlMap("index" + (i == 0 ? "" : "" + i))).isEmpty()) {
            nextDbIndex = factory.makeIndex();
            nextDbIndex.setCommonContentViaXml(nextIndexMap);
            this.add(nextDbIndex);
            ++i;
        }
    }

    public void add(DbIndex dbIndex) {
        dbIndex.setIndexes(this);
        if (this.previous == null) {
            this.first = dbIndex;
        } else {
            this.previous.setNext(dbIndex);
            dbIndex.setPrevious(this.previous);
        }
        this.previous = dbIndex;
        this.indexesViaName.put(dbIndex.getName(), dbIndex);
    }

    public DbIndex getFirst() {
        return this.first;
    }

    public DbIndex getIndex(String name) {
        return (DbIndex)this.indexesViaName.get(name);
    }

    public DbIndexIterator iterator() {
        return new DbIndexIterator(this.first);
    }

    public String toString() {
        String s = "";
        DbIndexIterator iterator = new DbIndexIterator(this.first);
        while (iterator.hasNext()) {
            s = s + iterator.next();
        }
        return s;
    }

    void writeCommonContentToXmlFile(PrintWriter file, String offset0) throws Exception {
        file.println(offset0 + "<indexes>");
        DbIndexIterator iterator = new DbIndexIterator(this.first);
        while (iterator.hasNext()) {
            iterator.next().writeCommonContentToXmlFile(file, offset0 + XmlHelper.tabulate());
        }
        file.println(offset0 + "</indexes>");
    }

    public DbObjectSqlStatements getDdlStatementsForCreate() throws Exception {
        boolean doNotCreate = false;
        DbObjectSqlStatements indexesDef = new DbObjectSqlStatements("");
        DbIndexIterator iterator = this.iterator();
        Object info = null;
        DbIndex index = null;
        while (iterator.hasNext()) {
            index = iterator.next();
            doNotCreate = index.getDeploymentInfo().doNotCreate();
            if (doNotCreate) {
                cat.info(loc, DbsConstants.INDEX_CREATE_FORBID, new Object[]{index.getName(), this.factory.getDatabaseName()});
            }
            if (doNotCreate) continue;
            indexesDef.merge(index.getDdlStatementsForCreate());
        }
        return indexesDef;
    }

    public DbObjectSqlStatements getDdlStatementsForDrop() throws Exception {
        DbObjectSqlStatements indexesDef = new DbObjectSqlStatements("");
        DbIndexIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            indexesDef.merge(iterator.next().getDdlStatementsForDrop());
        }
        return indexesDef;
    }

    DbIndexesDifference compareTo(DbIndexes target) throws Exception {
        DbIndexIterator iterator = this.iterator();
        DbIndexesDifference indexesDiff = new DbIndexesDifference(this, target);
        DbIndexDifference indexDiff = null;
        boolean doNotCreate = false;
        boolean deleteIfExisting = false;
        if (target == null) {
            return indexesDiff;
        }
        HashMap targetIndexesViaName = (HashMap)target.indexesViaName.clone();
        while (iterator.hasNext()) {
            Object obj;
            DbIndex targetIndex;
            doNotCreate = false;
            deleteIfExisting = false;
            DbIndex origin = iterator.next();
            if (target != null && (targetIndex = target.getIndex(origin.getName())) != null) {
                DbDeploymentInfo info = targetIndex.getDeploymentInfo();
                doNotCreate = info.doNotCreate();
                deleteIfExisting = info.deleteIfExisting();
            }
            if ((obj = targetIndexesViaName.remove(origin.getName())) == null) {
                indexDiff = this.factory.makeDbIndexDifference(origin, null, Action.DROP);
                indexesDiff.add(indexDiff);
                continue;
            }
            if (doNotCreate) {
                if (!deleteIfExisting) continue;
                indexDiff = this.factory.makeDbIndexDifference(origin, null, Action.DROP);
                indexesDiff.add(indexDiff);
                continue;
            }
            indexDiff = origin.compareTo((DbIndex)obj);
            if (indexDiff == null) continue;
            indexesDiff.add(indexDiff);
        }
        if (!targetIndexesViaName.isEmpty()) {
            Collection collection = targetIndexesViaName.values();
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                DbIndex nextIndex = (DbIndex)iter.next();
                DbDeploymentInfo info = nextIndex.getDeploymentInfo();
                doNotCreate = info.doNotCreate();
                if (doNotCreate) continue;
                indexDiff = this.factory.makeDbIndexDifference(null, nextIndex, Action.CREATE);
                indexesDiff.add(indexDiff);
            }
        }
        if (indexesDiff.isEmpty()) {
            indexesDiff = null;
        }
        return indexesDiff;
    }

    public void setTable(DbTable dbTable) {
        this.dbTable = dbTable;
    }

    public DbTable getTable() {
        return this.dbTable;
    }

    public boolean isEmpty() {
        return this.indexesViaName.isEmpty();
    }

    public boolean check() {
        boolean ok = true;
        DbIndexIterator iterator = new DbIndexIterator(this.first);
        while (iterator.hasNext()) {
            ok &= iterator.next().check();
        }
        return ok && this.checkNumber();
    }

    public boolean checkNumber() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

