/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db6;

import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumns;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbIndex;
import com.sap.dictionary.database.dbs.DbIndexColumnInfo;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbSchema;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.sql.NativeSQLAccess;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class DbDb6Index
extends DbIndex {
    private static Location loc = Logger.getLocation("db6.DbDb6Index");

    public DbDb6Index() {
    }

    public DbDb6Index(DbFactory factory) {
        super(factory);
    }

    public DbDb6Index(DbFactory factory, DbIndex other) {
        super(factory, other);
    }

    public DbDb6Index(DbFactory factory, String name, String tabname) {
        super(factory, name, tabname);
    }

    public DbDb6Index(DbFactory factory, DbSchema schema, String name, String tabname) {
        super(factory, schema, name, tabname);
    }

    public void setSpecificContentViaXml(XmlMap xmlMap) {
    }

    public DbObjectSqlStatements getDdlStatementsForCreate() {
        DbObjectSqlStatements indexDef = new DbObjectSqlStatements(this.getName());
        DbSqlStatement createStatement = new DbSqlStatement();
        String unique = this.isUnique() ? "UNIQUE " : "";
        createStatement.addLine("CREATE " + unique + "INDEX" + " " + '\"' + this.getName().toUpperCase() + '\"' + " ON " + this.getTableName().toUpperCase() + " ");
        createStatement.merge(this.getDdlColumnsClause());
        createStatement.addLine(" ALLOW REVERSE SCANS");
        indexDef.add(createStatement);
        return indexDef;
    }

    public void setCommonContentViaDb() throws JddException {
        loc.entering("setCommonContentViaDb");
        Connection con = this.getDbFactory().getConnection();
        boolean isUnique = false;
        boolean isDescending = false;
        int startIndex = 0;
        int endIndex = 0;
        ArrayList<DbIndexColumnInfo> columnsInfo = new ArrayList<DbIndexColumnInfo>();
        try {
            String schemaName = "CURRENT SCHEMA";
            PreparedStatement ps = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)("SELECT UNIQUERULE, COLNAMES FROM SYSCAT.INDEXES WHERE TABSCHEMA = " + schemaName + " AND INDNAME = ? AND UNIQUERULE <> 'P' "));
            ps.setString(1, this.getName().toUpperCase());
            ResultSet rset = ps.executeQuery();
            if (rset.next()) {
                isUnique = rset.getString(1).equals("U");
                String colnames = rset.getString(2);
                int ii = 0;
                while (ii < colnames.length()) {
                    if (colnames.charAt(ii) == '-' || colnames.charAt(ii) == '+') {
                        if (ii > 0) {
                            endIndex = ii;
                            columnsInfo.add(new DbIndexColumnInfo(colnames.substring(startIndex, endIndex), isDescending));
                        }
                        isDescending = colnames.charAt(ii) == '-';
                        startIndex = ii + 1;
                    } else if (ii == colnames.length() - 1) {
                        endIndex = ii + 1;
                        columnsInfo.add(new DbIndexColumnInfo(colnames.substring(startIndex, endIndex), isDescending));
                    }
                    ++ii;
                }
            }
            rset.close();
        }
        catch (SQLException ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setCommonContentViaDb failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        this.setContent(isUnique, columnsInfo);
        loc.exiting();
    }

    public void setSpecificContentViaDb() {
    }

    public boolean checkWidth() {
        Object[] arguments;
        loc.entering("checkWidth");
        Iterator iter = ((AbstractList)this.getColumnNames()).iterator();
        String colName = null;
        DbColumns columns = this.getIndexes().getTable().getColumns();
        boolean check = true;
        int total = 0;
        while (iter.hasNext()) {
            colName = ((DbIndexColumnInfo)iter.next()).getName();
            DbColumn column = columns.getColumn(colName);
            if (column == null) {
                check = false;
                arguments = new Object[]{this.getName(), colName, this.getIndexes().getTable().getName()};
                loc.errorT("checkWidth for index {0}: no column named {1} in table {2}.", arguments);
                continue;
            }
            switch (column.getJavaSqlType()) {
                case 2004: 
                case 2005: {
                    arguments = new Object[]{this.getName(), colName};
                    loc.errorT("checkWidth for index {0}: column type for column {1} is not allowed in an index.", arguments);
                    check = false;
                    break;
                }
                case -5: {
                    total += 10;
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    total = (int)((long)total + (column.getLength() + 2L));
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    total = (int)((long)total + (column.getLength() * 3L + 2L));
                    break;
                }
                case 91: {
                    total += 6;
                    break;
                }
                case 92: {
                    total += 5;
                    break;
                }
                case 93: {
                    total += 12;
                    break;
                }
                case 2: 
                case 3: {
                    total = (int)((long)total + (column.getLength() / 2L + 3L));
                    break;
                }
                case 6: 
                case 8: {
                    total += 10;
                    break;
                }
                case 7: {
                    total += 6;
                    break;
                }
                case 4: {
                    total += 6;
                    break;
                }
                case -6: 
                case 5: {
                    total += 4;
                }
            }
        }
        if ((total += 2) >= 1024) {
            check = false;
            arguments = new Object[]{this.getName(), new Integer(total)};
            loc.errorT("checkWidth for index {0}: total width of all columns in index ({1}) including row overhead is greater than the allowed maximum (1023) .", arguments);
        }
        loc.exiting();
        return check;
    }

    public boolean checkNameLength() {
        int nameLen = this.getName().length();
        boolean check = nameLen > 0 && nameLen <= 128;
        loc.entering("checkNameLength");
        if (!check) {
            Object[] arguments = new Object[]{this.getName()};
            loc.errorT("checkNameLength for index {0}: index name length must range from 0 to 128 .");
        }
        loc.exiting();
        return check;
    }

    public boolean checkNameForReservedWord() {
        boolean check = true;
        return check;
    }

    public boolean checkNumberOfColumns() {
        int numCols = this.getColumnNames().size();
        boolean check = numCols > 0 && numCols <= 16;
        loc.entering("checkNumberOfColumns");
        if (!check) {
            loc.errorT("checkNumberOfColumns: only 16 index columns are allowed.");
        }
        loc.exiting();
        return check;
    }
}

