/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db4;

import com.sap.dictionary.database.db4.DbDb4Column;
import com.sap.dictionary.database.db4.DbDb4Columns;
import com.sap.dictionary.database.db4.DbDb4Environment;
import com.sap.dictionary.database.db4.DbDb4Index;
import com.sap.dictionary.database.db4.DbDb4Indexes;
import com.sap.dictionary.database.db4.DbDb4PrimaryKey;
import com.sap.dictionary.database.dbs.DbColumnIterator;
import com.sap.dictionary.database.dbs.DbColumns;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbIndexes;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbPrimaryKey;
import com.sap.dictionary.database.dbs.DbSchema;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.DbTable;
import com.sap.dictionary.database.dbs.ExType;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.sql.NativeSQLAccess;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class DbDb4Table
extends DbTable {
    private static Location loc = Logger.getLocation("db4.DbDb4Table");
    private static Category cat = Logger.getCategory();

    public DbDb4Table() {
    }

    public DbDb4Table(DbFactory factory) {
        super(factory);
    }

    public DbDb4Table(DbFactory factory, DbTable other) {
        super(factory, other);
    }

    public DbDb4Table(DbFactory factory, DbSchema schema, String name) {
        super(factory, schema, name);
    }

    public DbDb4Table(DbFactory factory, String name) {
        super(factory, name);
    }

    public void setCommonContentViaXml(XmlMap xmlMap) throws JddException {
        loc.entering(cat, "setCommonContent(XmlMap)");
        super.setCommonContentViaXml(xmlMap);
        try {
            block4: {
                try {
                    DbFactory factory = this.getDbFactory();
                    XmlMap table = xmlMap.getXmlMap("Dbtable");
                    loc.debugT(cat, "DbDb4Table.setCommonContentViaXml(): Replace DbIndexes with DbDb4Indexes.");
                    XmlMap indexesMap = table.getXmlMap("indexes");
                    if (indexesMap == null) break block4;
                    this.setIndexes(new DbDb4Indexes(factory, indexesMap));
                }
                catch (Exception ex) {
                    throw JddException.createInstance(ex);
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            loc.exiting();
            throw throwable;
        }
        loc.exiting();
    }

    public void setSpecificContentViaXml(XmlMap xmlMap) {
        this.setDbSpecificIsSet(true);
    }

    public void writeSpecificContentToXmlFile(PrintWriter file, String offset0) {
    }

    public void setSpecificContentViaDb() {
        this.setDbSpecificIsSet(true);
    }

    public void setCommonContentViaDb(DbFactory factory) throws JddException {
        loc.entering(cat, "setCommonContentViaDb(DbFactory)");
        try {
            try {
                this.setColumnsViaDb(factory);
                this.setPrimaryKeyViaDb();
                this.setIndexesViaDb();
            }
            catch (Exception ex) {
                loc.errorT(cat, "Exception caught setting table contents: {0}.", new Object[]{ex.getMessage()});
                throw JddException.createInstance(ex);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            loc.exiting();
            throw throwable;
        }
        loc.exiting();
    }

    public void setColumnsViaDb(DbFactory factory) throws JddException {
        loc.entering(cat, "setColumnsViaDb(DbFactory)");
        DbDb4Columns cols = new DbDb4Columns(factory);
        cols.setTable(this);
        cols.setContentViaDb(factory);
        this.setColumns(cols);
        loc.exiting();
    }

    public void setIndexesViaDb() throws JddException {
        loc.entering(cat, "setIndexesViaDb()");
        ArrayList indexNames = null;
        Iterator iterator = null;
        DbFactory factory = this.getDbFactory();
        Object con = null;
        DbIndexes indexes = new DbIndexes(factory);
        indexNames = this.getIndexNamesViaDb(factory);
        iterator = ((AbstractList)indexNames).iterator();
        while (iterator.hasNext()) {
            indexes.add(this.setIndexViaDb((String)iterator.next()));
        }
        this.setIndexes(indexes);
        loc.exiting();
    }

    public void setPrimaryKeyViaDb() throws JddException {
        loc.entering(cat, "setPrimaryKeyViaDb()");
        DbDb4PrimaryKey primKey = new DbDb4PrimaryKey(this.getDbFactory(), this.getSchema(), this.getName());
        primKey.setCommonContentViaDb();
        if (!primKey.isEmpty()) {
            primKey.setSpecificContentViaDb();
            this.setPrimaryKey(primKey);
        }
        loc.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DbObjectSqlStatements getDdlStatementsForCreate() throws JddException {
        DbObjectSqlStatements dbObjectSqlStatements;
        loc.entering(cat, "getDdlStatementsForCreate()");
        String tableName = null;
        DbIndexes indexes = this.getIndexes();
        DbColumns columns = this.getColumns();
        DbPrimaryKey primaryKey = this.getPrimaryKey();
        DbObjectSqlStatements tableDef = new DbObjectSqlStatements(tableName);
        DbSqlStatement createLine = new DbSqlStatement();
        try {
            try {
                tableName = this.getName().trim().toUpperCase();
                createLine.addLine("CREATE TABLE \"" + tableName + "\"");
                createLine.merge(columns.getDdlClause());
                tableDef.add(createLine);
                if (indexes != null) {
                    tableDef.merge(indexes.getDdlStatementsForCreate());
                }
                if (primaryKey != null) {
                    tableDef.merge(primaryKey.getDdlStatementsForCreate());
                }
                loc.debugT(cat, "Generated: {0}.", new Object[]{tableDef});
                dbObjectSqlStatements = tableDef;
                Object var9_9 = null;
            }
            catch (Exception ex) {
                loc.errorT(cat, "Exception caught: " + ex.getMessage());
                throw JddException.createInstance(ex);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            loc.exiting();
            throw throwable;
        }
        loc.exiting();
        return dbObjectSqlStatements;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DbObjectSqlStatements getDdlStatementsForDrop() throws JddException {
        DbObjectSqlStatements dbObjectSqlStatements;
        loc.entering(cat, "getDdlStatementsForDrop()");
        String tableName = null;
        DbObjectSqlStatements tableDef = new DbObjectSqlStatements(this.getName());
        DbSqlStatement dropLine = new DbSqlStatement(true);
        try {
            try {
                tableName = this.getName().trim().toUpperCase();
                dropLine.addLine("DROP TABLE \"" + tableName + "\"");
                tableDef.add(dropLine);
                loc.debugT(cat, "Generated: {0}.", new Object[]{tableDef});
                dbObjectSqlStatements = tableDef;
                Object var6_6 = null;
            }
            catch (Exception ex) {
                loc.errorT(cat, "Exception caught: " + ex.getMessage());
                throw JddException.createInstance(ex);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            loc.exiting();
            throw throwable;
        }
        loc.exiting();
        return dbObjectSqlStatements;
    }

    /*
     * Loose catch block
     */
    public boolean existsOnDb() {
        boolean existsOnDb;
        block8: {
            loc.entering(cat, "existsOnDb()");
            existsOnDb = true;
            Connection con = null;
            Statement pstmt = null;
            ResultSet rs = null;
            String tableName = null;
            String stmtStr = "SELECT TABLE_NAME FROM SYSTABLES WHERE TABLE_NAME = ? AND TABLE_TYPE = ?";
            tableName = this.getName().trim().toUpperCase();
            con = this.getDbFactory().getConnection();
            pstmt = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)stmtStr);
            pstmt.setString(1, tableName);
            pstmt.setString(2, "T");
            rs = pstmt.executeQuery();
            existsOnDb = rs.next();
            Object var9_7 = null;
            try {
                rs.close();
                pstmt.close();
            }
            catch (Exception e2) {
                loc.warningT(cat, "Exception caught closing statement resources:\n {0}", new Object[]{e2.getMessage()});
            }
            break block8;
            {
                catch (Exception e) {
                    existsOnDb = true;
                    loc.errorT(cat, "Exception {0} caught executing {1}.\nReturn {2}.", new Object[]{e.getMessage(), stmtStr, new Boolean(existsOnDb)});
                    Object var9_8 = null;
                    try {
                        rs.close();
                        pstmt.close();
                    }
                    catch (Exception e2) {
                        loc.warningT(cat, "Exception caught closing statement resources:\n {0}", new Object[]{e2.getMessage()});
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    rs.close();
                    pstmt.close();
                }
                catch (Exception e2) {
                    loc.warningT(cat, "Exception caught closing statement resources:\n {0}", new Object[]{e2.getMessage()});
                }
                throw throwable;
            }
        }
        loc.infoT(cat, "existsOnDb() returns {0}.", new Object[]{new Boolean(existsOnDb)});
        loc.exiting();
        return existsOnDb;
    }

    /*
     * Loose catch block
     */
    public boolean existsData() {
        boolean existsData;
        block14: {
            String stmtStr;
            String tableName;
            ResultSet rs;
            Statement pstmt;
            block13: {
                loc.entering(cat, "existsData()");
                existsData = true;
                Connection con = null;
                pstmt = null;
                rs = null;
                tableName = null;
                stmtStr = null;
                tableName = this.getName().trim().toUpperCase();
                stmtStr = "SELECT COUNT(*) FROM \"" + tableName + "\"";
                con = this.getDbFactory().getConnection();
                pstmt = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)stmtStr);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    existsData = rs.getLong(1) > 0L;
                    break block13;
                }
                loc.errorT(cat, "No data found executing {0}.\n Return {1}.", new Object[]{stmtStr, new Boolean(existsData)});
            }
            Object var10_7 = null;
            try {
                rs.close();
                pstmt.close();
            }
            catch (Exception e2) {
                loc.warningT(cat, "Exception caught closing statement resources:\n {0}", new Object[]{e2.getMessage()});
            }
            break block14;
            {
                catch (SQLException sqlEx) {
                    if (sqlEx.getErrorCode() == -204) {
                        existsData = false;
                        loc.warningT(cat, "Table {0} does not exist on database.", new Object[]{tableName});
                    } else {
                        existsData = true;
                        loc.errorT(cat, "Exception {0} caught executing {1}.\n Return {2}.", new Object[]{sqlEx.getMessage(), stmtStr, new Boolean(existsData)});
                    }
                    Object var10_8 = null;
                    try {
                        rs.close();
                        pstmt.close();
                    }
                    catch (Exception e2) {
                        loc.warningT(cat, "Exception caught closing statement resources:\n {0}", new Object[]{e2.getMessage()});
                    }
                    break block14;
                }
                catch (Exception e) {
                    existsData = true;
                    loc.errorT(cat, "Exception {0} caught executing {1}.\n Return {2}.", new Object[]{e.getMessage(), stmtStr, new Boolean(existsData)});
                    Object var10_9 = null;
                    try {
                        rs.close();
                        pstmt.close();
                    }
                    catch (Exception e2) {
                        loc.warningT(cat, "Exception caught closing statement resources:\n {0}", new Object[]{e2.getMessage()});
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                try {
                    rs.close();
                    pstmt.close();
                }
                catch (Exception e2) {
                    loc.warningT(cat, "Exception caught closing statement resources:\n {0}", new Object[]{e2.getMessage()});
                }
                throw throwable;
            }
        }
        loc.infoT(cat, "existsData() returns {0}.", new Object[]{new Boolean(existsData)});
        loc.exiting();
        return existsData;
    }

    public boolean checkWidth() {
        loc.entering(cat, "checkWidth()");
        boolean widthOk = true;
        int fixedLength = 0;
        int numberOfColumns = 0;
        boolean sqlType = false;
        int multiplier = 1;
        long realLength = 0L;
        DbDb4Column col = null;
        DbColumnIterator iter = this.getColumns().iterator();
        while (iter.hasNext()) {
            col = (DbDb4Column)iter.next();
            ++numberOfColumns;
            multiplier = 1;
            switch (col.getJavaSqlType()) {
                case -1: 
                case 12: {
                    multiplier = 2;
                }
                case -4: 
                case -3: {
                    fixedLength = (int)((long)fixedLength + ((long)multiplier * col.getLengthOrDdlDefaultLength() + 2L));
                    break;
                }
                case -2: {
                    fixedLength = (int)((long)fixedLength + (long)multiplier * col.getLengthOrDdlDefaultLength());
                    break;
                }
                case 2005: {
                    multiplier = 2;
                }
                case 2004: {
                    fixedLength += 32;
                    break;
                }
                case 5: {
                    fixedLength += 2;
                    break;
                }
                case 4: {
                    fixedLength += 4;
                    break;
                }
                case -5: {
                    fixedLength += 8;
                    break;
                }
                case 7: {
                    fixedLength += 4;
                    break;
                }
                case 8: {
                    fixedLength += 8;
                    break;
                }
                case 91: {
                    fixedLength += 10;
                    break;
                }
                case 92: {
                    fixedLength += 8;
                    break;
                }
                case 93: {
                    fixedLength += 26;
                    break;
                }
                case 3: {
                    fixedLength = (int)((long)fixedLength + (col.getLengthOrDdlDefaultLength() / 2L + 1L));
                    break;
                }
                default: {
                    loc.errorT(cat, "Invalid type {0}.", new Object[]{new Integer(col.getJavaSqlType())});
                    widthOk = false;
                }
            }
        }
        fixedLength += (numberOfColumns + 7) / 8 * 8;
        if ((fixedLength += 64) > DbDb4Environment.getMaxTableWidthBytes()) {
            widthOk = false;
        }
        DbDb4Environment.traceCheckResult(true, widthOk, cat, loc, "Table {0}: fixed length: {1} ({2}).", new Object[]{this.getName(), new Integer(fixedLength), new Integer(DbDb4Environment.getMaxTableWidthBytes()), new Boolean(widthOk)});
        loc.exiting();
        return widthOk;
    }

    public boolean checkNameLength() {
        boolean isOk = this.getName().trim().length() <= DbDb4Environment.getMaxTableNameLength();
        DbDb4Environment.traceCheckResult(true, isOk, cat, loc, "checkNameLength() returns {0}.", new Object[]{new Boolean(isOk)});
        return isOk;
    }

    public boolean checkNameForReservedWord() {
        boolean isReserved = !DbDb4Environment.isReservedWord(this.getName());
        DbDb4Environment.traceCheckResult(true, isReserved, cat, loc, "checkNameForReservedWord() returns {0}.", new Object[]{new Boolean(isReserved)});
        return isReserved;
    }

    /*
     * Loose catch block
     */
    private ArrayList getIndexNamesViaDb(DbFactory factory) throws JddException {
        ArrayList<String> indexNames;
        block10: {
            loc.entering(cat, "getIndexesViaDb(Connection)");
            indexNames = new ArrayList<String>();
            String tableName = null;
            Connection con = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            String stmtStr = "SELECT INDEX_NAME FROM SYSINDEXES WHERE TABLE_NAME = ?";
            tableName = this.getName();
            if (tableName == null) {
                loc.errorT(cat, "Empty table name.");
                loc.exiting();
                throw new JddException(ExType.OTHER, "Empty table name.");
            }
            tableName = tableName.trim().toUpperCase();
            if (factory == null || (con = factory.getConnection()) == null) {
                loc.errorT(cat, "No connection.");
                loc.exiting();
                throw new JddException(ExType.OTHER, "No connection.");
            }
            pstmt = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)stmtStr);
            pstmt.setString(1, tableName);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                indexNames.add(rs.getString(1));
            }
            Object var10_8 = null;
            try {
                rs.close();
                pstmt.close();
                break block10;
            }
            catch (Exception e) {
                loc.warningT(cat, "Exception caught closing statement resources:\n {0}", new Object[]{e.getMessage()});
            }
            {
                break block10;
                catch (SQLException sqlEx) {
                    loc.errorT(cat, "Exception caught executing {0}:\n{1}", new Object[]{stmtStr, sqlEx.getMessage()});
                    loc.exiting();
                    throw JddException.createInstance(sqlEx);
                }
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                try {
                    rs.close();
                    pstmt.close();
                }
                catch (Exception e) {
                    loc.warningT(cat, "Exception caught closing statement resources:\n {0}", new Object[]{e.getMessage()});
                }
                loc.exiting();
                throw throwable;
            }
        }
        loc.exiting();
        return indexNames;
    }

    private DbDb4Index setIndexViaDb(String indexName) throws JddException {
        loc.entering(cat, "setIndexViaDb({0})", new Object[]{indexName});
        DbDb4Index index = new DbDb4Index(this.getDbFactory(), this.getSchema(), this.getName(), indexName);
        index.setCommonContentViaDb();
        index.setSpecificContentViaDb();
        loc.exiting();
        return index;
    }
}

