/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db4;

import com.sap.dictionary.database.dbs.ExType;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.Hashtable;

public class DbDb4HexString {
    private static Location loc = Logger.getLocation("db4.DbDb4HexString");
    private static Category cat = Logger.getCategory();
    private static final Hashtable convTab = new Hashtable(32);
    private String javaString;
    private String hexString;

    public DbDb4HexString(String javaString, String hexString) throws Exception {
        if (javaString != null && hexString != null) {
            throw new JddException(ExType.OTHER, "DbDb4HexString: At least one parameter must be null. (" + javaString + ", " + hexString + ")");
        }
        if (javaString != null) {
            this.javaString = javaString;
            this.hexString = DbDb4HexString.convertToHex(javaString);
        } else {
            this.javaString = DbDb4HexString.convertToString(hexString);
            this.hexString = hexString;
        }
    }

    public String getJavaString() {
        return this.javaString;
    }

    public String getHexString() {
        return this.hexString;
    }

    private static String convertToHex(String javaString) throws Exception {
        int[] base16Vals = new int[]{1, 16, 256, 4096};
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] hexCharArray = new char[4 * javaString.length()];
        int codepoint = 0;
        int digit = 0;
        if (javaString != null) {
            int pos = 0;
            int i = 0;
            while (i < javaString.length()) {
                codepoint = javaString.charAt(i);
                int j = 3;
                while (j >= 0) {
                    digit = codepoint / base16Vals[j];
                    hexCharArray[pos] = hexChars[digit];
                    codepoint %= base16Vals[j];
                    ++pos;
                    --j;
                }
                ++i;
            }
        }
        return new String(hexCharArray);
    }

    private static String convertToString(String hexString) throws Exception {
        char[] charArray = new char[hexString.length() / 4];
        int[] base16Vals = new int[]{1, 16, 256, 4096};
        Object unicodeString = null;
        int pos = 0;
        int codepoint = 0;
        if (hexString != null) {
            int i = 0;
            while (i < hexString.length() / 4) {
                codepoint = 0;
                int j = 3;
                while (j >= 0) {
                    codepoint += (Integer)convTab.get(new Character(hexString.charAt(pos))) * base16Vals[j];
                    ++pos;
                    --j;
                }
                charArray[i] = (char)codepoint;
                ++i;
            }
        }
        return new String(charArray);
    }

    static {
        convTab.put(new Character('0'), new Integer(0));
        convTab.put(new Character('1'), new Integer(1));
        convTab.put(new Character('2'), new Integer(2));
        convTab.put(new Character('3'), new Integer(3));
        convTab.put(new Character('4'), new Integer(4));
        convTab.put(new Character('5'), new Integer(5));
        convTab.put(new Character('6'), new Integer(6));
        convTab.put(new Character('7'), new Integer(7));
        convTab.put(new Character('8'), new Integer(8));
        convTab.put(new Character('9'), new Integer(9));
        convTab.put(new Character('A'), new Integer(10));
        convTab.put(new Character('a'), new Integer(10));
        convTab.put(new Character('B'), new Integer(11));
        convTab.put(new Character('b'), new Integer(11));
        convTab.put(new Character('C'), new Integer(12));
        convTab.put(new Character('c'), new Integer(12));
        convTab.put(new Character('D'), new Integer(13));
        convTab.put(new Character('d'), new Integer(13));
        convTab.put(new Character('E'), new Integer(14));
        convTab.put(new Character('e'), new Integer(14));
        convTab.put(new Character('F'), new Integer(15));
        convTab.put(new Character('f'), new Integer(15));
    }
}

