/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db2;

import com.sap.dictionary.database.db2.DbDb2PartAttr;
import com.sap.dictionary.database.db2.DbDb2Table;
import com.sap.dictionary.database.db2.DbDb2TsAttr;
import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbTable;
import com.sap.dictionary.database.dbs.DbTableDifference;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.tc.logging.Location;

public class DbDb2TableDifference
extends DbTableDifference {
    private boolean alterPriqty = false;
    private boolean alterSecqty = false;
    private boolean alterPctfree = false;
    private boolean alterBufferpool = false;
    private boolean alterFreepage = false;
    private boolean alterLockrule = false;
    private boolean alterLockmax = false;
    private boolean alterPagesize = false;
    private boolean alterSegsize = false;
    private boolean alterCloserule = false;
    private boolean alterDefine = false;
    private boolean alterCompress = false;
    private boolean alterMaxrows = false;
    private boolean alterMemclust = false;
    private boolean alterGbpcache = false;
    private boolean addLobView = false;
    private static Location loc = Logger.getLocation("db2.DbDb2TableDifference");
    Action tblspAction = Action.NOTHING;

    public DbDb2TableDifference(DbTable refTable, DbTable cmpTable) {
        super(refTable, cmpTable);
        DbDb2Table db2refTable = (DbDb2Table)refTable;
        DbDb2Table db2cmpTable = (DbDb2Table)cmpTable;
    }

    public DbObjectSqlStatements getDdlStatements(String tableName, DbTable tableForStorageInfo) throws Exception {
        DbObjectSqlStatements stmts = new DbObjectSqlStatements(tableName);
        if (this.addLobView) {
            stmts.add(((DbDb2Table)this.getOrigin()).getDdlStatementForCreateLobView(this.getOrigin().getColumns()));
        }
        if ((this.getAction() == Action.NOTHING || this.getAction() == Action.ALTER) && this.tblspAction == Action.ALTER) {
            stmts.merge(((DbDb2Table)this.getTarget()).getDdlStatementsforAlterTsp());
        }
        stmts.merge(super.getDdlStatements(tableName, tableForStorageInfo));
        return stmts;
    }

    public void diffLobView(DbDb2Table refTable) {
        loc.entering("diffLobView");
        if (refTable.isLobViewMissing()) {
            Object[] arguments = new Object[]{refTable.getName()};
            loc.infoT("diffLobView {0}: alter necessary: view to hide rowid field missing.", arguments);
            this.setAction(Action.ALTER);
            this.addLobView = true;
        }
        loc.exiting();
    }

    public void diffPageSize(DbDb2Table refTable, DbDb2Table cmpTable) {
        loc.entering("diffPageSize");
        if (cmpTable.getTsAttr().getPageSize() > refTable.getTsAttr().getPageSize()) {
            Object[] arguments = new Object[]{refTable.getName(), new Integer(refTable.getTsAttr().getPageSize()), new Integer(cmpTable.getTsAttr().getPageSize())};
            loc.infoT("diffPageSize {0}: conversion necessary: original page size {1} smaller than target page size {2}", arguments);
            this.setAction(Action.CONVERT);
        }
        loc.exiting();
    }

    public void diffSpecificContent(DbDb2Table refTable, DbDb2Table cmpTable) {
        Object[] arguments;
        loc.entering("diffSpecificContent");
        if (this.getAction() != null && this.getAction() != Action.NOTHING && this.getAction() != Action.ALTER) {
            return;
        }
        DbDb2TsAttr refTsAttr = refTable.getTsAttr();
        DbDb2PartAttr refPartAttr = refTsAttr.getFirstPart();
        DbDb2TsAttr cmpTsAttr = cmpTable.getTsAttr();
        DbDb2PartAttr cmpPartAttr = cmpTsAttr.getFirstPart();
        if (refPartAttr.getPriQty() != cmpPartAttr.getPriQty()) {
            arguments = new Object[]{refTable.getName(), new Integer(refPartAttr.getPriQty()), new Integer(cmpPartAttr.getPriQty())};
            loc.infoT(" (diffSpecificContent {0}): alter tablespace: original primary quantity ({1}) differs from target primary quantity ({2}).", arguments);
            this.alterPriqty = true;
        }
        if (refPartAttr.getSecQty() != cmpPartAttr.getSecQty()) {
            arguments = new Object[]{refTable.getName(), new Integer(refPartAttr.getSecQty()), new Integer(cmpPartAttr.getSecQty())};
            loc.infoT(" (diffSpecificContent {0}): alter tablespace: original secondary quantity ({1}) differs from target secondary quantity ({2}).", arguments);
            this.alterSecqty = true;
        }
        if (refPartAttr.getFreePage() != cmpPartAttr.getFreePage()) {
            arguments = new Object[]{refTable.getName(), new Integer(refPartAttr.getFreePage()), new Integer(cmpPartAttr.getFreePage())};
            loc.infoT(" (diffSpecificContent {0}): alter tablespace: original freepage ({1}) differs from target freepage ({2}).", arguments);
            this.alterFreepage = true;
        }
        if (refPartAttr.getPctFree() != cmpPartAttr.getPctFree()) {
            arguments = new Object[]{refTable.getName(), new Integer(refPartAttr.getPctFree()), new Integer(cmpPartAttr.getPctFree())};
            loc.infoT(" (diffSpecificContent {0}): alter tablespace: original pctfree ({1}) differs from target pctfree ({2}).", arguments);
            this.alterPctfree = true;
        }
        if (0 != refPartAttr.getCompress().compareTo(cmpPartAttr.getCompress())) {
            arguments = new Object[]{refTable.getName(), refPartAttr.getCompress(), cmpPartAttr.getCompress()};
            loc.infoT(" (diffSpecificContent {0}): alter tablespace: original compress ({1}) differs from target compress ({2}).", arguments);
            this.alterCompress = true;
        }
        if (0 != refTsAttr.getLockRule().compareTo(cmpTsAttr.getLockRule())) {
            arguments = new Object[]{refTable.getName(), refTsAttr.getLockRule(), cmpTsAttr.getLockRule()};
            loc.infoT(" (diffSpecificContent {0}): alter tablespace: original lockrule ({1}) differs from target lockrule ({2}).", arguments);
            this.alterLockrule = true;
        }
        if (0 != refTsAttr.getClose().compareTo(cmpTsAttr.getClose())) {
            arguments = new Object[]{refTable.getName(), refTsAttr.getClose(), cmpTsAttr.getClose()};
            loc.infoT(" (diffSpecificContent {0}): alter tablespace: original closerule ({1}) differs from target closerule ({2}).", arguments);
            this.alterCloserule = true;
        }
        if (refTsAttr.getLockMax() != cmpTsAttr.getLockMax()) {
            arguments = new Object[]{refTable.getName(), new Integer(refTsAttr.getLockMax()), new Integer(cmpTsAttr.getLockMax())};
            loc.infoT(" (diffSpecificContent {0}): alter tablespace: original lockmax ({1}) differs from target lockmax ({2}).", arguments);
            this.alterLockmax = true;
        }
        if (this.alterPriqty || this.alterSecqty || this.alterPctfree || this.alterBufferpool || this.alterFreepage || this.alterLockrule || this.alterLockmax || this.alterCloserule || this.alterCompress || this.alterGbpcache) {
            this.setAction(Action.ALTER);
            this.tblspAction = Action.ALTER;
        }
        if (0 != refPartAttr.getDefine().compareTo(cmpPartAttr.getDefine())) {
            this.alterDefine = true;
            if (!refTable.existsData()) {
                this.setAction(Action.DROP_CREATE);
                this.tblspAction = Action.DROP_CREATE;
            }
        }
        loc.exiting();
    }

    public Action getTblspAction() {
        return this.tblspAction;
    }

    public boolean getLobViewMissing() {
        return this.addLobView;
    }
}

