/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db2;

import com.sap.dictionary.database.db2.DbDb2Environment;
import com.sap.dictionary.database.db2.DbDb2Parameters;
import com.sap.dictionary.database.db2.DbDb2PrimaryKey;
import com.sap.dictionary.database.db2.DbDb2Table;
import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbPrimaryKey;
import com.sap.dictionary.database.dbs.DbPrimaryKeyDifference;
import com.sap.dictionary.database.dbs.DbTable;
import com.sap.dictionary.database.dbs.ExType;
import com.sap.dictionary.database.dbs.JddException;

public class DbDb2PrimaryKeyDifference
extends DbPrimaryKeyDifference {
    public DbDb2PrimaryKeyDifference(DbPrimaryKey origin, DbPrimaryKey target, Action action) {
        super(origin, target, action);
    }

    public DbObjectSqlStatements getDdlStatements(String tableName) throws JddException {
        Action action = this.getAction();
        DbObjectSqlStatements statements = null;
        if (action == Action.CREATE) {
            statements = this.getTarget().getDdlStatementsForCreate();
        } else if (action == Action.DROP) {
            statements = this.getOrigin().getDdlStatementsForDrop();
        } else if (action == Action.DROP_CREATE) {
            if (!DbDb2Parameters.isV8()) {
                DbTable tabo = this.getOrigin().getTable();
                DbTable tabt = this.getTarget().getTable();
                if (tabo instanceof DbDb2Table && tabt instanceof DbDb2Table && !DbDb2Environment.hasLobs(tabo) && DbDb2Environment.hasLobs(tabt)) {
                    ((DbDb2Table)tabo).setDbTableName(((DbDb2Table)tabt).getDbTableName());
                }
            }
            if (!this.getTarget().getDbSpecificIsSet()) {
                if (!this.getOrigin().getDbSpecificIsSet()) {
                    this.getOrigin().setSpecificContentViaDb();
                }
                if (this.getTarget() instanceof DbDb2PrimaryKey) {
                    ((DbDb2PrimaryKey)this.getTarget()).setSpecificContentViaRef((DbDb2PrimaryKey)this.getOrigin());
                }
            }
            statements = this.getOrigin().getDdlStatementsForDrop();
            statements.merge(this.getTarget().getDdlStatementsForCreate());
        } else {
            throw new JddException(ExType.OTHER, "getDdlStatements: action " + action.getName() + " not supported");
        }
        return statements;
    }

    public DbObjectSqlStatements getDdlStatements(String tableName, DbTable tableForStorageInfo) throws JddException {
        return this.getDdlStatements(tableName);
    }
}

