/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.catalog;

import com.sap.dictionary.database.catalog.DbGeneralStructure;
import com.sap.dictionary.database.dbs.Database;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.ExType;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.sql.catalog.CatalogReader;
import com.sap.sql.catalog.Table;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class XmlCatalogReader
implements CatalogReader {
    private ClassLoader loader = null;
    private Connection con = null;
    private DbFactory factory = new DbFactory(Database.ARTIFICIAL);

    public XmlCatalogReader(ClassLoader loader) {
        this.loader = loader;
    }

    public XmlCatalogReader(String path) throws SQLException {
        this.loader = this.getClassLoader(path);
        if (this.loader == null) {
            throw new SQLException("no catalog reader can be constructed from the path: " + path);
        }
    }

    public XmlCatalogReader(Connection con) {
        this.con = con;
    }

    public Table getTable(String schemaName, String tableName) throws SQLException {
        DbGeneralStructure gs = null;
        try {
            gs = this.con != null ? new DbGeneralStructure(tableName, this.con, "dbs", this.factory) : new DbGeneralStructure(tableName, this.loader, this.factory);
            if (tableName.compareTo(gs.getName()) != 0) {
                return null;
            }
        }
        catch (JddException ex) {
            if (ex.getExType() == ExType.SQL_ERROR) {
                throw new SQLException(ex.getMessage());
            }
            if (ex.getExType() == ExType.XML_ERROR) {
                throw new IllegalStateException(ex.getMessage());
            }
            if (ex.getExType() == ExType.NOT_ON_DB) {
                return null;
            }
            return null;
        }
        return gs;
    }

    public Table getTable(String tableName) throws SQLException {
        DbGeneralStructure gs = null;
        try {
            gs = this.con != null ? new DbGeneralStructure(tableName, this.con, "dbs", this.factory) : new DbGeneralStructure(tableName, this.loader, this.factory);
            if (tableName.compareTo(gs.getName()) != 0) {
                return null;
            }
        }
        catch (JddException ex) {
            if (ex.getExType() == ExType.SQL_ERROR) {
                throw new SQLException(ex.getMessage());
            }
            if (ex.getExType() == ExType.XML_ERROR) {
                throw new IllegalStateException(ex.getMessage());
            }
            if (ex.getExType() == ExType.NOT_ON_DB) {
                return null;
            }
            return null;
        }
        return gs;
    }

    public boolean existsTable(String tableName) throws SQLException {
        return this.getTable(tableName) != null;
    }

    public boolean existsTable(String schemaName, String tableName) throws SQLException {
        return this.getTable(schemaName, tableName) != null;
    }

    public boolean isLogicalCatalogReader() {
        return true;
    }

    private ClassLoader getClassLoader(String path) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (path != null) {
            StringTokenizer tokenizer = new StringTokenizer(path, File.pathSeparator);
            while (tokenizer.hasMoreTokens()) {
                String name = tokenizer.nextToken();
                File file = new File(name);
                if (!file.exists()) continue;
                try {
                    try {
                        file = file.getCanonicalFile();
                    }
                    catch (IOException ex) {
                        throw new IllegalStateException("if the file exists, it must have a canonical path");
                    }
                    arrayList.add(file.toURL());
                }
                catch (MalformedURLException ex) {
                    throw new IllegalStateException("if the file exists, the URL cannot be malformed");
                }
            }
        }
        URL[] urls = new URL[arrayList.size()];
        if ((urls = arrayList.toArray(urls)).length == 0) {
            return null;
        }
        return new MyClassLoader(urls);
    }

    class MyClassLoader
    extends URLClassLoader {
        public MyClassLoader(URL[] arg0) {
            super(arg0, (ClassLoader)null);
        }

        public InputStream getResourceAsStream(String name) {
            URL url = this.getResource(name);
            if (url != null) {
                try {
                    URLConnection urlConnection = url.openConnection();
                    urlConnection.setUseCaches(false);
                    return urlConnection.getInputStream();
                }
                catch (IOException e) {
                    return null;
                }
            }
            return null;
        }
    }
}

