/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.catalog;

import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumnIterator;
import com.sap.dictionary.database.dbs.DbColumns;
import com.sap.dictionary.database.dbs.DbDeploymentInfo;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbPrimaryKey;
import com.sap.dictionary.database.dbs.DbTable;
import com.sap.dictionary.database.dbs.ErrTexts;
import com.sap.dictionary.database.dbs.ExType;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.RuntimeObjectTable;
import com.sap.dictionary.database.dbs.XmlExtractor;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.sql.catalog.Column;
import com.sap.sql.catalog.ColumnIterator;
import com.sap.sql.catalog.Table;
import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.sql.Connection;
import java.util.HashMap;
import java.util.LinkedList;
import org.xml.sax.InputSource;

public class DbGeneralStructure
implements Table {
    private String name;
    private Connection connection;
    private DbTable structure;
    private DbColumns dbColumns;
    private LinkedList columns;
    private DbPrimaryKey primaryKey;
    private Boolean isBuffered;
    private String bufferingKind;
    private Boolean hasLogging;
    private static HashMap readStructures = new HashMap();

    public DbGeneralStructure(String name, ClassLoader loader, DbFactory factory) throws JddException {
        block5: {
            this.connection = null;
            this.structure = null;
            this.dbColumns = null;
            this.columns = null;
            this.primaryKey = null;
            this.isBuffered = null;
            this.bufferingKind = null;
            this.hasLogging = null;
            try {
                String filename = name + ".gdbtable";
                InputStream stream = loader.getResourceAsStream(filename);
                if (stream == null) {
                    throw new JddException(ExType.NOT_ON_DB, ErrTexts.concat(ErrTexts.get("013"), name));
                }
                this.name = name;
                this.structure = factory.makeTable(name);
                XmlExtractor extractor = new XmlExtractor();
                XmlMap xmlTableMap = null;
                InputSource source = new InputSource(stream);
                xmlTableMap = extractor.map(source);
                if (xmlTableMap != null) {
                    this.structure.setCommonContentViaXml(xmlTableMap);
                    this.dbColumns = this.structure.getColumns();
                    this.primaryKey = this.structure.getPrimaryKey();
                    if (this.dbColumns == null) {
                        throw new JddException(ExType.XML_ERROR, ErrTexts.concat(ErrTexts.get("002"), name));
                    }
                    break block5;
                }
                throw new JddException(ExType.XML_ERROR, ErrTexts.concat(ErrTexts.get("002"), name));
            }
            catch (Exception ex) {
                throw JddException.createInstance(ex);
            }
        }
    }

    public DbGeneralStructure(String name, Connection con, String src, DbFactory factory) throws JddException {
        this.connection = null;
        this.structure = null;
        this.dbColumns = null;
        this.columns = null;
        this.primaryKey = null;
        this.isBuffered = null;
        this.bufferingKind = null;
        this.hasLogging = null;
        this.name = name;
        this.connection = con;
        RuntimeObjectTable rtoTable = new RuntimeObjectTable(con, "BC_DDDBTABLERT");
        String xml = rtoTable.xmlRead(name);
        if (xml == null || xml.equalsIgnoreCase("")) {
            throw new JddException(ExType.NOT_ON_DB, ErrTexts.concat(ErrTexts.get("001"), name));
        }
        StringReader stringReader = new StringReader(xml.trim());
        try {
            this.structure = factory.makeTable(name);
        }
        catch (Exception ex) {
            throw new JddException(ExType.NOT_ON_DB, ErrTexts.concat(ErrTexts.get("013"), name));
        }
        XmlExtractor extractor = new XmlExtractor();
        XmlMap xmlTableMap = null;
        xmlTableMap = extractor.map(new InputSource(stringReader));
        if (xmlTableMap != null) {
            this.structure.setCommonContentViaXml(xmlTableMap);
            this.dbColumns = this.structure.getColumns();
            if (this.dbColumns == null) {
                throw new JddException(ExType.XML_ERROR, ErrTexts.concat(ErrTexts.get("002"), name));
            }
        } else {
            throw new JddException(ExType.XML_ERROR, ErrTexts.concat(ErrTexts.get("002"), name));
        }
        this.primaryKey = this.structure.getPrimaryKey();
    }

    public DbGeneralStructure(String name, Connection connection, DbFactory factory) throws JddException {
        this.connection = null;
        this.structure = null;
        this.dbColumns = null;
        this.columns = null;
        this.primaryKey = null;
        this.isBuffered = null;
        this.bufferingKind = null;
        this.hasLogging = null;
        try {
            this.name = name;
            this.connection = connection;
            this.structure = factory.makeTable(null, name);
            this.structure.setCommonContentViaDb(factory);
            this.dbColumns = this.structure.getColumns();
            if (this.dbColumns == null) {
                throw new JddException(ExType.NOT_ON_DB, "Table not found");
            }
            this.primaryKey = this.structure.getPrimaryKey();
        }
        catch (Exception ex) {
            throw JddException.createInstance(ex);
        }
    }

    protected DbColumns getDbColumns() {
        return this.dbColumns;
    }

    public String getName() {
        return this.structure.getName();
    }

    public String getSchemaName() {
        return null;
    }

    void setColumns() throws Exception {
        DbColumnIterator iter = this.dbColumns.iterator();
        this.columns = new LinkedList();
        while (iter.hasNext()) {
            this.columns.add(iter.next());
        }
    }

    public int getColumnCnt() {
        if (this.dbColumns != null) {
            return this.dbColumns.getColumnCnt();
        }
        return 0;
    }

    public ColumnIterator getColumns() {
        if (this.dbColumns != null) {
            DbColumnIterator iter = this.dbColumns.iterator();
            return this.mapToColumnIteratorInterface(iter, this.primaryKey);
        }
        return null;
    }

    public Column getColumn(int position) {
        if (this.dbColumns != null) {
            return this.mapToColumnInterface(this.dbColumns.getColumn(position), this.primaryKey);
        }
        return null;
    }

    public Column getColumn(String name) {
        if (this.dbColumns != null) {
            return this.mapToColumnInterface(this.dbColumns.getColumn(name), this.primaryKey);
        }
        return null;
    }

    public int getPrimaryKeyCnt() {
        if (null == this.primaryKey) {
            return 0;
        }
        return this.primaryKey.getKeyCnt();
    }

    public Column getPrimaryKeyColumn(int position) {
        if (this.primaryKey == null) {
            return null;
        }
        return this.getColumn(this.primaryKey.getKeyFieldName(position));
    }

    public int getBufferKeyCnt() {
        if (!this.isBuffered()) {
            return -1;
        }
        return this.structure.getDeploymentInfo().getGenKeyCount();
    }

    public int getTableType() {
        return 1;
    }

    private void save() {
    }

    public void saveToXmlFile(File file) {
    }

    public boolean isBuffered() {
        if (this.structure.getDeploymentInfo() == null) {
            return false;
        }
        return this.structure.getDeploymentInfo().isBuffered();
    }

    public boolean hasLogging() {
        return false;
    }

    public boolean isClientDependent() {
        return false;
    }

    public Column getClientColumn() {
        return null;
    }

    public DbGeneralStructure getSavedInstance(String name) {
        return null;
    }

    public Column mapToColumnInterface(final DbColumn dbColumn, DbPrimaryKey dbPrimaryKey) {
        if (dbColumn == null) {
            return null;
        }
        return new Column(){

            public Table getTable() {
                return DbGeneralStructure.this;
            }

            public String getName() {
                return dbColumn.getName();
            }

            public String getTypeName() {
                return dbColumn.getJavaSqlTypeName();
            }

            public int getPosition() {
                return dbColumn.getPosition();
            }

            public int getPrimaryKeyPosition() {
                if (DbGeneralStructure.this.primaryKey != null) {
                    return DbGeneralStructure.this.primaryKey.getKeyFieldPosition(dbColumn.getName());
                }
                return 0;
            }

            public boolean isPrimaryKey() {
                if (DbGeneralStructure.this.primaryKey != null) {
                    return DbGeneralStructure.this.primaryKey.isPrimaryKeyField(dbColumn.getName());
                }
                return false;
            }

            public int getJdbcType() {
                return dbColumn.getJavaSqlType();
            }

            public String getJdbcTypeName() {
                return dbColumn.getJavaSqlTypeName();
            }

            public long getSize() {
                return dbColumn.getLength();
            }

            public int getDecimals() {
                return dbColumn.getDecimals();
            }

            public boolean isNullable() {
                return !dbColumn.isNotNull();
            }

            public Object getDefault() {
                return dbColumn.getDefaultValue();
            }
        };
    }

    public ColumnIterator mapToColumnIteratorInterface(final DbColumnIterator iterator, final DbPrimaryKey primaryKey) {
        return new ColumnIterator(){

            public Column next() {
                return DbGeneralStructure.this.mapToColumnInterface(iterator.next(), primaryKey);
            }

            public boolean hasNext() {
                return iterator.hasNext();
            }
        };
    }

    public String getPredefinedAction() {
        Action action;
        DbDeploymentInfo info = this.structure.getDeploymentInfo();
        if (info != null && (action = info.getPredefinedAction()) != null) {
            return action.toString();
        }
        return "";
    }
}

