/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.ui.cool.metadata;

import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.ui.cool.metadata.AspectActionDescriptor;
import com.sap.caf.rt.ui.cool.metadata.AspectDescriptor;
import com.sap.caf.rt.ui.cool.metadata.FieldDescriptor;
import com.sap.caf.rt.ui.cool.metadata.IServiceModelProvider;
import com.sap.caf.rt.ui.cool.metadata.KeyAspectDescriptor;
import com.sap.caf.rt.ui.cool.metadata.QueryDescriptor;
import com.sap.caf.rt.ui.cool.metadata.RelationDescriptor;
import com.sap.caf.rt.ui.cool.metadata.ServiceModuleDescriptor;
import com.sap.caf.rt.ui.cool.metadata.StructureDescriptor;
import com.sap.tc.cmi.metadata.CMICardinality;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;

public class ServiceModelProviderImpl
implements IServiceModelProvider {
    public static final String STUDENT_SERVICE_NAME = "sap.com/rixapp/StudentService";
    public static final String COURSE_SERVICE_NAME = "sap.com/rixapp/CourseService";
    public static final String TEACHER_SERVICE_NAME = "sap.com/rixapp/TeacherService";
    public static final String ADDRESS_SERVICE_NAME = "sap.com/rixapp/AddressService";
    ServiceModuleDescriptor smdStudent = null;
    ServiceModuleDescriptor smdCourse = null;
    ServiceModuleDescriptor smdTeacher = null;
    ServiceModuleDescriptor smdAddress = null;

    public void init() {
        String description = "some description";
        this.smdStudent = new ServiceModuleDescriptor(STUDENT_SERVICE_NAME, description, "configuration", "configuration desc", Locale.getDefault());
        this.smdCourse = new ServiceModuleDescriptor(COURSE_SERVICE_NAME, description, "configuration", "configuration desc", Locale.getDefault());
        this.smdTeacher = new ServiceModuleDescriptor(TEACHER_SERVICE_NAME, description, "configuration", "configuration desc", Locale.getDefault());
        this.smdAddress = new ServiceModuleDescriptor(ADDRESS_SERVICE_NAME, description, "configuration", "configuration desc", Locale.getDefault());
        FieldDescriptor[] fields = new FieldDescriptor[]{new FieldDescriptor("key", "STRING"), new FieldDescriptor("firstName", "STRING"), new FieldDescriptor("lastName", "STRING"), new FieldDescriptor("averageGrade", "INTEGER"), new FieldDescriptor("rewardPoints", "INTEGER")};
        FieldDescriptor[] collFields = new FieldDescriptor[]{new FieldDescriptor("key", "STRING"), new FieldDescriptor("value", "STRING")};
        StructureDescriptor structureDescriptor = new StructureDescriptor(this.smdStudent, "structureDescriptor", fields);
        FieldDescriptor[] keyFields = new FieldDescriptor[]{new FieldDescriptor("key", "STRING")};
        StructureDescriptor keyStructure = new StructureDescriptor(this.smdStudent, "keyStructure", keyFields);
        KeyAspectDescriptor keyAspectDescriptorStudent = new KeyAspectDescriptor(this.smdStudent, "StudentKey", "StudentKey desc", keyStructure);
        AspectDescriptor aspectDescriptorStudent = new AspectDescriptor(this.smdStudent, "Student", "student aspect", structureDescriptor, keyAspectDescriptorStudent);
        FieldDescriptor[] findFields = new FieldDescriptor[]{new FieldDescriptor("firstName", "STRING")};
        StructureDescriptor structureQueryDescriptor = new StructureDescriptor(this.smdStudent, "structureQueryDescriptor", findFields);
        aspectDescriptorStudent.addAspectActionDescriptor(new AspectActionDescriptor("findByFirstName", structureQueryDescriptor, aspectDescriptorStudent));
        QueryDescriptor queryDescriptor = new QueryDescriptor("findByFirstName", "findByFirstName desc", keyAspectDescriptorStudent, structureQueryDescriptor, aspectDescriptorStudent, this.smdStudent);
        this.smdStudent.addQueryDescriptor(queryDescriptor);
        FieldDescriptor[] fieldsCourse = new FieldDescriptor[]{new FieldDescriptor("key", "STRING"), new FieldDescriptor("description", "STRING")};
        StructureDescriptor structureDescriptorCourse = new StructureDescriptor(this.smdCourse, "structureDescriptor", fieldsCourse);
        FieldDescriptor[] keyFieldsCourse = new FieldDescriptor[]{new FieldDescriptor("key", "STRING")};
        StructureDescriptor keyStructureCourse = new StructureDescriptor(this.smdCourse, "keyStructureCourse", keyFieldsCourse);
        KeyAspectDescriptor keyAspectDescriptorCourse = new KeyAspectDescriptor(this.smdCourse, "CourseKey", "CourseKey desc", keyStructureCourse);
        AspectDescriptor aspectDescriptorCourse = new AspectDescriptor(this.smdCourse, "Course", "course aspect", structureDescriptorCourse, keyAspectDescriptorCourse);
        FieldDescriptor[] findFieldsCourse = new FieldDescriptor[]{};
        StructureDescriptor structureQueryDescriptorCourse = new StructureDescriptor(this.smdCourse, "structureQueryDescriptorCourse", findFieldsCourse);
        aspectDescriptorCourse.addAspectActionDescriptor(new AspectActionDescriptor("findAllCourses", structureQueryDescriptorCourse, aspectDescriptorCourse));
        QueryDescriptor queryDescriptorCourse = new QueryDescriptor("findAllCourses", "findAllCourses desc", keyAspectDescriptorCourse, structureQueryDescriptorCourse, aspectDescriptorCourse, this.smdCourse);
        this.smdCourse.addQueryDescriptor(queryDescriptorCourse);
        RelationDescriptor relationDescriptorC_S = new RelationDescriptor(aspectDescriptorCourse.getName() + ":students", CMICardinality.CARDINALITY_MANY, aspectDescriptorCourse, aspectDescriptorStudent);
        relationDescriptorC_S.addAttribute("collection", "true");
        relationDescriptorC_S.addAttribute("relation_attribute", "students");
        aspectDescriptorCourse.addRelationDescriptor(relationDescriptorC_S);
        this.smdCourse.addRelationDescriptor(relationDescriptorC_S);
        FieldDescriptor[] fieldsTeacher = new FieldDescriptor[]{new FieldDescriptor("key", "STRING"), new FieldDescriptor("name", "STRING"), new FieldDescriptor("description", "STRING"), new FieldDescriptor("age", "INTEGER"), new FieldDescriptor("id", "STRING")};
        StructureDescriptor structureDescriptorTeacher = new StructureDescriptor(this.smdTeacher, "structureDescriptor", fieldsTeacher);
        FieldDescriptor[] keyFieldsTeacher = new FieldDescriptor[]{new FieldDescriptor("key", "STRING")};
        StructureDescriptor keyStructureTeacher = new StructureDescriptor(this.smdTeacher, "keyStructureTeacher", keyFieldsTeacher);
        KeyAspectDescriptor keyAspectDescriptorTeacher = new KeyAspectDescriptor(this.smdTeacher, "TeacherKey", "TeacherKey desc", keyStructureTeacher);
        AspectDescriptor aspectDescriptorTeacher = new AspectDescriptor(this.smdTeacher, "Teacher", "Teacher aspect", structureDescriptorTeacher, keyAspectDescriptorTeacher);
        FieldDescriptor[] findFieldsTeacher = new FieldDescriptor[]{};
        StructureDescriptor structureQueryDescriptorTeacher = new StructureDescriptor(this.smdTeacher, "structureQueryDescriptorTeacher", findFieldsTeacher);
        aspectDescriptorTeacher.addAspectActionDescriptor(new AspectActionDescriptor("findAllTeachers", structureQueryDescriptorTeacher, aspectDescriptorTeacher));
        QueryDescriptor queryDescriptorTeacher = new QueryDescriptor("findAllTeachers", "findAllTeachers desc", keyAspectDescriptorTeacher, structureQueryDescriptorTeacher, aspectDescriptorTeacher, this.smdTeacher);
        this.smdTeacher.addQueryDescriptor(queryDescriptorTeacher);
        RelationDescriptor relationDescriptorT_C = new RelationDescriptor(aspectDescriptorTeacher.getName() + ":course", CMICardinality.CARDINALITY_ZERO_TO_ONE, aspectDescriptorTeacher, aspectDescriptorCourse);
        relationDescriptorT_C.addAttribute("source_ref_attribute", "course");
        aspectDescriptorTeacher.addRelationDescriptor(relationDescriptorT_C);
        this.smdTeacher.addRelationDescriptor(relationDescriptorT_C);
        FieldDescriptor[] fieldsAddress = new FieldDescriptor[]{new FieldDescriptor("key", "STRING"), new FieldDescriptor("country", "STRING"), new FieldDescriptor("city", "STRING"), new FieldDescriptor("street", "STRING"), new FieldDescriptor("pcode", "STRING"), new FieldDescriptor("id", "INTEGER")};
        StructureDescriptor structureDescriptorAddress = new StructureDescriptor(this.smdAddress, "structureDescriptor", fieldsAddress);
        FieldDescriptor[] keyFieldsAddress = new FieldDescriptor[]{new FieldDescriptor("key", "STRING")};
        StructureDescriptor keyStructureAddress = new StructureDescriptor(this.smdAddress, "keyStructureAddress", keyFieldsAddress);
        KeyAspectDescriptor keyAspectDescriptorAddress = new KeyAspectDescriptor(this.smdAddress, "AddressKey", "AddressKey desc", keyStructureAddress);
        AspectDescriptor aspectDescriptorAddress = new AspectDescriptor(this.smdAddress, "Address", "Address aspect", structureDescriptorAddress, keyAspectDescriptorAddress);
        FieldDescriptor[] findFieldsAddress = new FieldDescriptor[]{};
        StructureDescriptor structureQueryDescriptorAddress = new StructureDescriptor(this.smdAddress, "structureQueryDescriptorAddress", findFieldsAddress);
        aspectDescriptorAddress.addAspectActionDescriptor(new AspectActionDescriptor("findAllAddresss", structureQueryDescriptorAddress, aspectDescriptorAddress));
        QueryDescriptor queryDescriptorAddress = new QueryDescriptor("findAllAddresss", "findAllAddresss desc", keyAspectDescriptorAddress, structureQueryDescriptorAddress, aspectDescriptorAddress, this.smdAddress);
        this.smdAddress.addQueryDescriptor(queryDescriptorAddress);
        RelationDescriptor relationDescriptorS_C = new RelationDescriptor(aspectDescriptorStudent.getName() + ":courses", CMICardinality.CARDINALITY_MANY, aspectDescriptorStudent, aspectDescriptorCourse);
        relationDescriptorS_C.addAttribute("collection", "true");
        relationDescriptorS_C.addAttribute("source_ref_attribute", "courses");
        aspectDescriptorStudent.addRelationDescriptor(relationDescriptorS_C);
        this.smdStudent.addRelationDescriptor(relationDescriptorS_C);
        RelationDescriptor relationDescriptorS_A = new RelationDescriptor(aspectDescriptorStudent.getName() + ":address", CMICardinality.CARDINALITY_MANY, aspectDescriptorStudent, aspectDescriptorAddress);
        relationDescriptorS_A.addAttribute("collection", "true");
        relationDescriptorS_A.addAttribute("source_ref_attribute", "addresses");
        aspectDescriptorStudent.addRelationDescriptor(relationDescriptorS_A);
        this.smdStudent.addRelationDescriptor(relationDescriptorS_A);
        RelationDescriptor relationDescriptorT_A = new RelationDescriptor(aspectDescriptorTeacher.getName() + ":address", CMICardinality.CARDINALITY_MANY, aspectDescriptorTeacher, aspectDescriptorAddress);
        relationDescriptorT_A.addAttribute("collection", "true");
        relationDescriptorT_A.addAttribute("source_ref_attribute", "addresses");
        aspectDescriptorTeacher.addRelationDescriptor(relationDescriptorT_A);
        this.smdTeacher.addRelationDescriptor(relationDescriptorT_A);
    }

    public Collection getServiceNames() throws RemoteException, ServiceException {
        ArrayList<String> coll = new ArrayList<String>();
        coll.add(STUDENT_SERVICE_NAME);
        coll.add(COURSE_SERVICE_NAME);
        coll.add(TEACHER_SERVICE_NAME);
        coll.add(ADDRESS_SERVICE_NAME);
        return coll;
    }

    public String getServiceModuleJndiKeys(String serviceName) throws RemoteException, ServiceException {
        return "localejbs/" + serviceName;
    }

    public ServiceModuleDescriptor getServiceModuleDescriptor(String serviceName) throws RemoteException, ServiceException {
        if (this.smdStudent == null || this.smdCourse == null || this.smdTeacher == null || this.smdAddress == null) {
            this.init();
        }
        if (serviceName.equals(STUDENT_SERVICE_NAME)) {
            return this.smdStudent;
        }
        if (serviceName.equals(COURSE_SERVICE_NAME)) {
            return this.smdCourse;
        }
        if (serviceName.equals(TEACHER_SERVICE_NAME)) {
            return this.smdTeacher;
        }
        if (serviceName.equals(ADDRESS_SERVICE_NAME)) {
            return this.smdAddress;
        }
        throw new ServiceException("Service not found");
    }
}

