/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.ui.cool.metadata;

import com.sap.caf.rt.ui.cool.metadata.AbstractDescriptor;
import com.sap.caf.rt.ui.cool.metadata.AspectDescriptor;
import com.sap.caf.rt.ui.cool.metadata.ServiceModuleDescriptor;
import com.sap.tc.cmi.metadata.CMICardinality;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IRelationDescriptor;
import com.sap.tc.col.client.metadata.api.IServiceModuleDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import java.util.HashMap;
import java.util.Set;

public class RelationDescriptor
extends AbstractDescriptor
implements IRelationDescriptor {
    private static final CMICardinality[] sCardinalities = new CMICardinality[]{null, CMICardinality.CARDINALITY_ZERO_TO_ONE, CMICardinality.CARDINALITY_ONE, CMICardinality.CARDINALITY_MANY, CMICardinality.CARDINALITY_ONE_TO_MANY};
    private static HashMap sCardinalityMap = new HashMap(sCardinalities.length - 1);
    private HashMap mAttributes;
    private HashMap mRowAttributes;
    private AspectDescriptor targetAspectDescriptor;
    private AspectDescriptor sourceAspectDescriptor;
    private ServiceModuleDescriptor serviceModuleDescriptor;

    public RelationDescriptor() {
    }

    public RelationDescriptor(String name, AspectDescriptor sourceAspectDescriptor, AspectDescriptor targetAspectDescriptor) {
        super(name);
        this.mAttributes = new HashMap();
        this.mRowAttributes = new HashMap();
        if (targetAspectDescriptor == null) {
            throw new RuntimeException("targetAspectDescriptor must not be null");
        }
        this.targetAspectDescriptor = targetAspectDescriptor;
        if (sourceAspectDescriptor == null) {
            throw new RuntimeException("sourceAspectDescriptor must not be null");
        }
        this.sourceAspectDescriptor = sourceAspectDescriptor;
        sourceAspectDescriptor.addRelationDescriptor(this);
    }

    public RelationDescriptor(String name, CMICardinality cardinality, AspectDescriptor sourceAspectDescriptor, AspectDescriptor targetAspectDescriptor) {
        this(name, sourceAspectDescriptor, targetAspectDescriptor);
        this.setAttributeTargetCardinality(cardinality);
    }

    public IAspectDescriptor getSourceAspectDescriptor() {
        return this.sourceAspectDescriptor;
    }

    public IAspectDescriptor getTargetAspectDescriptor() {
        return this.targetAspectDescriptor;
    }

    public IServiceModuleDescriptor getServiceModuleDescriptor() {
        return this.serviceModuleDescriptor;
    }

    public void setServiceModuleDescriptor(ServiceModuleDescriptor serviceModuleDescriptor) {
        this.serviceModuleDescriptor = serviceModuleDescriptor;
    }

    public void addAttribute(String attributeName, String value) {
        this.mAttributes.put(attributeName, value);
    }

    public String getAttributeStringValue(String attributeName) {
        return (String)this.mAttributes.get(attributeName);
    }

    public String[] getAttributeNames() {
        String[] attributes = new String[this.mAttributes.size()];
        this.mAttributes.keySet().toArray(attributes);
        return attributes;
    }

    public String[] getAttributeNames(String rowKey) {
        Set attributeSet = this.mAttributes.keySet();
        HashMap rowMap = (HashMap)this.mRowAttributes.get(rowKey);
        if (rowMap != null) {
            Set dynamicAttributes = rowMap.keySet();
            attributeSet.addAll(dynamicAttributes);
        }
        String[] attributes = new String[attributeSet.size()];
        attributeSet.toArray(attributes);
        return attributes;
    }

    public String getAttributeStringValue(String rowKey, String attributeName) {
        HashMap rowMap = (HashMap)this.mRowAttributes.get(rowKey);
        if (rowMap != null && rowMap.containsKey(attributeName)) {
            return (String)rowMap.get(attributeName);
        }
        return this.getAttributeStringValue(attributeName);
    }

    void clearRowAttributes(String rowKey) {
        this.mRowAttributes.remove(rowKey);
    }

    void clearRowAttributes() {
        this.mRowAttributes.clear();
    }

    public void addAttribute(String rowKey, String attributeName, String value) {
        HashMap<String, String> rowMap = (HashMap<String, String>)this.mRowAttributes.get(rowKey);
        if (rowMap == null) {
            rowMap = new HashMap<String, String>();
            this.mRowAttributes.put(rowKey, rowMap);
        }
        rowMap.put(attributeName, value);
    }

    public String getAttributePagingMode() {
        String value = this.getAttributeStringValue("COL_PAGING_MODE");
        if (value == null) {
            throw new UnsupportedOperationException("The system property 'COL_PAGING_MODE' is not provided by the backend!");
        }
        switch (new Integer(value)) {
            case 2: {
                return "FORWARD";
            }
        }
        return " ";
    }

    public CMICardinality getAttributeTargetCardinality() {
        String value = this.getAttributeStringValue("COL_TARGET_CARDINALITY");
        if (value == null) {
            throw new UnsupportedOperationException("The system property 'COL_TARGET_CARDINALITY' is not provided for the relation '" + this.getName() + "' by the backend!");
        }
        int cardvalue = new Integer(value);
        if (cardvalue >= 0 && cardvalue < sCardinalities.length) {
            return sCardinalities[cardvalue];
        }
        throw new IllegalArgumentException("Illegal cardinality value " + cardvalue);
    }

    private void setAttributeTargetCardinality(CMICardinality cardinality) {
        this.addAttribute("COL_TARGET_CARDINALITY", ((Integer)sCardinalityMap.get(cardinality)).toString());
    }

    public IStructureDescriptor getInputOptions() {
        return this.serviceModuleDescriptor.getInputOptionsStructure();
    }

    public IStructureDescriptor getSortingOptions() {
        return this.serviceModuleDescriptor.getSortingOptionsStructure();
    }

    public IStructureDescriptor getSelections() {
        return this.serviceModuleDescriptor.getSelectionsStructure();
    }

    static {
        for (int i = 1; i < sCardinalities.length; ++i) {
            sCardinalityMap.put(sCardinalities[i], new Integer(i));
        }
    }
}

