/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.serviceaccess;

import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.srv.IDataContainerBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SimpleDataContainer
implements IDataContainerBean {
    private Map propertiesMap = new HashMap();

    public SimpleDataContainer() {
    }

    public SimpleDataContainer(List propertyNames) {
        this.setPropertyList(propertyNames);
    }

    public Object getProperty(String propertyName) {
        return this.propertiesMap.get(propertyName);
    }

    public void setProperty(String propertyName, Object propertyValue) {
        this.propertiesMap.put(propertyName, propertyValue);
    }

    public List getPropertyList() {
        return Collections.unmodifiableList(new ArrayList(this.propertiesMap.keySet()));
    }

    public void setPropertyList(List propertyNames) {
        this.propertiesMap = new HashMap();
        if (propertyNames != null) {
            int index = 0;
            Iterator it = propertyNames.iterator();
            while (it.hasNext()) {
                this.propertiesMap.put(it.next(), null);
                ++index;
            }
        }
    }

    void apply(IDependentObject depO) throws Exception {
        if (depO != null) {
            List properties = depO.getPropertyList();
            this.setPropertyList(properties);
            int size = properties.size();
            for (int i = 0; i < size; ++i) {
                String propName = (String)properties.get(i);
                ArrayList<SimpleDataContainer> v = depO.getProperty(propName);
                if (v != null) {
                    if (v instanceof IDependentObject) {
                        SimpleDataContainer sdc = new SimpleDataContainer();
                        sdc.apply((IDependentObject)((Object)v));
                        v = sdc;
                    } else if (v instanceof Collection && ((Collection)v).size() > 0) {
                        Object firstValue = null;
                        Iterator it = ((Collection)v).iterator();
                        while (it.hasNext()) {
                            firstValue = it.next();
                        }
                        if (firstValue != null && firstValue instanceof IDependentObject) {
                            ArrayList<SimpleDataContainer> collSdc = new ArrayList<SimpleDataContainer>();
                            Iterator it2 = ((Collection)v).iterator();
                            while (it2.hasNext()) {
                                Object value = it2.next();
                                if (!(value instanceof IDependentObject)) continue;
                                SimpleDataContainer sdc = new SimpleDataContainer();
                                sdc.apply((IDependentObject)value);
                                collSdc.add(sdc);
                            }
                            v = collSdc;
                        }
                    }
                }
                this.setProperty(propName, v);
            }
        }
    }
}

