/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.serviceaccess;

import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.services.serviceaccess.ICAFServiceAccess;
import com.sap.caf.rt.services.serviceaccess.MetamodelHelper;
import com.sap.caf.rt.services.serviceaccess.MetamodelHelperFactory;
import com.sap.caf.rt.services.serviceaccess.ServiceWrapper;
import com.sap.caf.rt.srv.IDataContainerBean;
import com.sap.caf.rt.ui.cool.metadata.ServiceModuleDescriptor;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.jdo.JDOException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.RollbackException;
import javax.transaction.UserTransaction;

public class CAFServiceAccessBeanImpl
implements ICAFServiceAccess {
    private static final String JARM_REQUEST = "CAF:RT:oal";
    private static final String APPLICATION = (class$com$sap$caf$rt$services$serviceaccess$CAFServiceAccessBean == null ? (class$com$sap$caf$rt$services$serviceaccess$CAFServiceAccessBean = CAFServiceAccessBeanImpl.class$("com.sap.caf.rt.services.serviceaccess.CAFServiceAccessBean")) : class$com$sap$caf$rt$services$serviceaccess$CAFServiceAccessBean).getName();
    private static final Location logger = Location.getLocation((String)APPLICATION);
    private static final String jARMRequest = "CAF:RT:oal" + APPLICATION;
    private MetamodelHelper mmHelper;
    private Map serviceWrappers;
    private Locale mLocale = Locale.getDefault();
    private static int activeTransactionsCount;
    static /* synthetic */ Class class$com$sap$caf$rt$services$serviceaccess$CAFServiceAccessBean;

    public Collection readDataObject(String serviceName, String aspectName, Collection keys) throws ServiceException {
        String method = "readDataObject(String, String, Collection)";
        CAFPublicLogger.entering(null, jARMRequest, "readDataObject(String, String, Collection)", logger, 1);
        try {
            this.startTransaction();
            Collection collection = this.getServiceWrapper(serviceName).readDataObject(aspectName, keys);
            return collection;
        }
        catch (Exception e) {
            try {
                this.rollback();
            }
            catch (ServiceException th) {
                CAFPublicLogger.traceThrowableT(100, logger, "readDataObject(String, String, Collection)", "Error in readDataObject(String, String, Collection)", (Throwable)((Object)th));
            }
            throw this.handleException(e);
        }
        finally {
            CAFPublicLogger.exiting(null, jARMRequest, "readDataObject(String, String, Collection)", logger, 1);
        }
    }

    public IDataContainerBean readRelatedDataObject(String serviceName, String aspectName, String parentServiceName, String parentAspect, String parentAspectKey) throws ServiceException {
        String method = "readRelatedDataObject(String, String, String, String, String)";
        CAFPublicLogger.entering(null, jARMRequest, "readRelatedDataObject(String, String, String, String, String)", logger, 1);
        try {
            IDataContainerBean iDataContainerBean = null;
            return iDataContainerBean;
        }
        catch (Exception e) {
            try {
                this.rollback();
            }
            catch (ServiceException th) {
                CAFPublicLogger.traceThrowableT(100, logger, "readRelatedDataObject(String, String, String, String, String)", "Error in readRelatedDataObject(String, String, String, String, String)", (Throwable)((Object)th));
            }
            throw this.handleException(e);
        }
        finally {
            CAFPublicLogger.exiting(null, jARMRequest, "readRelatedDataObject(String, String, String, String, String)", logger, 1);
        }
    }

    public IDataContainerBean updateDataObject(String serviceName, String aspectName, IDataContainerBean data) throws ServiceException {
        String method = "updateDataObject(String, String, IDataContainerBean)";
        CAFPublicLogger.entering(null, jARMRequest, "updateDataObject(String, String, IDataContainerBean)", logger, 1);
        try {
            this.startTransaction();
            IDataContainerBean iDataContainerBean = this.getServiceWrapper(serviceName).updateDataObject(aspectName, data);
            return iDataContainerBean;
        }
        catch (Exception e) {
            try {
                this.setRollbackOnly();
            }
            catch (ServiceException th) {
                CAFPublicLogger.traceThrowableT(100, logger, "updateDataObject(String, String, IDataContainerBean)", "Error in updateDataObject(String, String, IDataContainerBean)", (Throwable)((Object)th));
            }
            throw this.handleException(e);
        }
        finally {
            CAFPublicLogger.exiting(null, jARMRequest, "updateDataObject(String, String, IDataContainerBean)", logger, 1);
        }
    }

    public IDataContainerBean createDataObject(String serviceName, String aspectName, IDataContainerBean data) throws ServiceException {
        String method = "createDataObject(String, String, IDataContainerBean)";
        CAFPublicLogger.entering(null, jARMRequest, "createDataObject(String, String, IDataContainerBean)", logger, 1);
        try {
            this.startTransaction();
            IDataContainerBean iDataContainerBean = this.getServiceWrapper(serviceName).createDataContainerBean(aspectName, data);
            return iDataContainerBean;
        }
        catch (Exception e) {
            try {
                this.setRollbackOnly();
            }
            catch (ServiceException th) {
                CAFPublicLogger.traceThrowableT(100, logger, "createDataObject(String, String, IDataContainerBean)", "Error in createDataObject(String, String, IDataContainerBean)", (Throwable)((Object)th));
            }
            throw this.handleException(e);
        }
        finally {
            CAFPublicLogger.exiting(null, jARMRequest, "createDataObject(String, String, IDataContainerBean)", logger, 1);
        }
    }

    public boolean deleteDataObject(String serviceName, String aspectName, Collection keys) throws ServiceException {
        String method = "deleteDataObject(String, String, Collection)";
        CAFPublicLogger.entering(null, jARMRequest, "deleteDataObject(String, String, Collection)", logger, 1);
        try {
            this.startTransaction();
            boolean bl = this.getServiceWrapper(serviceName).deleteDataObject(aspectName, keys);
            return bl;
        }
        catch (Exception e) {
            try {
                this.setRollbackOnly();
            }
            catch (ServiceException th) {
                CAFPublicLogger.traceThrowableT(100, logger, "deleteDataObject(String, String, Collection)", "Error in deleteDataObject(String, String, Collection)", (Throwable)((Object)th));
            }
            throw this.handleException(e);
        }
        finally {
            CAFPublicLogger.exiting(null, jARMRequest, "deleteDataObject(String, String, Collection)", logger, 1);
        }
    }

    public Collection findByDataObject(String serviceName, String queryName, Collection parameters) throws ServiceException {
        String method = "findByDataObject(String, String, Collection)";
        CAFPublicLogger.entering(null, jARMRequest, "findByDataObject(String, String, Collection)", logger, 2);
        try {
            this.startTransaction();
            Collection collection = this.getServiceWrapper(serviceName).findByDataObject(queryName, parameters);
            return collection;
        }
        catch (Exception e) {
            try {
                this.rollback();
            }
            catch (ServiceException th) {
                CAFPublicLogger.traceThrowableT(100, logger, "findByDataObject(String, String, Collection)", "Error in findByDataObject(String, String, Collection)", (Throwable)((Object)th));
            }
            throw this.handleException(e);
        }
        finally {
            CAFPublicLogger.exiting(null, jARMRequest, "findByDataObject(String, String, Collection)", logger, 1);
        }
    }

    public Object invokeCustom(String serviceName, String operationName, Object parameters, Collection keys) throws ServiceException {
        String method = "invokeCustom(String, String, Collection)";
        CAFPublicLogger.entering(null, jARMRequest, "invokeCustom(String, String, Collection)", logger, 2);
        try {
            this.startTransaction();
            Object res = this.getServiceWrapper(serviceName).invokeCustom(operationName, parameters, keys);
            this.commit();
            Object object = res;
            return object;
        }
        catch (Exception e) {
            try {
                this.rollback();
            }
            catch (ServiceException th) {
                CAFPublicLogger.traceThrowableT(100, logger, "invokeCustom(String, String, Collection)", "Error in invokeCustom(String, String, Collection)", (Throwable)((Object)th));
            }
            throw this.handleException(e);
        }
        finally {
            CAFPublicLogger.exiting(null, jARMRequest, "invokeCustom(String, String, Collection)", logger, 2);
        }
    }

    public IDataContainerBean recalculate(String serviceName, IDataContainerBean data) throws ServiceException {
        String method = "recalculate(String, IDataContainerBean)";
        CAFPublicLogger.entering(null, jARMRequest, "recalculate(String, IDataContainerBean)", logger, 2);
        try {
            this.startTransaction();
            IDataContainerBean iDataContainerBean = this.getServiceWrapper(serviceName).recalculate(data);
            return iDataContainerBean;
        }
        catch (Exception e) {
            try {
                this.rollback();
            }
            catch (ServiceException th) {
                CAFPublicLogger.traceThrowableT(100, logger, "recalculate(String, IDataContainerBean)", "Error in recalculate(String, IDataContainerBean)", (Throwable)((Object)th));
            }
            throw this.handleException(e);
        }
        finally {
            CAFPublicLogger.exiting(null, jARMRequest, "recalculate(String, IDataContainerBean)", logger, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit() throws ServiceException {
        String method = "commit()";
        CAFPublicLogger.entering(null, jARMRequest, "commit()", logger, 2);
        try {
            UserTransaction t = CAFServiceAccessBeanImpl.getTransaction();
            if (t.getStatus() == 1) {
                try {
                    t.rollback();
                    Object var4_4 = null;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    logger.infoT("Rolled back. Active Transactions: " + --activeTransactionsCount);
                    throw throwable;
                }
                logger.infoT("Rolled back. Active Transactions: " + --activeTransactionsCount);
                return;
            }
            if (!CAFServiceAccessBeanImpl.isTransactionAlive(t)) return;
            try {
                try {
                    t.commit();
                }
                catch (Exception ex) {
                    if (!CAFServiceAccessBeanImpl.isTransactionAlive(t)) throw this.handleException(ex);
                    t.setRollbackOnly();
                    throw this.handleException(ex);
                }
                Object var6_8 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                logger.infoT("Commited. Active Transactions: " + --activeTransactionsCount);
                throw throwable;
            }
            logger.infoT("Commited. Active Transactions: " + --activeTransactionsCount);
            return;
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
        finally {
            CAFPublicLogger.exiting(null, jARMRequest, "commit()", logger, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws ServiceException {
        block7: {
            String method = "rollback()";
            CAFPublicLogger.entering(null, jARMRequest, "rollback()", logger, 2);
            try {
                UserTransaction t = CAFServiceAccessBeanImpl.getTransaction();
                if (!CAFServiceAccessBeanImpl.isTransactionAlive(t)) break block7;
                try {
                    t.rollback();
                    Object var4_4 = null;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    logger.infoT("Rolled back. Active Transactions: " + --activeTransactionsCount);
                    throw throwable;
                }
                logger.infoT("Rolled back. Active Transactions: " + --activeTransactionsCount);
                {
                }
            }
            catch (Exception e) {
                throw this.handleException(e);
            }
            finally {
                CAFPublicLogger.exiting(null, jARMRequest, "rollback()", logger, 2);
            }
        }
    }

    public void setRollbackOnly() throws ServiceException {
        try {
            UserTransaction t = CAFServiceAccessBeanImpl.getTransaction();
            if (CAFServiceAccessBeanImpl.isTransactionAlive(t)) {
                t.setRollbackOnly();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void startTransaction() throws ServiceException {
        String method = "startTransaction()";
        CAFPublicLogger.entering(null, jARMRequest, "startTransaction()", logger, 2);
        try {
            UserTransaction t = CAFServiceAccessBeanImpl.getTransaction();
            if (!CAFServiceAccessBeanImpl.isTransactionAlive(t)) {
                t.begin();
                logger.infoT("Started. Active Transactions: " + ++activeTransactionsCount);
            }
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
        finally {
            CAFPublicLogger.exiting(null, jARMRequest, "startTransaction()", logger, 2);
        }
    }

    static UserTransaction getTransaction() throws NamingException {
        String method = "getTransaction()";
        CAFPublicLogger.entering(null, jARMRequest, "getTransaction()", logger, 2);
        InitialContext initContext = new InitialContext();
        CAFPublicLogger.exiting(null, jARMRequest, "getTransaction()", logger, 2);
        return (UserTransaction)initContext.lookup("java:comp/UserTransaction");
    }

    static boolean isTransactionAlive(UserTransaction tr) throws Exception {
        String method = "isTransactionAlive(UserTransaction)";
        CAFPublicLogger.entering(null, jARMRequest, "isTransactionAlive(UserTransaction)", logger, 2);
        int status = tr.getStatus();
        CAFPublicLogger.exiting(null, jARMRequest, "isTransactionAlive(UserTransaction)", logger, 2);
        return status != 6 && status != 4 && status != 5 && status != 3;
    }

    public boolean isTransactionAlive() throws ServiceException {
        String method = "isTransactionAlive()";
        CAFPublicLogger.entering(null, jARMRequest, "isTransactionAlive()", logger, 2);
        try {
            UserTransaction ut = CAFServiceAccessBeanImpl.getTransaction();
            boolean bl = CAFServiceAccessBeanImpl.isTransactionAlive(ut);
            return bl;
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
        finally {
            CAFPublicLogger.exiting(null, jARMRequest, "isTransactionAlive()", logger, 2);
        }
    }

    private ServiceException handleException(Throwable th) {
        String method = "handleException(Throwable)";
        if (th instanceof RollbackException) {
            Throwable t = th.getCause();
            if (t == null) {
                return new ServiceException("TRANSACTION_CANT_BE_COMMITED", null, (Throwable)th);
            }
            th = t;
            if (th instanceof JDOException) {
                th = new ServiceException("TRANSACTION_CANT_BE_COMMITED", null, (Throwable)th);
            }
        }
        CAFPublicLogger.traceThrowableT(100, logger, "handleException(Throwable)", "Error in handleException(Throwable)", th);
        logger.throwing("handleException(Throwable)", th);
        return th instanceof ServiceException ? (ServiceException)((Object)th) : new ServiceException((Throwable)th);
    }

    public Collection getServiceNames() throws ServiceException {
        return this.mmHelper.getServiceModuleNames();
    }

    public ServiceModuleDescriptor getServiceModuleDescriptor(String serviceModuleName) throws ServiceException {
        return this.mmHelper.getServiceModuleDescriptor(serviceModuleName);
    }

    public Locale getLocale() {
        return this.mLocale;
    }

    public ServiceWrapper getServiceWrapper(String serviceModuleName) throws ServiceException {
        String method = "getServiceWrapper(String)";
        CAFPublicLogger.entering(null, jARMRequest, "getServiceWrapper(String)", logger, 2);
        ServiceWrapper wrapper = (ServiceWrapper)this.serviceWrappers.get(serviceModuleName);
        ServiceModuleDescriptor descriptor = this.mmHelper.getServiceModuleDescriptor(serviceModuleName);
        if (wrapper == null && descriptor != null) {
            wrapper = new ServiceWrapper(this, descriptor, this.mmHelper.getServiceJNDI_KEY(serviceModuleName));
            this.serviceWrappers.put(serviceModuleName, wrapper);
        }
        CAFPublicLogger.exiting(null, jARMRequest, "getServiceWrapper(String)", logger, 2);
        return wrapper;
    }

    protected void init(Map prop) throws DataAccessException {
        boolean isNeedMetamodel = true;
        if (prop != null) {
            Object needMetamodel;
            Object obj = prop.get("LOCALE");
            if (obj instanceof Locale) {
                this.mLocale = (Locale)obj;
            }
            if ((needMetamodel = prop.get("IS_NEED_METAMODEL")) != null && needMetamodel instanceof Boolean) {
                isNeedMetamodel = (Boolean)needMetamodel;
            }
        }
        if (isNeedMetamodel) {
            this.mmHelper = MetamodelHelperFactory.getMetamodelHelper(this.mLocale);
        }
        activeTransactionsCount = 0;
        this.serviceWrappers = new HashMap();
    }

    public MetamodelHelper getMetamodelHelper() {
        return this.mmHelper;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

