/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.subscr.persist.subscr;

import com.sap.caf.rt.services.notify.subscr.SubscrType;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLNames;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistEntity;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.sql.SQLUtils;
import com.sap.caf.rt.services.notify.subscr.persist.state.IPersistState;
import com.sap.caf.rt.services.notify.subscr.persist.state.PersistState;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscrType;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscription;
import com.sap.caf.rt.services.notify.subscr.persist.xml.IXMLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.xml.XMLUtils;
import java.util.Map;
import org.w3c.dom.Node;

public class PersistSubscrType
extends SubscrType
implements IPersistSubscrType {
    private IPersistState m_state = new PersistState();
    private Object m_key;

    protected ClassLoader getClassLoader() {
        return ((IPersistSubscription)this.getFilter().getSubscription()).getApplication().getClassLoader();
    }

    public void load(IPersistManager manager) throws PersistException {
        if (manager instanceof IXMLPersistManager) {
            this.load((IXMLPersistManager)manager);
        } else if (manager instanceof ISQLPersistManager) {
            this.load((ISQLPersistManager)manager);
        }
    }

    protected void load(ISQLPersistManager manager) throws PersistException {
        Map values = SQLUtils.loadObjValues(manager, "SELECT ID FROM CAF_RT_NS_FLT_TYPE WHERE (TYPE_KEY=?)", ISQLNames.SELECT_FLT_TYPE_TYPES, this);
        this.setId((String)values.get("ID"));
    }

    protected void load(IXMLPersistManager manager) throws PersistException {
        Node root = manager.getCurrentNode();
        this.setId(XMLUtils.getStrNodeAttrValue(root, "id", true));
    }

    public void create(IPersistManager manager) throws PersistException {
        if (manager instanceof ISQLPersistManager) {
            ISQLPersistManager sqlManager = (ISQLPersistManager)manager;
            this.setKey(SQLUtils.createKey());
            SQLUtils.execUpdate(sqlManager, "INSERT INTO CAF_RT_NS_FLT_TYPE (TYPE_KEY,FILTER_KEY,ID) VALUES (?,?,?)", ISQLNames.INSERT_FLT_TYPE_TYPES, new Object[]{this.getKey(), ((ISQLPersistEntity)((Object)this.getFilter())).getKey(), this.getId()});
        }
    }

    public void store(IPersistManager manager) throws PersistException {
        if (manager instanceof ISQLPersistManager) {
            ISQLPersistManager sqlManager = (ISQLPersistManager)manager;
            SQLUtils.execUpdate(sqlManager, "UPDATE CAF_RT_NS_FLT_TYPE SET FILTER_KEY=?,ID=? WHERE (TYPE_KEY=?)", ISQLNames.UPDATE_FLT_TYPE_TYPES, new Object[]{((ISQLPersistEntity)((Object)this.getFilter())).getKey(), this.getId(), this.getKey()});
        }
    }

    public void delete(IPersistManager manager) throws PersistException {
        if (manager instanceof ISQLPersistManager) {
            ISQLPersistManager sqlManager = (ISQLPersistManager)manager;
            SQLUtils.execUpdate(sqlManager, "DELETE FROM CAF_RT_NS_FLT_TYPE WHERE (TYPE_KEY=? AND FILTER_KEY=?);", ISQLNames.DELETE_FLT_TYPE_TYPES, new Object[]{this.getKey(), ((ISQLPersistEntity)((Object)this.getFilter())).getKey()});
        }
    }

    public IPersistState getState() {
        return this.m_state;
    }

    public Object getKey() {
        return this.m_key;
    }

    public void setKey(Object key) {
        this.m_key = key;
    }

    public void setId(String id) {
        super.setId(id);
        this.getState().setUpdated(true);
    }
}

