/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.subscr.persist.subscr;

import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.subscr.SubscrPrefs;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLNames;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.sql.SQLUtils;
import com.sap.caf.rt.services.notify.subscr.persist.state.IPersistState;
import com.sap.caf.rt.services.notify.subscr.persist.state.PersistState;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscrPrefs;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscription;
import com.sap.security.api.IUser;
import java.util.Map;

public class PersistSubscrPrefs
extends SubscrPrefs
implements IPersistSubscrPrefs {
    private Object m_key;
    private IPersistState m_state = new PersistState();

    PersistSubscrPrefs(IPersistSubscription subscr, IUser user) {
        super(subscr, user.getUniqueID());
    }

    Object getSubscrKey() {
        return ((IPersistSubscription)this.getSubscription()).getKey();
    }

    public Object getKey() {
        return this.m_key;
    }

    public void setKey(Object key) {
        this.m_key = key;
    }

    public IPersistState getState() {
        return this.m_state;
    }

    public void create(IPersistManager manager) throws PersistException {
        if (manager instanceof ISQLPersistManager) {
            ISQLPersistManager sqlManager = (ISQLPersistManager)manager;
            this.setKey(SQLUtils.createKey());
            SQLUtils.execUpdate(sqlManager, "INSERT INTO CAF_RT_NS_PREF (PREF_KEY,SUBSCR_KEY,USER_ID,FLAG_ACT_INBOX,FLAG_SUBSCR) VALUES (?,?,?,?,?)", ISQLNames.INSERT_PREF_TYPES, new Object[]{this.getKey(), this.getSubscrKey(), this.getUserId(), this.isActionInboxEnabled() ? SQLUtils.INT_1 : SQLUtils.INT_0, this.isSubscribed() ? SQLUtils.INT_1 : SQLUtils.INT_0});
        }
    }

    public void delete(IPersistManager manager) throws PersistException {
        if (manager instanceof ISQLPersistManager) {
            SQLUtils.execUpdate((ISQLPersistManager)manager, "DELETE FROM CAF_RT_NS_PREF WHERE (PREF_KEY=?)", ISQLNames.DELETE_PREF_TYPES, new Object[]{this.getKey()});
        }
    }

    public void load(IPersistManager manager) throws PersistException {
        if (manager instanceof ISQLPersistManager) {
            Object subscrKey = this.getSubscrKey();
            if (subscrKey == null) {
                if (Log.isDebugEnabled()) {
                    Log.debug("Could not load subscr prefs for user:[" + this.getUserId() + "]. Subscr key is null!");
                }
                return;
            }
            Map values = SQLUtils.loadObjValues((ISQLPersistManager)manager, "SELECT B.PREF_KEY,B.FLAG_ACT_INBOX,B.FLAG_SUBSCR FROM CAF_RT_NS_SUBSCR A,CAF_RT_NS_PREF B WHERE A.SUBSCR_KEY=B.SUBSCR_KEY AND A.SUBSCR_KEY=? AND B.USER_ID=?", ISQLNames.SELECT_PREF_TYPES, new Object[]{subscrKey, this.getUserId()}, this);
            this.setKey((String)values.get("PREF_KEY"));
            this.setActionInboxEnabled(SQLUtils.INT_1.equals((Integer)values.get("FLAG_ACT_INBOX")));
            this.setSubscribed(SQLUtils.INT_1.equals((Integer)values.get("FLAG_SUBSCR")));
        }
    }

    public void store(IPersistManager manager) throws PersistException {
        if (manager instanceof ISQLPersistManager) {
            SQLUtils.execUpdate((ISQLPersistManager)manager, "UPDATE CAF_RT_NS_PREF SET SUBSCR_KEY=?,USER_ID=?,FLAG_ACT_INBOX=?,FLAG_SUBSCR=? WHERE (PREF_KEY=?)", ISQLNames.UPDATE_PREF_TYPES, new Object[]{this.getSubscrKey(), this.getUserId(), this.isActionInboxEnabled() ? SQLUtils.INT_1 : SQLUtils.INT_0, this.isSubscribed() ? SQLUtils.INT_1 : SQLUtils.INT_0, this.getKey()});
        }
    }

    public void setActionInboxEnabled(boolean enabled) {
        super.setActionInboxEnabled(enabled);
        this.getState().setUpdated(true);
    }

    public void setSubscribed(boolean subscribed) {
        super.setSubscribed(subscribed);
        this.getState().setUpdated(true);
    }

    public void setUserId(String userId) {
        super.setUserId(userId);
        this.getState().setUpdated(true);
    }
}

