/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.subscr.persist.subscr;

import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.notif.INotifEvent;
import com.sap.caf.rt.services.notify.subscr.SubscrFilter;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistEntity;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLNames;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistEntity;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.sql.SQLUtils;
import com.sap.caf.rt.services.notify.subscr.persist.state.IPersistState;
import com.sap.caf.rt.services.notify.subscr.persist.state.PersistState;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscrFilter;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscription;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.PersistSubscrType;
import com.sap.caf.rt.services.notify.subscr.persist.xml.IXMLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.xml.XMLUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class PersistSubscrFilter
extends SubscrFilter
implements IPersistSubscrFilter {
    private IPersistState m_state = new PersistState();
    private Object m_key;

    public IPersistState getState() {
        return this.m_state;
    }

    public void load(IPersistManager manager) throws PersistException {
        if (manager instanceof IXMLPersistManager) {
            this.load((IXMLPersistManager)manager);
        } else if (manager instanceof ISQLPersistManager) {
            this.load((ISQLPersistManager)manager);
        }
    }

    public void create(IPersistManager manager) throws PersistException {
        if (manager instanceof ISQLPersistManager) {
            ISQLPersistManager sqlManager = (ISQLPersistManager)manager;
            this.setKey(SQLUtils.createKey());
            SQLUtils.execUpdate(sqlManager, "INSERT INTO CAF_RT_NS_FLT (FILTER_KEY,SUBSCR_KEY,CLASS_NAME) VALUES (?,?,?)", ISQLNames.INSERT_FILTER_TYPES, new Object[]{this.getKey(), ((ISQLPersistEntity)((Object)this.getSubscription())).getKey(), this.getClass().getName()});
            Iterator itr = this.getTypes();
            while (itr.hasNext()) {
                manager.create((IPersistEntity)itr.next());
            }
        }
    }

    public void store(IPersistManager manager) throws PersistException {
        if (manager instanceof ISQLPersistManager) {
            ISQLPersistManager sqlManager = (ISQLPersistManager)manager;
            SQLUtils.execUpdate(sqlManager, "UPDATE CAF_RT_NS_FLT SET SUBSCR_KEY=?,CLASS_NAME=? WHERE (FILTER_KEY=?)", ISQLNames.UPDATE_FILTER_TYPES, new Object[]{((ISQLPersistEntity)((Object)this.getSubscription())).getKey(), this.getClass().getName(), this.getKey()});
            Iterator itr = this.getTypes();
            while (itr.hasNext()) {
                manager.store((IPersistEntity)itr.next());
            }
        }
    }

    public void delete(IPersistManager manager) throws PersistException {
        if (manager instanceof ISQLPersistManager) {
            ISQLPersistManager sqlManager = (ISQLPersistManager)manager;
            Iterator itr = this.getTypes();
            while (itr.hasNext()) {
                manager.delete((IPersistEntity)itr.next());
            }
            SQLUtils.execUpdate(sqlManager, "DELETE FROM CAF_RT_NS_FLT WHERE (FILTER_KEY=? AND SUBSCR_KEY=?)", ISQLNames.DELETE_FILTER_TYPES, new Object[]{this.getKey(), ((ISQLPersistEntity)((Object)this.getSubscription())).getKey()});
        }
    }

    protected void load(IXMLPersistManager manager) throws PersistException {
        Node root = manager.getCurrentNode();
        ClassLoader classLoader = this.getClassLoader();
        List nodes = XMLUtils.getNodesAsList(root, "type");
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = (Node)nodes.get(i);
            if (!"type".equals(node.getNodeName())) continue;
            PersistSubscrType subscrType = new PersistSubscrType();
            subscrType.setFilter(this);
            manager.load(node, subscrType);
            this.addType(subscrType);
        }
    }

    protected void load(ISQLPersistManager manager) throws PersistException {
        List rows = SQLUtils.execSelect(manager, "SELECT TYPE_KEY FROM CAF_RT_NS_FLT_TYPE WHERE (FILTER_KEY=?)", ISQLNames.SELECT_FLT_TYPES_TYPES, new Object[]{this.getKey()});
        int i = rows.size();
        while (--i >= 0) {
            Map row = (Map)rows.get(i);
            PersistSubscrType subscrType = new PersistSubscrType();
            subscrType.setKey((String)row.get("TYPE_KEY"));
            manager.load(subscrType);
            this.addType(subscrType);
            subscrType.getState().reset();
        }
    }

    protected ClassLoader getClassLoader() {
        return ((IPersistSubscription)this.getSubscription()).getApplication().getClassLoader();
    }

    public Object getKey() {
        return this.m_key;
    }

    public void setKey(Object key) {
        this.m_key = key;
    }

    public boolean accept(INotifEvent event) {
        IPersistSubscription subscr = (IPersistSubscription)this.getSubscription();
        if (!subscr.isActive()) {
            if (Log.isDebugEnabled()) {
                Log.debug("Subscription:" + subscr.getId() + " is inactive, event ignored");
            }
            return false;
        }
        return super.accept(event);
    }
}

