/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.subscr.persist;

import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.common.NSResourceAccessor;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistApplication;
import com.sap.localization.LocalizableTextFormatter;
import java.util.Properties;

public final class PersistUtils {
    private static final String RES_VAR_PREFIX = "${";
    private static final String RES_VAR_SUFFIX = "}";

    public static Object newObject(String className, ClassLoader loader, Class classType) throws PersistException {
        try {
            Class<?> newClassType = Class.forName(className, true, loader);
            if (!classType.isAssignableFrom(newClassType)) {
                throw new PersistException("WRONG_CLASS", new Object[]{newClassType.getName(), classType.getName()});
            }
            return newClassType.newInstance();
        }
        catch (Exception e) {
            throw new PersistException("CANT_LOAD_CLASS", new Object[]{className}, e);
        }
    }

    public static String getLocalizedMessage(String bundle, String key, Object[] args, ClassLoader classLoader) {
        try {
            LocalizableTextFormatter formatter = new LocalizableTextFormatter(NSResourceAccessor.getInstance(bundle, classLoader), key, args);
            return formatter.format();
        }
        catch (Exception e) {
            Log.fatal(e);
            return key;
        }
    }

    public static String getReferenceKey(String var) {
        if (var == null || !var.startsWith(RES_VAR_PREFIX) || !var.endsWith(RES_VAR_SUFFIX)) {
            return null;
        }
        return var.substring(RES_VAR_PREFIX.length(), var.length() - RES_VAR_SUFFIX.length());
    }

    public static boolean resolveBoolPropRef(String ref, Properties props) throws PersistException {
        String key = PersistUtils.getReferenceKey(ref);
        if (key == null) {
            return Boolean.valueOf(ref);
        }
        String prop = props.getProperty(key);
        if (prop == null) {
            throw new PersistException("CANT_RESOLVE_PROP_REF", new Object[]{key});
        }
        return Boolean.valueOf(prop);
    }

    public static String resolveResRef(String ref, String bundleName, ClassLoader classLoader) throws PersistException {
        String key = PersistUtils.getReferenceKey(ref);
        if (key == null) {
            return ref;
        }
        return PersistUtils.getLocalizedMessage(bundleName, key, null, classLoader);
    }

    public static String resolveRef(String ref, IPersistApplication app) throws PersistException {
        String key = PersistUtils.getReferenceKey(ref);
        if (key == null) {
            return ref;
        }
        Properties props = app.getProperties();
        String prop = props.getProperty(key);
        if (prop != null) {
            return prop;
        }
        return PersistUtils.resolveResRef(ref, app.getResourceName(), app.getClassLoader());
    }
}

