/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.subscr.app;

import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.subscr.ISubscrList;
import com.sap.caf.rt.services.notify.subscr.SubscrException;
import com.sap.caf.rt.services.notify.subscr.SubscrListFactory;
import com.sap.caf.rt.services.notify.subscr.app.IAppSubscrList;
import com.sap.caf.rt.services.notify.subscr.app.IApplication;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistApplication;
import com.sap.caf.rt.services.notify.subscr.persist.xml.XMLPersistManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class AppSubscrListFactory
extends SubscrListFactory {
    protected ISubscrList m_list;
    protected IPersistApplication m_app;
    protected static final String CONFIG_NAME = "META-INF/subscriptions/subscriptions.xml";
    protected static final String PROP_SUBSCR_ENABLED = "Subscription.Enabled";
    static /* synthetic */ Class class$com$sap$caf$rt$services$notify$subscr$app$AppSubscrList;

    protected AppSubscrListFactory(IPersistApplication app) {
        this.m_app = app;
    }

    public static AppSubscrListFactory getInstance(IPersistApplication app) {
        return new AppSubscrListFactory(app);
    }

    public ISubscrList getSubscrList() throws SubscrException {
        block10: {
            if (this.m_list == null) {
                try {
                    if (Log.isDebugEnabled()) {
                        Log.debug("Trying to load subscriptions for app:[" + this.m_app.getId() + "]...");
                    }
                    if (!this.m_app.isValid()) {
                        Log.debug("The app:[" + this.m_app.getId() + "] is not valid!");
                        break block10;
                    }
                    this.m_list = this.createSubscrList(this.m_app.getProperties(), this.m_app.getClassLoader());
                    if (this.m_list == null || !(this.m_list instanceof IAppSubscrList)) break block10;
                    if (Log.isDebugEnabled()) {
                        Log.debug("Subscriptions found for app:[" + this.m_app.getId() + "]! SubscrList:[" + this.m_list + "]");
                    }
                    IAppSubscrList appList = (IAppSubscrList)this.m_list;
                    appList.setApplication(this.m_app);
                    Document configDoc = this.getConfigDocument(this.m_app.getClassLoader());
                    if (configDoc != null) {
                        XMLPersistManager persistManager = new XMLPersistManager();
                        persistManager.begin();
                        try {
                            persistManager.load(configDoc.getDocumentElement(), appList);
                            persistManager.commit();
                        }
                        catch (PersistException e) {
                            persistManager.revert();
                            throw e;
                        }
                    }
                    if (Log.isDebugEnabled()) {
                        Log.debug("Subscriptions loaded for app:[" + this.m_app.getId() + "]");
                    }
                }
                catch (Exception e) {
                    throw new SubscrException("CANT_GET_APP_SUBCR", e);
                }
            }
        }
        return this.m_list;
    }

    private Document getConfigDocument(ClassLoader appLoader) throws SAXException, IOException, ParserConfigurationException {
        InputStream is = appLoader.getResourceAsStream(CONFIG_NAME);
        if (is == null) {
            if (Log.isDebugEnabled()) {
                Log.debug("Config file:[META-INF/subscriptions/subscriptions.xml] was not found for app:[" + this.m_app.getId() + "], Subscriptions were not loaded");
            }
            return null;
        }
        if (Log.isDebugEnabled()) {
            Log.debug("Config file:[META-INF/subscriptions/subscriptions.xml] found for app:[" + this.m_app.getId() + "]");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        return factory.newDocumentBuilder().parse(is);
    }

    public IApplication getApplication() {
        return this.m_app;
    }

    protected String getListClassName(Properties props) throws SubscrException {
        String sEnabled = props.getProperty(PROP_SUBSCR_ENABLED);
        if (sEnabled == null) {
            if (Log.isDebugEnabled()) {
                Log.debug("Property:[Subscription.Enabled] was not found, subscriptions will be ignored.");
            }
            return null;
        }
        if (!Boolean.valueOf(sEnabled).booleanValue()) {
            if (Log.isDebugEnabled()) {
                Log.debug("Property:[Subscription.Enabled] is set to 'false', subscriptions will be ignored.");
            }
            return null;
        }
        return (class$com$sap$caf$rt$services$notify$subscr$app$AppSubscrList == null ? (class$com$sap$caf$rt$services$notify$subscr$app$AppSubscrList = AppSubscrListFactory.class$("com.sap.caf.rt.services.notify.subscr.app.AppSubscrList")) : class$com$sap$caf$rt$services$notify$subscr$app$AppSubscrList).getName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

