/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.subscr;

import com.sap.caf.km.proxies.svc.kmnotif.KMNotificationSvc;
import com.sap.caf.km.proxies.svc.kmnotif.KMNotificationSvcService;
import com.sap.caf.km.proxies.svc.kmnotif.types.KMTemplFile;
import com.sap.caf.rt.bol.context.CAFContext;
import com.sap.caf.rt.services.notify.notif.INotifEvent;
import com.sap.caf.rt.services.notify.subscr.ISubscrTemplate;
import com.sap.caf.rt.services.notify.subscr.ISubscription;
import com.sap.caf.rt.services.notify.subscr.SubscrException;
import com.sap.caf.rt.services.notify.subscr.TemplateFile;
import java.sql.Date;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;

public abstract class SubscrTemplate
implements ISubscrTemplate {
    protected String m_sId;
    private Properties m_props = new Properties();
    private String m_sSubj;
    private ISubscription m_subscr;
    private KMNotificationSvc m_templProxy;
    private static final String KM_NOTIF_SVC_JNDI = "wsclients/proxies/sap.com/caf~km.proxies/KMNotificationSvc";
    private static final DateFormat s_dateFormat = DateFormat.getDateInstance(2);
    static /* synthetic */ Class class$com$sap$caf$km$proxies$svc$kmnotif$KMNotificationSvc;

    public String getId() {
        return this.m_sId;
    }

    public void setId(String id) {
        this.m_sId = id;
    }

    public Properties getProperties(INotifEvent event) {
        Properties props = this.convertEventAttrs(event.getAttributes());
        props.putAll((Map<?, ?>)this.getProperties());
        return props;
    }

    protected String getAppProperty(String name, INotifEvent event) {
        Object obj = event.getAttribute("priv:appProps");
        if (obj == null || !(obj instanceof Properties)) {
            return null;
        }
        Properties props = (Properties)obj;
        return props.getProperty(name);
    }

    private Properties convertEventAttrs(Map map) {
        Properties props = new Properties();
        Iterator itr = map.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(key instanceof String)) continue;
            if (value instanceof String) {
                props.setProperty((String)key, (String)value);
                continue;
            }
            if (!(value instanceof Date)) continue;
            props.setProperty((String)key, this.formatDate((Date)value));
        }
        return props;
    }

    public String getSubject() {
        return this.m_sSubj;
    }

    public void setSubject(String subject) {
        this.m_sSubj = subject;
    }

    public Iterator getFiles() throws SubscrException {
        try {
            KMNotificationSvc notifSvc = this.getNotifSvc();
            KMTemplFile[] kmFiles = notifSvc.getTemplateFiles(this.getId());
            if (kmFiles == null || kmFiles.length == 0) {
                return Collections.EMPTY_LIST.iterator();
            }
            ArrayList<TemplateFile> templFiles = new ArrayList<TemplateFile>();
            for (int i = 0; i < kmFiles.length; ++i) {
                templFiles.add(new TemplateFile(kmFiles[i].getName(), kmFiles[i].getRid()));
            }
            return templFiles.iterator();
        }
        catch (Exception e) {
            throw new SubscrException("CANT_GET_TEMPL_FILES", e);
        }
    }

    public ISubscription getSubscription() {
        return this.m_subscr;
    }

    public void setSubscription(ISubscription subscr) {
        this.m_subscr = subscr;
    }

    protected KMNotificationSvc getNotifSvc() throws SubscrException {
        if (this.m_templProxy == null) {
            try {
                InitialContext context = new InitialContext();
                KMNotificationSvcService service = (KMNotificationSvcService)context.lookup(KM_NOTIF_SVC_JNDI);
                KMNotificationSvc proxy = (KMNotificationSvc)service.getLogicalPort(class$com$sap$caf$km$proxies$svc$kmnotif$KMNotificationSvc == null ? (class$com$sap$caf$km$proxies$svc$kmnotif$KMNotificationSvc = SubscrTemplate.class$("com.sap.caf.km.proxies.svc.kmnotif.KMNotificationSvc")) : class$com$sap$caf$km$proxies$svc$kmnotif$KMNotificationSvc);
                String url = CAFContext.substEPAddress((String)proxy._getProperty("javax.xml.rpc.service.endpoint.address"));
                proxy._setProperty("javax.xml.rpc.service.endpoint.address", (Object)url);
                this.m_templProxy = proxy;
            }
            catch (Exception e) {
                throw new SubscrException("CANT_GET_NOTIF_SVC", e);
            }
        }
        return this.m_templProxy;
    }

    protected String formatDate(Date date) {
        return s_dateFormat.format(date);
    }

    public void addProperty(String name, String value) {
        this.m_props.put(name, value);
    }

    public Properties getProperties() {
        return this.m_props;
    }

    public String getProperty(String name) {
        return this.m_props.getProperty(name);
    }

    public void removeProperty(String name) {
        this.m_props.remove(name);
    }

    public void setProperties(Properties props) {
        this.m_props = props;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

