/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.notif.send;

import com.sap.caf.rt.bol.context.CAFContext;
import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.notif.NotifException;
import com.sap.caf.rt.services.notify.notif.send.NotifMessage;
import java.io.Serializable;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class SendingBean
implements SessionBean {
    static final long serialVersionUID = 1L;
    private transient SessionContext m_sessContext;
    private transient TopicSession m_topicSess;
    private transient TopicPublisher m_topicPubl;
    private transient TopicConnection m_topicConn;

    public void setSessionContext(SessionContext context) throws EJBException, RemoteException {
        this.m_sessContext = context;
    }

    public void ejbCreate() throws CreateException {
        String method = "ejbCreate()";
        Log.enter("ejbCreate()");
        try {
            this.create();
        }
        catch (Exception e) {
            NotifException ntfyEx = new NotifException("CANT_CREATE_SNDBEAN", e);
            Log.fatal((Throwable)((Object)ntfyEx), "ejbCreate()");
            throw new CreateException(ntfyEx.getLocalizedMessage());
        }
        finally {
            Log.exit("ejbCreate()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ejbActivate() throws EJBException, RemoteException {
        String method = "ejbActivate()";
        Log.enter("ejbActivate()");
        try {
            this.create();
        }
        catch (Exception e) {
            NotifException ntfyEx = new NotifException("CANT_CREATE_SNDBEAN", e);
            Log.fatal((Throwable)((Object)ntfyEx), "ejbActivate()");
        }
        finally {
            Log.exit("ejbActivate()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ejbPassivate() throws EJBException, RemoteException {
        String method = "ejbPassivate()";
        Log.enter("ejbPassivate()");
        try {
            this.destroy();
        }
        catch (JMSException e) {
            NotifException ntfyEx = new NotifException("CANT_DESTROY_SNDBEAN", e);
            Log.fatal((Throwable)((Object)ntfyEx), "ejbPassivate()");
        }
        finally {
            Log.exit("ejbPassivate()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ejbRemove() throws EJBException, RemoteException {
        String method = "ejbRemove()";
        Log.enter("ejbRemove()");
        try {
            this.destroy();
        }
        catch (JMSException e) {
            NotifException ntfyEx = new NotifException("CANT_DESTROY_SNDBEAN", e);
            Log.fatal((Throwable)((Object)ntfyEx), "ejbRemove()");
        }
        finally {
            Log.exit("ejbRemove()");
        }
    }

    public void send(NotifMessage notifMsg) throws NotifException {
        String method = "send(NotifMessage)";
        Object[] params = new Object[]{notifMsg};
        Log.enter("send(NotifMessage)");
        try {
            if (!notifMsg.isValid()) {
                if (Log.isDebugEnabled()) {
                    Log.debug("NotifMessage is invalid, not sending it");
                }
                return;
            }
            ObjectMessage objMsg = this.m_topicSess.createObjectMessage();
            objMsg.setObject((Serializable)notifMsg);
            this.m_topicPubl.publish((Message)objMsg);
        }
        catch (JMSException e) {
            NotifException ntfyEx = new NotifException("CANT_PUBLISH_MSG", params, e);
            Log.fatal((Throwable)((Object)ntfyEx), "send(NotifMessage)");
            throw ntfyEx;
        }
        finally {
            Log.exit("send(NotifMessage)");
        }
    }

    private void create() throws NamingException, JMSException {
        InitialContext context = new InitialContext();
        TopicConnectionFactory connFactory = (TopicConnectionFactory)context.lookup(CAFContext.JNDI_NAME_JMS);
        this.m_topicConn = connFactory.createTopicConnection();
        this.m_topicSess = this.m_topicConn.createTopicSession(false, 1);
        Topic topic = (Topic)context.lookup(CAFContext.JNDI_NAME_NOTIF_JMS_TOPIC);
        this.m_topicPubl = this.m_topicSess.createPublisher(topic);
    }

    private void destroy() throws JMSException {
        this.m_topicPubl.close();
        this.m_topicSess.close();
        this.m_topicConn.close();
    }
}

