/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.notif.bobject;

import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.bol.IKMExt;
import com.sap.caf.rt.bol.context.CAFContext;
import com.sap.caf.rt.exception.BEException;
import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.notif.GroupNotifDispatcher;
import com.sap.caf.rt.services.notify.notif.INotifEvent;
import com.sap.caf.rt.services.notify.notif.NotifException;
import com.sap.caf.rt.services.notify.notif.bobject.BOChangedEvent;
import com.sap.caf.rt.services.notify.subscr.ISubscrType;
import com.sap.caf.rt.services.notify.subscr.bobject.BOSubscrType;
import com.sap.caf.rt.services.publish.PublishingLocal;
import com.sap.caf.rt.services.publish.PublishingLocalHome;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class BOChangedPublisher
extends GroupNotifDispatcher {
    private PublishingLocalHome m_pubHome;

    public BOChangedPublisher(Object ibo) {
    }

    public void notify(INotifEvent event) throws NotifException {
        if (CAFContext.PUBLISH_ENABLED && event.isEnabled()) {
            this.publish((BOChangedEvent)event);
            super.notify(event);
        }
    }

    protected void publish(BOChangedEvent event) throws NotifException {
        String method = "publish(BOChangedEvent)";
        Log.enter("publish(BOChangedEvent)", new Object[]{event});
        try {
            PublishingLocal pub = this.getPublishService();
            Object[] args = this.createPublishingArgs(event.getSource());
            ISubscrType eventType = event.getType();
            if (eventType.equals(BOSubscrType.CREATED)) {
                pub.publishCreated(args);
            } else if (eventType.equals(BOSubscrType.UPDATED)) {
                pub.publishChanged(args);
            } else if (eventType.equals(BOSubscrType.DELETED)) {
                pub.publishRemoved(args);
            }
        }
        catch (Exception e) {
            NotifException ownEx = new NotifException("CANT_PUBLISH_DATA", e);
            Log.fatal((Throwable)((Object)ownEx), "publish(BOChangedEvent)");
            throw ownEx;
        }
        finally {
            Log.exit("publish(BOChangedEvent)");
        }
    }

    protected Object[] createPublishingArgs(IDependentObject ibo) throws Exception {
        Iterator it;
        Object[] msgArgs = new Object[5];
        msgArgs[0] = ibo.getObjectType();
        msgArgs[1] = ibo.getKey();
        msgArgs[2] = this.getRid(ibo);
        msgArgs[3] = "";
        if (ibo instanceof IKMExt && (it = ((IKMExt)((Object)ibo)).getRelatedObjectRids().iterator()).hasNext()) {
            StringBuffer buffer = new StringBuffer();
            do {
                buffer.append((String)it.next()).append(';');
            } while (it.hasNext());
            buffer.setLength(buffer.length() - 1);
            msgArgs[3] = buffer.toString();
        }
        return msgArgs;
    }

    private String getRid(IDependentObject ibo) {
        try {
            Method method = ibo.getClass().getMethod("getRid", new Class[0]);
            return (String)method.invoke((Object)ibo, new Object[0]);
        }
        catch (Exception e) {
            if (Log.isDebugEnabled()) {
                Log.debug("Method getRid() is not exists for given IDependedObject", e);
            }
            return "";
        }
    }

    private synchronized PublishingLocal getPublishService() throws NamingException, CreateException, BEException {
        if (this.m_pubHome == null) {
            InitialContext ctx = new InitialContext();
            this.m_pubHome = (PublishingLocalHome)ctx.lookup("localejbs/sap.com/caf.runtime/Publishing");
        }
        return this.m_pubHome.create();
    }
}

