/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.notif;

import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.common.NSBaseException;
import com.sap.caf.rt.services.notify.notif.INotifDispatcher;
import com.sap.caf.rt.services.notify.notif.INotifEvent;
import com.sap.caf.rt.services.notify.notif.INotifSender;
import com.sap.caf.rt.services.notify.notif.NotifException;
import com.sap.caf.rt.services.notify.notif.send.NotifSender;
import com.sap.caf.rt.services.notify.subscr.ISubscrFilter;
import com.sap.caf.rt.services.notify.subscr.ISubscrList;
import com.sap.caf.rt.services.notify.subscr.ISubscrListFactory;
import com.sap.caf.rt.services.notify.subscr.ISubscrRecipients;
import com.sap.caf.rt.services.notify.subscr.ISubscription;
import com.sap.caf.rt.services.notify.subscr.SubscrException;
import com.sap.caf.rt.services.notify.subscr.app.IApplication;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscription;
import java.util.Collection;
import java.util.Iterator;

public abstract class NotifDispatcher
implements INotifDispatcher {
    protected INotifSender m_sender;
    protected ClassLoader m_classLoader;

    public void notify(INotifEvent event) throws NotifException {
        String method = "notify(INotificationEvent)";
        Log.enter("notify(INotificationEvent)", new Object[]{event});
        try {
            boolean bDebug = Log.isDebugEnabled();
            if (!event.isEnabled()) {
                if (bDebug) {
                    Log.debug("Event is disabled, do nothing");
                }
                return;
            }
            ISubscrListFactory subscrFactory = this.getSubscrListFactory();
            ISubscrList subscrList = subscrFactory.getSubscrList();
            if (subscrList == null) {
                if (bDebug) {
                    Log.debug("Could not find subscription list");
                }
                return;
            }
            Iterator foundSubscrs = this.getSubscriptions(subscrList, event);
            if (foundSubscrs == null || !foundSubscrs.hasNext()) {
                if (Log.isDebugEnabled()) {
                    Log.debug("Could not find subscriptions by id:[{0}]", new Object[]{event.getId()});
                }
                return;
            }
            while (foundSubscrs.hasNext()) {
                Collection userIds;
                ISubscription subscr = (ISubscription)foundSubscrs.next();
                if (bDebug) {
                    Log.debug("Subscription with id [{0}] has been found", new Object[]{subscr.getId()});
                }
                if (!this.isValid(subscr)) continue;
                ISubscrFilter filter = subscr.getFilter();
                if (!filter.accept(event)) {
                    if (!bDebug) continue;
                    Log.debug("Subscription filter did not accept event");
                    continue;
                }
                ISubscrRecipients inclUsers = subscr.getRecipients(event);
                ISubscrRecipients exclUsers = subscr.getExcludedRecipients(event);
                Collection collection = userIds = inclUsers != null ? inclUsers.getUserIds(event, exclUsers) : null;
                if (userIds == null || userIds.isEmpty()) {
                    if (!bDebug) continue;
                    Log.debug("Recipients list is empty");
                    continue;
                }
                INotifSender sender = this.getSender();
                this.fireOnBeforeSend(subscr, event);
                event.setAttribute("sys:eventId", subscr.getId());
                sender.send(userIds, subscr, event);
            }
        }
        catch (Exception e) {
            NotifException ownEx = new NotifException("CANT_PROCESS_EVENT", e);
            Log.fatal((Throwable)((Object)ownEx), "notify(INotificationEvent)");
            throw ownEx;
        }
        finally {
            Log.exit("notify(INotificationEvent)");
        }
    }

    protected boolean isValid(ISubscription subscr) {
        IPersistSubscription persistSubscr;
        if (!subscr.isEnabled()) {
            Log.fatal("DISABLED_SUBSCR", new Object[]{subscr.getId()});
            return false;
        }
        if (subscr instanceof IPersistSubscription && !(persistSubscr = (IPersistSubscription)subscr).isActive()) {
            IApplication app = persistSubscr.getApplication();
            Log.fatal("INACTIVE_SUBSCR", new Object[]{subscr.getId(), app != null ? app.getId() : null});
            return false;
        }
        return true;
    }

    protected abstract Iterator getSubscriptions(ISubscrList var1, INotifEvent var2) throws SubscrException;

    protected abstract void fireOnBeforeSend(ISubscription var1, INotifEvent var2) throws NSBaseException;

    protected abstract ISubscrListFactory getSubscrListFactory() throws SubscrException;

    public boolean isSubscrAvailable(String subscrId) throws SubscrException {
        ISubscrListFactory factory = this.getSubscrListFactory();
        if (factory == null) {
            return false;
        }
        ISubscrList subscrList = factory.getSubscrList();
        return subscrList.getSubscription(subscrId) != null;
    }

    protected INotifSender getSender() {
        if (this.m_sender == null) {
            this.m_sender = new NotifSender();
        }
        return this.m_sender;
    }
}

