/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.notif;

import com.sap.caf.rt.services.notify.common.JndiUtils;
import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.common.NSBaseException;
import com.sap.caf.rt.services.notify.notif.INotifEvent;
import com.sap.caf.rt.services.notify.notif.NotifDispatcher;
import com.sap.caf.rt.services.notify.subscr.ISubscrList;
import com.sap.caf.rt.services.notify.subscr.ISubscrListFactory;
import com.sap.caf.rt.services.notify.subscr.ISubscription;
import com.sap.caf.rt.services.notify.subscr.SubscrException;
import com.sap.caf.rt.services.notify.subscr.app.AppSubscrListFactory;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistApplication;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.PersistApplication;
import com.sap.engine.interfaces.connector.ComponentExecutionContext;
import com.sap.engine.services.deploy.DeployService;
import java.util.ArrayList;
import java.util.Iterator;

public class AppNotifDispatcher
extends NotifDispatcher {
    protected IPersistApplication m_app;
    private ISubscrListFactory m_subscrListFactory;

    protected Iterator getSubscriptions(ISubscrList subscrList, INotifEvent event) throws SubscrException {
        String subscrId = event.getId();
        ISubscription subscr = subscrList.getSubscription(subscrId);
        if (subscr == null) {
            if (Log.isDebugEnabled()) {
                Log.debug("Could not find subscription by id:[{0}]", new Object[]{subscrId});
            }
            return null;
        }
        ArrayList<ISubscription> retSubscrList = new ArrayList<ISubscription>();
        retSubscrList.add(subscr);
        return retSubscrList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISubscrListFactory getSubscrListFactory() throws SubscrException {
        AppNotifDispatcher appNotifDispatcher = this;
        synchronized (appNotifDispatcher) {
            if (this.m_subscrListFactory == null) {
                this.m_subscrListFactory = AppSubscrListFactory.getInstance(this.getApplication());
            }
        }
        return this.m_subscrListFactory;
    }

    protected void fireOnBeforeSend(ISubscription subscr, INotifEvent event) throws NSBaseException {
        event.setAttribute("priv:appProps", this.getApplication().getProperties());
    }

    public synchronized IPersistApplication getApplication() throws SubscrException {
        if (this.m_app == null) {
            try {
                ClassLoader runtimeLoader = this.getClass().getClassLoader();
                DeployService deplSrv = JndiUtils.getDeployService(runtimeLoader);
                ComponentExecutionContext appCtx = JndiUtils.getAppContext(runtimeLoader);
                String appName = appCtx.getApplicationName();
                this.m_app = new PersistApplication(appName);
                this.m_app.invalidate();
            }
            catch (Exception e) {
                throw new SubscrException("CANT_GET_APP", e);
            }
        }
        if (!this.m_app.isValid()) {
            try {
                this.m_app.invalidate();
            }
            catch (PersistException e) {
                throw new SubscrException("CANT_GET_APP", (Throwable)((Object)e));
            }
        }
        return this.m_app;
    }
}

