/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.metamodel;

import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.metamodel.RepositoryConnection;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.dictionary.runtime.IDataType;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.ResourceException;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.search.QueryFilter;
import com.sap.ip.mmr.search.QueryFilters;
import com.sap.tc.logging.Location;
import com.sap.tc.webdynpro.repository.DataTypeBroker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

public class MetaModel {
    public static final int ASSOCIATION = 0;
    public static final int AGGREGATION = 1;
    private static final String APPLICATION = (class$com$sap$caf$rt$metamodel$MetaModel == null ? (class$com$sap$caf$rt$metamodel$MetaModel = MetaModel.class$("com.sap.caf.rt.metamodel.MetaModel")) : class$com$sap$caf$rt$metamodel$MetaModel).getName();
    private static final String JARM_REQUEST = "CAF:RT:oal" + APPLICATION;
    private static final Location location = Location.getLocation((Class)(class$com$sap$caf$rt$metamodel$MetaModel == null ? (class$com$sap$caf$rt$metamodel$MetaModel = MetaModel.class$("com.sap.caf.rt.metamodel.MetaModel")) : class$com$sap$caf$rt$metamodel$MetaModel));
    private static final HashMap dataObjects = new HashMap(23, 0.5f);
    static /* synthetic */ Class class$com$sap$caf$rt$metamodel$MetaModel;

    public MetaModel() throws DataAccessException {
        IConnection con = RepositoryConnection.getConnection();
        if (con == null) {
            throw new DataAccessException("MMR_CON_OPEN_ERROR");
        }
    }

    public BusinessEntityInterface getBusinessEntityInterface(String qualifiedName) throws DataAccessException {
        return this.getBusinessEntityInterface(qualifiedName.substring(0, qualifiedName.indexOf("/")), qualifiedName.substring(qualifiedName.indexOf("/") + 1, qualifiedName.lastIndexOf("/")), qualifiedName.substring(qualifiedName.lastIndexOf("/") + 1));
    }

    public BusinessEntityInterface getBusinessEntityInterface(Class objType) throws DataAccessException {
        try {
            return this.getBusinessEntityInterface(objType.getDeclaredField("provider").get(null).toString(), objType.getDeclaredField("application").get(null).toString(), objType.getDeclaredField("dataObjectId").get(null).toString());
        }
        catch (Exception e) {
            throw new DataAccessException(objType.getName());
        }
    }

    public BusinessEntityInterface getBusinessEntityInterface(String provider, String application, String id) throws DataAccessException {
        String method = "getBusinessEntityInterface(String, String, String)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{provider, application, id}, 1);
        BusinessEntityInterface be = null;
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add("com");
        typeList.add("sap");
        typeList.add("caf");
        typeList.add("metamodel");
        typeList.add("BusinessEntityInterface");
        QueryFilters filters = new QueryFilters();
        QueryFilter filter = new QueryFilter("objectName", 0, id);
        filters.add(filter);
        IConnection con = RepositoryConnection.getConnection();
        Iterator objs = null;
        try {
            objs = con.queryM1(typeList, filters, true).iterator();
        }
        catch (ResourceException e) {
            Object[] args = new Object[]{provider + ":" + application + ":" + id};
            CAFPublicLogger.traceThrowableT(100, location, method, "Error getting BusinessEntityInterface of type {0}", args, e);
            location.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
            throw new DataAccessException("MMR_BO_NOTFOUND", args, e);
        }
        while (!(!objs.hasNext() || (be = (BusinessEntityInterface)objs.next()).getApplication() != null && application != null && provider != null && application.equals(be.getApplication().getObjectName()) && provider.equals(be.getApplication().getProviderName()))) {
            be = null;
        }
        if (be == null) {
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
            throw new DataAccessException("MMR_BO_NOTFOUND", new Object[]{id});
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return be;
    }

    public BusinessEntityInterface getBusinessEntityInterfaceByGUID(String guid) throws DataAccessException {
        String method = "getBusinessEntityInterfaceByGUID(String)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{guid}, 1);
        BusinessEntityInterface be = null;
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add("com");
        typeList.add("sap");
        typeList.add("caf");
        typeList.add("metamodel");
        typeList.add("BusinessEntityInterface");
        ArrayList<String> col = new ArrayList<String>();
        col.add(guid);
        IConnection con = RepositoryConnection.getConnection();
        Iterator objs = con.selectM1(col, true).iterator();
        while (objs.hasNext()) {
            be = (BusinessEntityInterface)objs.next();
        }
        if (be == null) {
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location);
            throw new DataAccessException("MMR_BO_NOTFOUND", new Object[]{guid});
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return be;
    }

    public Collection getAllBusinessEntityInterfacesByApplication(String provider, String application) throws DataAccessException {
        String method = "getBusinessEntityInterfaceByApplication(String, String)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{provider, application}, 1);
        BusinessEntityInterface bo = null;
        List typeList = Utilities.getUtilities().decodeQualifiedName("com.sap.caf.metamodel.BusinessEntityInterface");
        LinkedList<BusinessEntityInterface> col = null;
        IConnection con = RepositoryConnection.getConnection();
        try {
            Iterator i = con.queryM1(typeList, null, true).iterator();
            col = new LinkedList<BusinessEntityInterface>();
            while (i.hasNext()) {
                bo = (BusinessEntityInterface)i.next();
                if (!bo.getApplication().getObjectName().equals(application) || !bo.getApplication().getProviderName().equals(provider)) continue;
                col.add(bo);
            }
        }
        catch (ResourceException e) {
            Object[] args = new Object[]{provider + ":" + application};
            CAFPublicLogger.traceThrowableT(100, location, method, "Error getting BusinessEntityInterface of type {0}", args, e);
            location.throwing(method, (Throwable)e);
            throw new DataAccessException("MMR_BO_NOTFOUND", args, e);
        }
        finally {
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        }
        return col;
    }

    public BusinessEntityInterface getBusinessEntityInterfaceByObjectName(String objectName) throws DataAccessException {
        String method = "getBusinessEntityInterfaceByObjectName(String)";
        List typeList = Utilities.getUtilities().decodeQualifiedName("com.sap.caf.metamodel.BusinessEntityInterface");
        QueryFilters filters = new QueryFilters();
        QueryFilter filter = new QueryFilter("objectName", 0, objectName);
        filters.add(filter);
        BusinessEntityInterface result = null;
        try {
            result = (BusinessEntityInterface)RepositoryConnection.getConnection().queryM1(typeList, filters, true).iterator().next();
        }
        catch (ResourceException e) {
            Object[] args = new Object[]{objectName};
            CAFPublicLogger.traceThrowableT(100, location, method, "Error getting BusinessEntityInterface with name {0}", args, e);
            location.throwing(method, (Throwable)e);
            throw new DataAccessException("MMR_BO_NOTFOUND", args, e);
        }
        return result;
    }

    public Collection getAllBusinessEntityInterfaces() throws DataAccessException {
        String method = "getAllBusinessEntityInterfaces()";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, 1);
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add("com");
        typeList.add("sap");
        typeList.add("caf");
        typeList.add("metamodel");
        typeList.add("BusinessEntityInterface");
        List col = null;
        IConnection con = RepositoryConnection.getConnection();
        try {
            col = con.queryM1(typeList, null, true);
        }
        catch (ResourceException e) {
            CAFPublicLogger.traceThrowableT(100, location, method, "Error getting BusinessEntityInterface of type {0}", e);
            location.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
            throw new DataAccessException("MMR_BO_NOTFOUND", (Throwable)e);
        }
        if (col == null || col.size() == 0) {
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
            throw new DataAccessException("MMR_BO_NOTFOUND");
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return col;
    }

    public Collection getAllBusinessEntityInterfaces(int objectType) throws DataAccessException {
        String method = "getAllBusinessEntityInterfaces(int)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{Integer.toString(objectType)}, 1);
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add("com");
        typeList.add("sap");
        typeList.add("caf");
        typeList.add("metamodel");
        typeList.add("BusinessEntityInterface");
        QueryFilters filters = new QueryFilters();
        String strType = new Integer(objectType).toString();
        QueryFilter filter = new QueryFilter("backend", 0, strType);
        filters.add(filter);
        List col = null;
        IConnection con = RepositoryConnection.getConnection();
        try {
            col = con.queryM1(typeList, filters, true);
        }
        catch (ResourceException e) {
            Object[] args = new Object[]{Integer.toString(objectType)};
            CAFPublicLogger.traceThrowableT(100, location, method, "Error getting BusinessEntityInterface of type {0}", args, e);
            location.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
            throw new DataAccessException("MMR_BO_NOTFOUND", args, e);
        }
        if (col == null || col.size() == 0) {
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
            throw new DataAccessException("MMR_BO_NOTFOUND", new Object[]{Integer.toString(objectType)});
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return col;
    }

    public Map getRelatedBEsByGUID(String guid) throws DataAccessException {
        String method = "getRelatedBEsByGUID(String)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{guid}, 1);
        BusinessEntityInterface be = this.getBusinessEntityInterfaceByGUID(guid);
        Map map = this.getRelatedBEs(be);
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return map;
    }

    private Map getRelatedBEs(BusinessEntityInterface be) throws DataAccessException {
        String method = "getRelatedBEs(BusinessEntityInterface)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{be}, 1);
        HashMap<String, BusinessEntityInterface> map = new HashMap<String, BusinessEntityInterface>();
        List attr = be.getBusinessEntity().getAttributes();
        if (attr == null) {
            return new HashMap();
        }
        Iterator itRelations = attr.iterator();
        while (itRelations.hasNext()) {
            BusinessEntityInterface relatedBE;
            Attribute oap = (Attribute)itRelations.next();
            DataStructure obj = oap.getReferencedObject();
            if (obj == null || !(obj instanceof DataObject) || (relatedBE = ((DataObject)obj).getBusinessEntityInterface()) == null) continue;
            map.put(oap.refMofId(), relatedBE);
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return map;
    }

    public Map getRelatedBEs(String provider, String application, String bo) throws DataAccessException {
        String method = "getRelatedBEs(String, String, String)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{provider, application, bo}, 1);
        BusinessEntityInterface be = this.getBusinessEntityInterface(provider, application, bo);
        Map map = this.getRelatedBEs(be);
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return map;
    }

    public BusinessEntityInterface getRelatedBOByRelation(String relationGuid) throws DataAccessException {
        String method = "getRelatedBOByRelation(String)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, 1);
        BusinessEntityInterface be = null;
        Vector<String> guids = new Vector<String>();
        guids.add(relationGuid);
        Collection col = null;
        IConnection con = RepositoryConnection.getConnection();
        col = con.selectM1(guids, true);
        Iterator itRelations = col.iterator();
        while (itRelations.hasNext()) {
            DataStructure obj;
            Attribute oap = (Attribute)itRelations.next();
            if (!oap.getObjectId().equals(relationGuid) || !((obj = oap.getReferencedObject()) instanceof DataObject)) continue;
            be = ((DataObject)obj).getBusinessEntityInterface();
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return be;
    }

    public DataObject getDataObjectByGUID(String guid) throws DataAccessException {
        String method = "getDataObjectByGUID(String)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{guid}, 1);
        DataObject dataObj = null;
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add("com");
        typeList.add("sap");
        typeList.add("caf");
        typeList.add("metamodel");
        typeList.add("DataObject");
        ArrayList<String> col = new ArrayList<String>();
        col.add(guid);
        IConnection con = RepositoryConnection.getConnection();
        Iterator objs = con.selectM1(col, true).iterator();
        while (objs.hasNext()) {
            dataObj = (DataObject)objs.next();
        }
        if (dataObj == null) {
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location);
            throw new DataAccessException("MMR_BO_NOTFOUND", new Object[]{guid});
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return dataObj;
    }

    public DataObject getDataObject(String qualifiedName) throws DataAccessException {
        return this.getDataObject(qualifiedName.substring(0, qualifiedName.indexOf("/")), qualifiedName.substring(qualifiedName.indexOf("/") + 1, qualifiedName.lastIndexOf("/")), qualifiedName.substring(qualifiedName.lastIndexOf("/") + 1));
    }

    public DataObject getDataObject(String provider, String application, String objectName) throws DataAccessException {
        String method = "getDataObject(String, String, String)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{provider, application, objectName}, 1);
        DataObject bo = null;
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add("com");
        typeList.add("sap");
        typeList.add("caf");
        typeList.add("metamodel");
        typeList.add("DataObject");
        QueryFilters filters = new QueryFilters();
        QueryFilter filter = new QueryFilter("objectName", 0, objectName);
        filters.add(filter);
        IConnection con = RepositoryConnection.getConnection();
        Iterator objs = null;
        try {
            objs = con.queryM1(typeList, filters, true).iterator();
        }
        catch (ResourceException e) {
            Object[] args = new Object[]{provider + ":" + application + ":" + objectName};
            CAFPublicLogger.traceThrowableT(100, location, method, "Error getting DataObject of type {0}", args, e);
            location.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
            throw new DataAccessException("MMR_BO_NOTFOUND", args, e);
        }
        while (!(!objs.hasNext() || (bo = (DataObject)objs.next()).getApplication() != null && application != null && provider != null && application.equals(bo.getApplication().getObjectName()) && provider.equals(bo.getApplication().getProviderName()))) {
        }
        if (bo == null) {
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location);
            throw new DataAccessException("MMR_BO_NOTFOUND", new Object[]{objectName});
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return bo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject getDataObject(Class objType) throws DataAccessException {
        String method = "getDataObject(Class)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{objType}, 1);
        try {
            HashMap hashMap = dataObjects;
            synchronized (hashMap) {
                try {
                    DataObject dobj = (DataObject)dataObjects.get(objType);
                    if (dobj == null) {
                        dobj = this.getDataObject(objType.getDeclaredField("provider").get(null).toString(), objType.getDeclaredField("application").get(null).toString(), objType.getDeclaredField("dataObjectId").get(null).toString());
                        dataObjects.put(objType, dobj);
                    }
                    DataObject dataObject = dobj;
                    return dataObject;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Exception e) {
                        Object[] args = new Object[]{objType};
                        CAFPublicLogger.traceThrowableT(100, location, method, "Error getting DataObject of type {0}", args, e);
                        location.throwing(method, (Throwable)e);
                        throw new DataAccessException("MMR_BO_NOTFOUND", args, e);
                    }
                }
            }
        }
        finally {
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        }
    }

    public Attribute getAttribute(String guid) throws DataAccessException {
        String method = "getAttribute(String)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{guid}, 1);
        Attribute attr = null;
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add("com");
        typeList.add("sap");
        typeList.add("caf");
        typeList.add("metamodel");
        typeList.add("Attribute");
        Vector<String> guids = new Vector<String>();
        guids.add(guid);
        IConnection con = RepositoryConnection.getConnection();
        Iterator it = con.selectM1(guids, true).iterator();
        while (it.hasNext()) {
            attr = (Attribute)it.next();
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return attr;
    }

    public Collection getBusinessObjectNames() throws DataAccessException {
        String method = "getBusinessObjectNames()";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, 1);
        ArrayList<String> colNames = new ArrayList<String>();
        Collection colObjects = this.getAllBusinessEntityInterfaces(0);
        Iterator it = colObjects.iterator();
        while (it.hasNext()) {
            BusinessEntityInterface be = (BusinessEntityInterface)it.next();
            colNames.add(be.getObjectName());
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return colNames;
    }

    public Map getAttributes(String qualifiedName) throws DataAccessException {
        String method = "getAttributes(String)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{qualifiedName}, 1);
        HashMap<String, Boolean> mapAttributes = new HashMap<String, Boolean>();
        BusinessEntityInterface be = this.getBusinessEntityInterface(qualifiedName);
        Iterator it = be.getBusinessEntity().getAttributes().iterator();
        while (it.hasNext()) {
            Attribute attr = (Attribute)it.next();
            if (attr.getReferencedObject() == null) {
                mapAttributes.put(attr.getObjectName(), new Boolean(false));
                continue;
            }
            DataStructure obj = attr.getReferencedObject();
            if (!(obj instanceof DataObject)) continue;
            mapAttributes.put(attr.getObjectName(), new Boolean(true));
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return mapAttributes;
    }

    public Collection getAttributes(String qualifiedName, Class cl) throws DataAccessException {
        String method = "getAttributes(String, Class)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{qualifiedName, cl}, 1);
        ArrayList<String> col = new ArrayList<String>();
        BusinessEntityInterface be = this.getBusinessEntityInterface(qualifiedName);
        if (be == null) {
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
            throw new DataAccessException("MMR_BO_NOTFOUND", new Object[]{qualifiedName + cl});
        }
        Iterator it = be.getBusinessEntity().getAttributes().iterator();
        while (it.hasNext()) {
            Attribute attr = (Attribute)it.next();
            if (attr.getReferencedObject() == null) {
                try {
                    IDataType type = DataTypeBroker.getDataType((String)("ddic:" + attr.getTypeJavaDdic()), (Locale)Locale.getDefault(), (ClassLoader)Thread.currentThread().getContextClassLoader());
                    if (!type.getAssociatedClass().equals(cl)) continue;
                    col.add(attr.getObjectName());
                    continue;
                }
                catch (Exception e) {
                    Object[] args = new Object[]{qualifiedName + cl};
                    CAFPublicLogger.traceThrowableT(100, location, method, "Error getting Attributes of type {0}", args, e);
                    location.throwing(method, (Throwable)e);
                    throw new DataAccessException("MMR_BO_NOTFOUND", args, e);
                }
            }
            DataStructure obj = attr.getReferencedObject();
            if (!(obj instanceof DataObject)) continue;
            Iterator it2 = ((DataObject)obj).getAttributes().iterator();
            while (it.hasNext()) {
                Attribute attr2 = (Attribute)it.next();
                try {
                    IDataType type2 = DataTypeBroker.getDataType((String)("ddic:" + attr.getTypeJavaDdic()), (Locale)Locale.getDefault(), (ClassLoader)Thread.currentThread().getContextClassLoader());
                    if (!type2.getAssociatedClass().equals(cl)) continue;
                    col.add(attr.getObjectName() + "." + attr2.getObjectName());
                }
                catch (Exception e) {
                    Object[] args = new Object[]{qualifiedName + cl};
                    CAFPublicLogger.traceThrowableT(100, location, method, "Error getting Attributes of type {0}", args, e);
                    location.throwing(method, (Throwable)e);
                    throw new DataAccessException("MMR_BO_NOTFOUND", args, e);
                }
            }
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return col;
    }

    public Collection readMMRObjects(String modelPackage, String objectType, String guid) throws DataAccessException {
        IConnection connection = RepositoryConnection.getConnection();
        if (connection == null) {
            throw new DataAccessException("MMR_CON_OPEN_ERROR");
        }
        Utilities utils = Utilities.getUtilities();
        List typeList = utils.decodeQualifiedName(modelPackage + "." + objectType);
        QueryFilters filters = null;
        if (guid != null) {
            filters = new QueryFilters();
            QueryFilter filter = new QueryFilter("objectID", 0, guid);
            filters.add(filter);
        }
        List c = null;
        try {
            c = connection.queryM1(typeList, filters, true);
        }
        catch (ResourceException ex) {
            throw new DataAccessException(ex.getMessage());
        }
        return c;
    }

    public void closeConnection() throws DataAccessException {
        CAFPublicLogger.entering(null, JARM_REQUEST, "closeConnection()", location, 1);
        RepositoryConnection.closeConnection();
        CAFPublicLogger.exiting(null, JARM_REQUEST, "closeConnection()", location, 1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

