/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.bol.util;

import com.sap.caf.rt.bol.util.IntQueryFilter;
import java.math.BigDecimal;
import java.util.Date;

public class QueryFilter {
    public String attribute;
    public String valueLow;
    public String valueHigh;
    public BigDecimal bigIntValueLow;
    public BigDecimal bigIntValueHigh;
    public int intValueLow;
    public int intValueHigh;
    public Date dateValueLow;
    public Date dateValueHigh;
    public String condition;
    public boolean isString;
    public boolean isBigInt;
    public boolean isInt;
    public boolean isDate;
    public String operation;
    public String datatype;
    public String action;
    public static final String CONDITION_EQ = "==";
    public static final String CONDITION_LT = "<";
    public static final String CONDITION_GT = ">";
    public static final String CONDITION_LE = "<=";
    public static final String CONDITION_GE = ">=";
    public static final String CONDITION_NOT = "!=";
    public static final String CONDITION_BETWEEN = "<>";
    public static final String OPERATION_CATEGORY = "category";
    public static final String OPERATION_ATTRIBUTE = "attribute";
    public static final String OPERATION_TERM = "term";
    public static final String OPERATION_AND = "and";
    public static final String OPERATION_OR = "or";
    public static final String OPERATION_NOT = "not";
    public static final String OPERATION_BRACKET_OPEN = "(";
    public static final String OPERATION_BRACKET_CLOSE = ")";
    public static final String DATATYPE_STRING = "String";
    public static final String DATATYPE_INT = "int";
    public static final String DATATYPE_DATE = "Date";
    public static final String DATATYPE_TEXT = "text";
    public static final String ACTION_LINGUISTIC = "linguistic";
    public static final String ACTION_FUZZY = "fuzzy";
    public static final String ACTION_EXACT = "exact";

    public QueryFilter() {
    }

    public static QueryFilter getQueryFilter(Object value) {
        QueryFilter qf = null;
        if (value instanceof QueryFilter) {
            qf = (QueryFilter)value;
        } else if (value instanceof IntQueryFilter) {
            qf = (IntQueryFilter)value;
        } else if (value instanceof String) {
            qf = ((String)value).trim().equals("") ? new QueryFilter("*") : new QueryFilter((String)value);
        } else if (value instanceof Date) {
            qf = new QueryFilter((Date)value);
        } else if (value instanceof Integer) {
            qf = new QueryFilter((Integer)value);
        } else if (value instanceof Number) {
            qf = new QueryFilter(new BigDecimal(((Number)value).toString()));
        } else if (value == null) {
            qf = new QueryFilter("*");
        }
        return qf;
    }

    protected QueryFilter(QueryFilter qFilter) {
        this.condition = qFilter.condition;
        if (qFilter.isString) {
            this.isString = true;
            this.valueLow = qFilter.valueLow;
            this.valueHigh = qFilter.valueHigh;
        } else if (qFilter.isBigInt) {
            this.isBigInt = true;
            this.bigIntValueLow = qFilter.bigIntValueLow;
            this.bigIntValueHigh = qFilter.bigIntValueHigh;
        } else if (qFilter.isInt) {
            this.isInt = true;
            this.intValueLow = qFilter.intValueLow;
            this.intValueHigh = qFilter.intValueHigh;
        } else if (qFilter.isDate) {
            this.isDate = true;
            this.dateValueLow = qFilter.dateValueLow;
            this.dateValueHigh = qFilter.dateValueHigh;
        }
        this.datatype = qFilter.datatype;
        this.action = qFilter.action;
    }

    public QueryFilter(String value) {
        this.isString = true;
        this.valueLow = value;
        this.valueHigh = value;
        this.condition = CONDITION_EQ;
        this.datatype = DATATYPE_STRING;
        this.action = ACTION_LINGUISTIC;
    }

    public QueryFilter(String value, String condition) {
        this.isString = true;
        this.valueLow = value;
        this.valueHigh = value;
        this.condition = condition;
        this.datatype = DATATYPE_STRING;
        this.action = ACTION_LINGUISTIC;
    }

    public QueryFilter(BigDecimal value, String condition) {
        this.isBigInt = true;
        this.bigIntValueLow = value;
        this.bigIntValueHigh = value;
        this.condition = condition;
        this.datatype = DATATYPE_INT;
    }

    public QueryFilter(BigDecimal valueLow, BigDecimal valueHigh) {
        this.isBigInt = true;
        this.bigIntValueLow = valueLow;
        this.bigIntValueHigh = valueHigh;
        this.condition = CONDITION_BETWEEN;
        this.datatype = DATATYPE_INT;
    }

    public QueryFilter(int value) {
        this.isInt = true;
        this.intValueLow = value;
        this.intValueHigh = value;
        this.condition = CONDITION_EQ;
        this.datatype = DATATYPE_INT;
    }

    public QueryFilter(BigDecimal value) {
        this.isBigInt = true;
        this.bigIntValueLow = value;
        this.bigIntValueHigh = value;
        this.condition = CONDITION_EQ;
        this.datatype = DATATYPE_INT;
    }

    public QueryFilter(int value, String condition) {
        this.isInt = true;
        this.intValueLow = value;
        this.intValueHigh = value;
        this.condition = condition;
        this.datatype = DATATYPE_INT;
    }

    public QueryFilter(int valueLow, int valueHigh) {
        this.isInt = true;
        this.intValueLow = valueLow;
        this.intValueHigh = valueHigh;
        this.condition = CONDITION_BETWEEN;
        this.datatype = DATATYPE_INT;
    }

    public QueryFilter(Date value) {
        this.isDate = true;
        this.dateValueLow = value;
        this.dateValueHigh = value;
        this.condition = CONDITION_EQ;
        this.datatype = DATATYPE_DATE;
    }

    public QueryFilter(Date value, String condition) {
        this.isDate = true;
        this.dateValueLow = value;
        this.dateValueHigh = value;
        this.condition = condition;
        this.datatype = DATATYPE_DATE;
    }

    public QueryFilter(Date valueLow, Date valueHigh) {
        this.isDate = true;
        this.dateValueLow = valueLow;
        this.dateValueHigh = valueHigh;
        this.condition = CONDITION_BETWEEN;
        this.datatype = DATATYPE_DATE;
    }

    public static QueryFilter createNumericFilter(String condition, int value, String name, boolean bAttribute) {
        QueryFilter filter = new QueryFilter();
        filter.condition = condition;
        filter.attribute = name;
        filter.intValueLow = value;
        filter.datatype = DATATYPE_INT;
        filter.isInt = true;
        filter.operation = bAttribute ? OPERATION_ATTRIBUTE : OPERATION_CATEGORY;
        return filter;
    }

    public static QueryFilter createStringFilter(String action, String value, String name, boolean bAttribute) {
        QueryFilter filter = new QueryFilter();
        filter.action = action;
        filter.valueLow = value;
        filter.attribute = name;
        filter.datatype = DATATYPE_STRING;
        filter.isString = true;
        filter.operation = bAttribute ? OPERATION_ATTRIBUTE : OPERATION_CATEGORY;
        return filter;
    }

    public static QueryFilter createFreetextFilter(String action, String value) {
        QueryFilter filter = new QueryFilter();
        filter.action = action;
        filter.valueLow = value;
        filter.datatype = DATATYPE_STRING;
        filter.isString = true;
        filter.operation = OPERATION_ATTRIBUTE;
        filter.attribute = "*";
        return filter;
    }

    public static QueryFilter createDateFilter(String condition, Date value, String name) {
        QueryFilter filter = new QueryFilter();
        filter.condition = condition;
        filter.dateValueLow = value;
        filter.attribute = name;
        filter.datatype = DATATYPE_DATE;
        filter.isDate = true;
        filter.operation = OPERATION_ATTRIBUTE;
        return filter;
    }

    public static QueryFilter createBracket(String type) {
        QueryFilter filter = new QueryFilter();
        filter.operation = type;
        return filter;
    }

    public static QueryFilter createBoolOperator(String type) {
        QueryFilter filter = new QueryFilter();
        filter.operation = type;
        return filter;
    }
}

