/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.bol.util;

import com.sap.caf.rt.bol.util.QueryFilter;
import com.sap.caf.rt.exception.CAFBaseRuntimeException;
import com.sap.caf.rt.util.CAFResourceAccessor;
import com.sap.exception.BaseRuntimeException;
import com.sap.tc.logging.Location;
import java.math.BigDecimal;

public class IntQueryFilter
extends QueryFilter {
    public static final int BOOL_OPERATION_AND = 0;
    public static final int BOOL_OPERATION_OR_START = 1;
    public static final int BOOL_OPERATION_OR_END = 2;
    public static final int BOOL_OPERATION_INNER_OR = 3;
    public static final int BOOL_OPERATION_NOT = 32;
    protected int inStatementCondition;
    private String attrName1;
    private String attrName2;
    private static int attrNumber;
    public boolean isCollection;
    private String collectionAttribute;
    private String collectionType;
    public boolean isEntityRefCollection;
    private String entityRefCollectionAttribute;
    private String entityRefCollectionType;
    private static Object[] allowedConditions;
    protected boolean m_isEmpty;
    private static final Location location;
    static /* synthetic */ Class class$com$sap$caf$rt$bol$util$IntQueryFilter;

    public IntQueryFilter() {
        this.m_isEmpty = true;
    }

    public IntQueryFilter(QueryFilter qFilter) {
        super(qFilter);
        this.m_isEmpty = "*".equals(this.valueLow);
    }

    public Object getAttributeValue() {
        Comparable<BigDecimal> attribVal = null;
        if (this.isString) {
            if (this.valueLow != null && this.valueLow.startsWith("*")) {
                attribVal = this.valueLow.substring(1);
            } else if (this.valueLow != null && this.valueLow.endsWith("*")) {
                attribVal = this.valueLow.substring(0, this.valueLow.length() - 1);
            } else if (this.valueLow != null) {
                attribVal = this.valueLow.trim();
            }
        } else {
            attribVal = this.isInt ? new Integer(this.intValueLow) : (this.isBigInt ? this.bigIntValueLow : this.dateValueLow);
        }
        return attribVal;
    }

    public Object getAttributeValueHigh() {
        Object attribVal = null;
        attribVal = this.isString ? this.valueHigh.trim() : (this.isInt ? new Integer(this.intValueHigh) : (this.isBigInt ? this.bigIntValueHigh : this.dateValueHigh));
        return attribVal;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String parameter) {
        String extracted;
        this.attribute = parameter;
        if (this.attribute != null && this.collectionAttribute != null && (extracted = IntQueryFilter.extractAttribute(this.attribute)).equals(IntQueryFilter.extractAttribute(this.collectionAttribute))) {
            this.attribute = this.attribute.substring(0, extracted.length()) + "_" + this.attribute.substring(extracted.length());
        }
    }

    public String getCollectionAttribute() {
        return this.collectionAttribute;
    }

    public void setCollectionAttribute(String parameter) {
        String extracted;
        this.isCollection = true;
        this.collectionAttribute = parameter;
        if (this.attribute != null && this.collectionAttribute != null && (extracted = IntQueryFilter.extractAttribute(this.collectionAttribute)).equals(IntQueryFilter.extractAttribute(this.attribute))) {
            this.collectionAttribute = this.collectionAttribute.substring(0, extracted.length()) + "_" + this.collectionAttribute.substring(extracted.length());
        }
    }

    public String getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(String type) {
        this.collectionType = type;
    }

    public String getEntityReCollectionAttribute() {
        return this.entityRefCollectionAttribute;
    }

    public void setEntityRefCollectionAttribute(String parameter) {
        this.isEntityRefCollection = true;
        this.entityRefCollectionAttribute = parameter;
    }

    public String getEntityRefCollectionType() {
        return this.entityRefCollectionType;
    }

    public void setEntityRefCollectionType(String type) {
        this.entityRefCollectionType = type;
    }

    public static String extractAttribute(String attr) {
        int nLength = attr.indexOf(46);
        return nLength == -1 ? attr : attr.substring(0, nLength);
    }

    public static String createParameter(String attr) {
        return attr.replace('.', '_');
    }

    public String getJdoFilter() {
        String colInstance;
        String filter = "";
        if (this.isEntityRefCollection) {
            colInstance = IntQueryFilter.extractAttribute(this.isCollection ? this.collectionAttribute : this.attribute);
            filter = filter + "(" + this.getEntityReCollectionAttribute() + ".contains(" + colInstance + "))" + " && ";
        }
        if (this.isCollection) {
            colInstance = IntQueryFilter.extractAttribute(this.attribute);
            filter = filter + "(" + this.getCollectionAttribute() + ".contains(" + colInstance + "))" + " && ";
        }
        filter = filter + this.getJdoFilterInternal();
        return filter;
    }

    public String getJdoMapCollFilter() {
        String filter = this.getJdoMapFilterInternal();
        if (this.isEmpty()) {
            filter = "";
        }
        return filter;
    }

    public String getJdoCollVariables() {
        String colInstance;
        if (this.isEmpty()) {
            return null;
        }
        String vars = "";
        if (this.isEntityRefCollection) {
            if (!"".equals(vars)) {
                vars = vars + "; ";
            }
            colInstance = IntQueryFilter.extractAttribute(this.isCollection ? this.collectionAttribute : this.attribute);
            vars = vars + this.getEntityRefCollectionType() + " " + colInstance;
        }
        if (this.isCollection) {
            if (!"".equals(vars)) {
                vars = vars + "; ";
            }
            colInstance = IntQueryFilter.extractAttribute(this.attribute);
            vars = vars + this.getCollectionType() + " " + colInstance;
        }
        return "".equals(vars) ? null : vars;
    }

    private String getJdoFilterInternal() {
        String filter = null;
        boolean conditionOk = false;
        for (int i = 0; i < allowedConditions.length; ++i) {
            if (allowedConditions[i] != this.condition) continue;
            conditionOk = true;
            break;
        }
        if (!conditionOk) {
            throw new BaseRuntimeException(CAFResourceAccessor.getResourceAccessor(), "JDO_QUERY_INVALID_DATA", new Object[]{this.condition});
        }
        if (this.isString) {
            filter = this.valueLow != null && this.valueLow.endsWith("*") ? this.attribute + ".startsWith(\"" + this.valueLow.substring(0, this.valueLow.length() - 1) + "\")" : (this.valueLow != null && this.valueLow.startsWith("*") ? this.attribute + ".endsWith(\"" + this.valueLow.substring(1) + "\")" : this.attribute + ' ' + this.condition + ' ' + "\"" + this.valueLow.trim() + "\"");
        } else if (this.isBigInt) {
            filter = this.bigIntValueLow == this.bigIntValueHigh && this.condition != "<>" ? this.attribute + ' ' + this.condition + ' ' + this.bigIntValueLow : this.attribute + " >= " + this.bigIntValueLow + " && " + this.attribute + " <= " + this.bigIntValueHigh;
        } else if (this.isInt) {
            filter = this.intValueLow == this.intValueHigh && this.condition != "<>" ? this.attribute + ' ' + this.condition + ' ' + this.intValueLow : this.attribute + " >= " + this.intValueLow + " && " + this.attribute + " <= " + this.intValueHigh;
        } else if (this.isDate) {
            filter = this.dateValueLow.equals(this.dateValueHigh) && this.condition != "<>" ? this.attribute + ' ' + this.condition + ' ' + "\"" + this.dateValueLow + "\"" : this.attribute + " >= " + "\"" + this.dateValueLow + "\"" + " && " + this.attribute + " <= " + this.dateValueHigh;
        }
        return filter;
    }

    public String getJdoMapFilterInternal() {
        String filter = "";
        boolean conditionOk = false;
        for (int i = 0; i < allowedConditions.length; ++i) {
            if (allowedConditions[i] != this.condition) continue;
            conditionOk = true;
            break;
        }
        if (!conditionOk) {
            throw new BaseRuntimeException(CAFResourceAccessor.getResourceAccessor(), "JDO_QUERY_INVALID_DATA", new Object[]{this.condition});
        }
        String paramString = IntQueryFilter.createParameter(this.attribute);
        this.attrName1 = paramString + IntQueryFilter.getAttributeNumber();
        this.attrName2 = paramString + IntQueryFilter.getAttributeNumber();
        if (this.isEmpty()) {
            return "";
        }
        if (this.isEntityRefCollection) {
            filter = filter + this.entityRefCollectionAttribute + ".contains(" + IntQueryFilter.extractAttribute(this.isCollection ? this.collectionAttribute : this.attribute) + ") && ";
        }
        if (this.isCollection) {
            filter = filter + this.collectionAttribute + ".contains(" + IntQueryFilter.extractAttribute(this.attribute) + ") && ";
        }
        if (this.isString) {
            filter = this.valueLow != null && this.valueLow.startsWith("*") ? filter + this.attribute + ".endsWith(" + this.attrName1 + ")" : (this.valueLow != null && this.valueLow.endsWith("*") ? filter + this.attribute + ".startsWith(" + this.attrName1 + ")" : filter + this.attribute + ' ' + this.condition + ' ' + this.attrName1);
        } else if (this.isDate || this.isInt || this.isBigInt) {
            filter = this.condition != "<>" ? filter + this.attribute + ' ' + this.condition + ' ' + this.attrName1 : filter + this.attribute + " >= " + this.attrName1 + " && " + this.attribute + " <= " + this.attrName2;
        }
        int inStatementCondition = this.getInStatementCondition();
        if ((inStatementCondition & 0x20) != 0) {
            filter = "!" + filter;
        }
        switch (inStatementCondition &= 0xFFFFFFDF) {
            case 0: {
                break;
            }
            case 1: {
                filter = " (" + filter;
                break;
            }
            case 3: {
                filter = " || " + filter;
                break;
            }
            case 2: {
                filter = " || " + filter + ") ";
                break;
            }
        }
        return filter;
    }

    public String getJdoMapFilter() {
        String filter = null;
        filter = this.isCollection ? this.getJdoMapCollFilter() : this.getJdoMapFilterInternal();
        return filter;
    }

    public boolean isEmpty() {
        return this.m_isEmpty;
    }

    public static String joinFilter(String qf1, IntQueryFilter qf2) {
        return IntQueryFilter.joinFilter(qf1, qf2, null);
    }

    public static String joinFilter(String qf1, IntQueryFilter qf2, String operation) {
        if (operation == null || operation.length() == 0) {
            operation = " && ";
        }
        return qf1 == null || qf1.length() == 0 ? (qf2 == null || qf2.isEmpty() ? "" : qf2.getJdoFilter()) : (qf2.isEmpty() ? qf1 : qf1 + operation + qf2.getJdoFilter());
    }

    public static String joinFilter(IntQueryFilter qf1, IntQueryFilter qf2) {
        return IntQueryFilter.joinFilter(qf1, qf2, null);
    }

    public static String joinFilterMap(IntQueryFilter qf1, IntQueryFilter qf2, String operation) {
        return qf1 == null ? IntQueryFilter.joinFilterMap("", qf2) : IntQueryFilter.joinFilterMap(qf1.getJdoMapFilter(), qf2, operation);
    }

    public static String joinFilterMap(String qf1, IntQueryFilter qf2, String operation) {
        StringBuffer result = new StringBuffer(50);
        if (qf1 != null && qf1.length() > 0) {
            result.append(qf1);
            if (operation == null || operation.length() == 0) {
                operation = " && ";
            }
            if (qf2 != null) {
                if (qf2.getInStatementCondition() != 3 && qf2.getInStatementCondition() != 2 && !qf2.isEmpty()) {
                    result.append(operation);
                }
                result.append(qf2.getJdoMapFilter());
            }
        } else if (qf2 != null) {
            result.append(qf2.getJdoMapFilter());
        }
        return result.toString();
    }

    public static String joinFilter(IntQueryFilter qf1, IntQueryFilter qf2, String operation) {
        if (operation == null || operation.length() == 0) {
            operation = " && ";
        }
        String filter = qf1.isEmpty() ? (qf2 == null || qf2.isEmpty() ? "" : qf2.getJdoFilter()) : (qf2.isEmpty() ? qf1.getJdoFilter() : qf1.getJdoFilter() + operation + qf2.getJdoFilter());
        return filter;
    }

    public static String joinFilterMap(String qf1, IntQueryFilter qf2) {
        return IntQueryFilter.joinFilter(qf1, qf2, null);
    }

    public static String joinFilterMap(IntQueryFilter qf1, IntQueryFilter qf2) {
        return IntQueryFilter.joinFilter(qf1, qf2, null);
    }

    public int getInStatementCondition() {
        return this.inStatementCondition;
    }

    public void setInStatementCondition(int condition) {
        this.inStatementCondition = condition;
    }

    public String getAttributeName1() {
        if (this.attrName1 == null) {
            throw new CAFBaseRuntimeException("You must call getJdoMapFilter() or joinFilterMap() to be able to get an attribute name.");
        }
        return this.attrName1;
    }

    public String getAttributeName2() {
        if (this.attrName1 == null) {
            throw new CAFBaseRuntimeException("You must call getJdoMapFilter() or joinFilterMap() to be able to get an attribute name.");
        }
        return this.attrName2;
    }

    private static synchronized int getAttributeNumber() {
        return attrNumber++;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        allowedConditions = new Object[]{"==", "!=", ">", ">=", "<", "<=", "<>"};
        location = Location.getLocation((Class)(class$com$sap$caf$rt$bol$util$IntQueryFilter == null ? (class$com$sap$caf$rt$bol$util$IntQueryFilter = IntQueryFilter.class$("com.sap.caf.rt.bol.util.IntQueryFilter")) : class$com$sap$caf$rt$bol$util$IntQueryFilter));
    }
}

