/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.bol.da;

import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.bol.da.IDataAccessService;
import java.util.ArrayList;
import java.util.List;

public class DataStoreQueue {
    private static ThreadLocal queue = new ThreadLocal();
    private List newInstances = new ArrayList();
    private List dirtyInstances = new ArrayList();
    private List deletedInstances = new ArrayList();
    private IDataAccessService da;

    public void registerNew(IDependentObject obj) {
        if (!this.newInstances.contains(obj)) {
            this.newInstances.add(obj);
        }
    }

    public void registerDirty(IDependentObject obj) {
        if (!this.dirtyInstances.contains(obj) && !this.newInstances.contains(obj)) {
            this.dirtyInstances.add(obj);
        }
    }

    public void registerDeleted(IDependentObject obj) {
        if (this.newInstances.remove(obj)) {
            return;
        }
        this.dirtyInstances.remove(obj);
        if (!this.deletedInstances.contains(obj)) {
            this.deletedInstances.add(obj);
        }
    }

    public void unregister(IDependentObject obj) {
        if (this.deletedInstances.remove(obj)) {
            return;
        }
        if (this.newInstances.remove(obj)) {
            return;
        }
        this.dirtyInstances.remove(obj);
    }

    public List getNewInstances() {
        return this.newInstances;
    }

    public List getDirtyInstances() {
        return this.dirtyInstances;
    }

    public List getDeletedInstances() {
        return this.deletedInstances;
    }

    public boolean isEmpty() {
        return this.newInstances.isEmpty() && this.dirtyInstances.isEmpty();
    }
}

