/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.bol;

import com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchClassify;
import com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchSearch;
import com.sap.caf.km.ejb.svc.idxsearch.bean.IndexSearchLocalHome;
import com.sap.caf.km.ejb.svc.idxsearch.common.ClassifyException;
import com.sap.caf.km.ejb.svc.idxsearch.common.ISearchResult;
import com.sap.caf.km.ejb.svc.idxsearch.common.SearchException;
import com.sap.caf.rt.bol.IBusinessEntityService;
import com.sap.caf.rt.bol.IBusinessObject;
import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.bol.IKMExt;
import com.sap.caf.rt.bol.context.CAFContext;
import com.sap.caf.rt.exception.BEException;
import com.sap.caf.rt.exception.CAFCreateException;
import com.sap.caf.rt.exception.CAFDeleteException;
import com.sap.caf.rt.exception.CAFFindException;
import com.sap.caf.rt.exception.CAFRetrieveException;
import com.sap.caf.rt.exception.CAFUpdateException;
import com.sap.caf.rt.services.notify.notif.bobject.BOChangedPublisher;
import com.sap.caf.rt.services.publish.PublishingLocal;
import com.sap.caf.rt.services.publish.PublishingLocalHome;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public abstract class EntityServiceBase
implements IBusinessEntityService {
    protected BOChangedPublisher notifPub;
    protected SessionContext sessionContext;
    protected PublishingLocal pub;
    private static final Location location = Location.getLocation((Class)(class$com$sap$caf$rt$bol$EntityServiceBase == null ? (class$com$sap$caf$rt$bol$EntityServiceBase = EntityServiceBase.class$("com.sap.caf.rt.bol.EntityServiceBase")) : class$com$sap$caf$rt$bol$EntityServiceBase));
    private static final String APPLICATION = (class$com$sap$caf$rt$bol$EntityServiceBase == null ? (class$com$sap$caf$rt$bol$EntityServiceBase = EntityServiceBase.class$("com.sap.caf.rt.bol.EntityServiceBase")) : class$com$sap$caf$rt$bol$EntityServiceBase).getName();
    private static final String JARM_REQUEST = "CAF:RT:BOL" + APPLICATION;
    private IIndexSearchSearch indexSearchSearch;
    private IIndexSearchClassify indexSearchClassify;
    private static final String KM_EAR_NAME = "localejbs/sap.com/caf~com.sap.caf.runtime";
    protected String _objectName;
    private static final String INDEX_SEARCH_BEAN_NAME = "IndexSearchBean";
    static /* synthetic */ Class class$com$sap$caf$rt$bol$EntityServiceBase;
    static /* synthetic */ Class class$com$sap$caf$rt$bol$IDependentObject;
    static /* synthetic */ Class class$java$lang$String;

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext context) {
        this.sessionContext = context;
        if (CAFContext.PUBLISH_ENABLED) {
            this.notifPub = new BOChangedPublisher(this);
        }
    }

    protected void initPublishing() throws BEException {
        String method = "initPublishing()";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering(user, JARM_REQUEST, method, location, 1);
        try {
            InitialContext ctx = new InitialContext();
            PublishingLocalHome home = (PublishingLocalHome)ctx.lookup("localejbs/sap.com/caf.runtime/Publishing");
            this.pub = home.create();
        }
        catch (NamingException e) {
            Object[] args = new Object[]{"localejbs/sap.com/caf.runtime/Publishing"};
            CAFPublicLogger.categoryCAF.logThrowableT(500, location, method, "Error in JNDI lookup of {0}", args, (Throwable)e);
            location.throwing(method, (Throwable)e);
            throw new BEException(e);
        }
        catch (CreateException e) {
            CAFPublicLogger.traceThrowableT(100, location, method, "Error in " + method, e);
            location.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting(user, JARM_REQUEST, method, location, 1);
            throw new BEException(e);
        }
        finally {
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        }
    }

    protected Object[] getPublishingArgs(IBusinessObject object) throws Exception {
        Iterator it;
        String method = "getPublishingArgs(IBusinessObject)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{object.getKey()}, 1);
        Object[] msgArgs = new Object[]{object.getObjectType(), object.getKey(), object.getRid(), ""};
        if (object instanceof IKMExt && (it = ((IKMExt)((Object)object)).getRelatedObjectRids().iterator()).hasNext()) {
            StringBuffer buffer = new StringBuffer(256);
            do {
                buffer.append((String)it.next()).append(';');
            } while (it.hasNext());
            buffer.setLength(buffer.length() - 1);
            msgArgs[3] = buffer.toString();
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, new Object[]{msgArgs}, 1);
        return msgArgs;
    }

    public IDependentObject createGeneric(List attributes) throws CAFCreateException {
        IDependentObject result;
        String user = this.sessionContext.getCallerPrincipal().getName();
        String method = "createGeneric(List)";
        CAFPublicLogger.entering(user, JARM_REQUEST, method, location, new Object[]{attributes}, 1);
        int size = attributes.size();
        Class[] parameterTypes = new Class[size];
        Object[] args = new Object[size];
        Iterator iter = attributes.iterator();
        for (int i = 0; i < size; ++i) {
            Object attribute = iter.next();
            parameterTypes[i] = attribute.getClass();
            args[i] = attribute;
        }
        try {
            Method createMethod = this.getClass().getMethod("create", parameterTypes);
            result = (IDependentObject)createMethod.invoke((Object)this, args);
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowable(300, CAFPublicLogger.LOC_CAF, method, e);
            CAFPublicLogger.exiting(user, JARM_REQUEST, method, location);
            throw new CAFCreateException(e);
        }
        CAFPublicLogger.exiting(user, JARM_REQUEST, method, location, new Object[]{result}, 1);
        return result;
    }

    public void deleteGeneric(IDependentObject object) throws CAFDeleteException {
        String user = this.sessionContext.getCallerPrincipal().getName();
        String method = "deleteGeneric(IDependentObject)";
        CAFPublicLogger.entering(user, JARM_REQUEST, method, location, new Object[]{object}, 1);
        try {
            Method deleteMethod = this.getClass().getMethod("delete", class$com$sap$caf$rt$bol$IDependentObject == null ? (class$com$sap$caf$rt$bol$IDependentObject = EntityServiceBase.class$("com.sap.caf.rt.bol.IDependentObject")) : class$com$sap$caf$rt$bol$IDependentObject);
            deleteMethod.invoke((Object)this, object);
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowable(300, CAFPublicLogger.LOC_CAF, method, e);
            CAFPublicLogger.exiting(user, JARM_REQUEST, method, location, 1);
            throw new CAFDeleteException(e);
        }
        CAFPublicLogger.exiting(user, JARM_REQUEST, method, location, 1);
    }

    public Collection findGeneric(String operationName, List attributes) throws CAFFindException {
        Collection result;
        String user = this.sessionContext.getCallerPrincipal().getName();
        String method = "findGeneric(String, List)";
        CAFPublicLogger.entering(user, JARM_REQUEST, method, location, new Object[]{operationName, attributes}, 1);
        int size = attributes.size();
        Class[] parameterTypes = new Class[size];
        Object[] args = new Object[size];
        Iterator iter = attributes.iterator();
        for (int i = 0; i < size; ++i) {
            Object attribute = iter.next();
            parameterTypes[i] = attribute.getClass();
            args[i] = attribute;
        }
        try {
            Method findMethod = this.getClass().getMethod(operationName, parameterTypes);
            result = (Collection)findMethod.invoke((Object)this, args);
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowable(300, CAFPublicLogger.LOC_CAF, method, e);
            CAFPublicLogger.exiting(user, JARM_REQUEST, method, location, 1);
            throw new CAFFindException(e);
        }
        CAFPublicLogger.exiting(user, JARM_REQUEST, method, location, new Object[]{result}, 1);
        return result;
    }

    public IDependentObject readGeneric(String key) throws CAFRetrieveException {
        IDependentObject result;
        String user = this.sessionContext.getCallerPrincipal().getName();
        String method = "readGeneric(String)";
        CAFPublicLogger.entering(user, JARM_REQUEST, method, location, new Object[]{key}, 1);
        try {
            Method readMethod = this.getClass().getMethod("read", class$java$lang$String == null ? (class$java$lang$String = EntityServiceBase.class$("java.lang.String")) : class$java$lang$String);
            result = (IDependentObject)readMethod.invoke((Object)this, key);
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowable(300, CAFPublicLogger.LOC_CAF, method, e);
            CAFPublicLogger.exiting(user, JARM_REQUEST, method, location, 1);
            throw new CAFRetrieveException(e);
        }
        CAFPublicLogger.exiting(user, JARM_REQUEST, method, location, new Object[]{result}, 1);
        return result;
    }

    public void updateGeneric(IDependentObject object) throws CAFUpdateException {
        String user = this.sessionContext.getCallerPrincipal().getName();
        String method = "updateGeneric(IDependentObject)";
        CAFPublicLogger.entering(user, JARM_REQUEST, method, location, new Object[]{object}, 1);
        try {
            Method updateMethod = this.getClass().getMethod("update", class$com$sap$caf$rt$bol$IDependentObject == null ? (class$com$sap$caf$rt$bol$IDependentObject = EntityServiceBase.class$("com.sap.caf.rt.bol.IDependentObject")) : class$com$sap$caf$rt$bol$IDependentObject);
            updateMethod.invoke((Object)this, object);
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowable(300, CAFPublicLogger.LOC_CAF, method, e);
            CAFPublicLogger.exiting(user, JARM_REQUEST, method, location, 1);
            throw new CAFUpdateException(e);
        }
        CAFPublicLogger.exiting(user, JARM_REQUEST, method, location, 1);
    }

    public Collection findByKMPropertySearch(Map mapAttributeNameToFilter, Map mapCategoryNameToFilter) throws FinderException, CAFFindException {
        String method = "findByKMPropertySearch(Map, Map)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering(user, JARM_REQUEST, method, location, new Object[]{mapAttributeNameToFilter, mapCategoryNameToFilter}, 1);
        if (null == mapAttributeNameToFilter || null == mapCategoryNameToFilter) {
            throw new CAFFindException(new NullPointerException("The Parameters of ejbFindByKMPropertySearch function could not be null."));
        }
        LinkedList<String> keySet = new LinkedList<String>();
        try {
            try {
                this.initIndexSearchContext();
                Collection resultSet = this.indexSearchSearch.searchForBO(mapAttributeNameToFilter, mapCategoryNameToFilter, this._objectName);
                Iterator iter = resultSet.iterator();
                while (iter.hasNext()) {
                    ISearchResult result = (ISearchResult)iter.next();
                    String sKey = result.getBOGuid();
                    if (sKey == null || sKey.length() <= 0) continue;
                    keySet.add(sKey);
                }
                Object var11_11 = null;
            }
            catch (Exception ex) {
                CAFPublicLogger.traceThrowableT(100, location, method, "Error in " + method, ex);
                location.throwing(method, (Throwable)ex);
                throw new CAFFindException("BO_FIND", (Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            CAFPublicLogger.exiting(user, JARM_REQUEST, method, location, new Object[]{keySet}, 1);
            throw throwable;
        }
        CAFPublicLogger.exiting(user, JARM_REQUEST, method, location, new Object[]{keySet}, 1);
        return keySet;
    }

    public Collection findByKMPropertySearch(Collection collectionFilters) throws FinderException, CAFFindException {
        String method = "findByKMPropertySearch(Collection)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering(user, JARM_REQUEST, method, location, new Object[]{collectionFilters}, 1);
        if (null == collectionFilters) {
            throw new CAFFindException(new NullPointerException("The Parameter of ejbFindByKMPropertySearch function could not be null."));
        }
        LinkedList<String> keySet = new LinkedList<String>();
        try {
            try {
                this.initIndexSearchContext();
                Collection resultSet = this.indexSearchSearch.searchForBO(collectionFilters, this._objectName);
                Iterator iter = resultSet.iterator();
                while (iter.hasNext()) {
                    ISearchResult result = (ISearchResult)iter.next();
                    String sKey = result.getBOGuid();
                    if (sKey == null || sKey.length() <= 0) continue;
                    keySet.add(sKey);
                }
                Object var10_10 = null;
            }
            catch (Exception ex) {
                CAFPublicLogger.traceThrowableT(100, location, method, "Error in " + method, ex);
                location.throwing(method, (Throwable)ex);
                throw new CAFFindException("BO_FIND", (Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            CAFPublicLogger.exiting(user, JARM_REQUEST, method, location, new Object[]{keySet}, 1);
            throw throwable;
        }
        CAFPublicLogger.exiting(user, JARM_REQUEST, method, location, new Object[]{keySet}, 1);
        return keySet;
    }

    private void initIndexSearchContext() throws BEException {
        String method = "initIndexSearchContext()";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering(user, JARM_REQUEST, method, location, 1);
        if (this.indexSearchSearch != null && this.indexSearchClassify != null) {
            CAFPublicLogger.exiting(user, JARM_REQUEST, method, location);
            return;
        }
        try {
            InitialContext context = new InitialContext();
            Context kmClientContext = (Context)context.lookup(KM_EAR_NAME);
            IndexSearchLocalHome indexSearchHome = (IndexSearchLocalHome)kmClientContext.lookup(INDEX_SEARCH_BEAN_NAME);
            this.indexSearchSearch = indexSearchHome.create();
            this.indexSearchClassify = indexSearchHome.create();
        }
        catch (NamingException ne) {
            Object[] args = new Object[]{KM_EAR_NAME};
            CAFPublicLogger.categoryCAF.logThrowableT(500, location, method, "Error in JNDI lookup of {0}", args, (Throwable)ne);
            location.throwing(method, (Throwable)ne);
            throw new BEException(ne.getMessage(), null, ne);
        }
        catch (CreateException ne) {
            CAFPublicLogger.traceThrowableT(100, location, method, "Error in " + method, ne);
            location.throwing(method, (Throwable)ne);
            throw new BEException(ne.getMessage(), null, ne);
        }
        finally {
            CAFPublicLogger.exiting(user, JARM_REQUEST, method, location, 1);
        }
    }

    public Collection searchidxForBOInRelatedDoc(String freeText) throws BEException {
        String method = "searchidxForBOInRelatedDoc(String)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering(user, JARM_REQUEST, method, location, new Object[]{freeText}, 1);
        Collection results = null;
        LinkedList<String> finalResults = new LinkedList<String>();
        LinkedList collAttributesAsString = new LinkedList();
        this.initIndexSearchContext();
        try {
            results = this.indexSearchSearch.searchForBOInRelatedDoc(collAttributesAsString, freeText, this._objectName);
        }
        catch (SearchException se) {
            CAFPublicLogger.traceThrowableT(100, location, method, "Error in " + method, se);
            location.throwing(method, (Throwable)se);
            CAFPublicLogger.exiting(user, JARM_REQUEST, method, location, 1);
            throw new BEException(se.getMessage(), null, se);
        }
        Iterator it = results.iterator();
        while (it.hasNext()) {
            finalResults.add(((ISearchResult)it.next()).getBOGuid());
        }
        CAFPublicLogger.exiting(user, JARM_REQUEST, method, location, new Object[]{finalResults}, 1);
        return finalResults;
    }

    public Collection searchidxForSimilar(IBusinessObject object, int maxResults) throws BEException {
        String method = "searchidxForSimilar(IBusinessObject, int)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering(user, JARM_REQUEST, method, location, new Object[]{object, new Integer(maxResults)}, 1);
        Collection results = null;
        LinkedList<String> finalResults = new LinkedList<String>();
        this.initIndexSearchContext();
        try {
            results = this.indexSearchSearch.searchForSimilarCAF(object.getRid(), maxResults);
        }
        catch (SearchException se) {
            CAFPublicLogger.traceThrowableT(100, location, method, "Error in " + method, se);
            location.throwing(method, (Throwable)se);
            CAFPublicLogger.exiting(user, JARM_REQUEST, method, location, 1);
            throw new BEException(se.getMessage(), null, se);
        }
        Iterator it = results.iterator();
        while (it.hasNext()) {
            finalResults.add(((ISearchResult)it.next()).getBOGuid());
        }
        CAFPublicLogger.exiting(user, JARM_REQUEST, method, location, new Object[]{finalResults}, 1);
        return finalResults;
    }

    public Collection getCategories() throws BEException {
        String method = "getCategories()";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering(user, JARM_REQUEST, method, location, null, 1);
        Collection results = null;
        this.initIndexSearchContext();
        try {
            try {
                results = this.indexSearchClassify.getCategories(this.getClass().getName());
            }
            catch (ClassifyException ce) {
                CAFPublicLogger.traceThrowableT(100, location, method, "Error in " + method, ce);
                location.throwing(method, (Throwable)ce);
                throw new BEException(ce.getMessage(), null, ce);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            CAFPublicLogger.exiting(user, JARM_REQUEST, method, location, new Object[]{results}, 1);
            throw throwable;
        }
        CAFPublicLogger.exiting(user, JARM_REQUEST, method, location, new Object[]{results}, 1);
        return results;
    }

    public Collection getClassification(String boPrimaryKey, String categoryGUID) throws BEException {
        String method = "getClassification(String,String)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering(user, JARM_REQUEST, method, location, new Object[]{boPrimaryKey, categoryGUID}, 1);
        Collection results = null;
        this.initIndexSearchContext();
        try {
            try {
                results = this.indexSearchClassify.getClassification(boPrimaryKey, categoryGUID);
            }
            catch (ClassifyException ce) {
                CAFPublicLogger.traceThrowableT(100, location, method, "Error in " + method, ce);
                location.throwing(method, (Throwable)ce);
                throw new BEException(ce.getMessage(), null, ce);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            CAFPublicLogger.exiting(user, JARM_REQUEST, method, location, new Object[]{results}, 1);
            throw throwable;
        }
        CAFPublicLogger.exiting(user, JARM_REQUEST, method, location, new Object[]{results}, 1);
        return results;
    }

    public void addClassification(String boPrimaryKey, String valueGUID, String categoryGUID) throws BEException {
        String method = "addClassification(String, String, String)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering(user, JARM_REQUEST, method, location, new Object[]{boPrimaryKey, valueGUID, categoryGUID}, 1);
        this.initIndexSearchContext();
        try {
            this.indexSearchClassify.addClassification(valueGUID, boPrimaryKey, categoryGUID);
        }
        catch (ClassifyException ce) {
            CAFPublicLogger.traceThrowableT(100, location, method, "Error in " + method, ce);
            location.throwing(method, (Throwable)ce);
            throw new BEException(ce.getMessage(), null, ce);
        }
        finally {
            CAFPublicLogger.exiting(user, JARM_REQUEST, method, location, 1);
        }
    }

    public void removeClassification(String boPrimaryKey, String valueGUID) throws BEException {
        String method = "removeClassification(String, String)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering(user, JARM_REQUEST, method, location, new Object[]{boPrimaryKey, valueGUID}, 1);
        this.initIndexSearchContext();
        try {
            this.indexSearchClassify.removeClassification(valueGUID, boPrimaryKey);
        }
        catch (ClassifyException ce) {
            CAFPublicLogger.traceThrowableT(100, location, method, "Error in " + method, ce);
            location.throwing(method, (Throwable)ce);
            throw new BEException(ce.getMessage(), null, ce);
        }
        finally {
            CAFPublicLogger.exiting(user, JARM_REQUEST, method, location, 1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

