/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.sqlj.wizard;

import com.sap.dictionary.tools.sqlj.SQLJEditorPlugin;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;

public class SQLJCreationWizard
extends NewElementWizard {
    private NewClassWizardPage fPage;

    public SQLJCreationWizard() {
        try {
            URL iconBaseURL = new URL(SQLJEditorPlugin.getDefault().getDescriptor().getInstallURL(), "icons/");
            ImageDescriptor NEWSQLJ = ImageDescriptor.createFromURL((URL)new URL(iconBaseURL, "newsqlj.gif"));
            this.setDefaultPageImageDescriptor(NEWSQLJ);
        }
        catch (MalformedURLException e) {
            SQLJEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.sap.dictionary.tools.sqlj", 4, "get images for wizard", (Throwable)e));
        }
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.setWindowTitle("New SQLJ Source");
    }

    public void addPages() {
        super.addPages();
        this.fPage = new NewClassWizardPage();
        this.fPage.setTitle("SQLJ-Source");
        this.fPage.setDescription("Create a SQLJ-Source");
        this.addPage((IWizardPage)this.fPage);
        this.fPage.init(this.getSelection());
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.fPage.createType(monitor);
        ICompilationUnit cu = JavaModelUtil.toOriginal((ICompilationUnit)this.fPage.getCreatedType().getCompilationUnit());
        if (cu != null) {
            IResource resource = cu.getResource();
            this.selectAndReveal(resource);
            IFile sqljFile = this.createSQLJ(resource);
            this.openResource(sqljFile);
            cu.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private IFile createSQLJ(IResource resource) {
        IFile file = (IFile)resource;
        IPath sqljPath = file.getFullPath().removeFileExtension().addFileExtension("sqlj");
        IFile sqljFile = file.getWorkspace().getRoot().getFile(sqljPath);
        try {
            if (!sqljFile.exists()) {
                file.copy(sqljPath, true, null);
                return sqljFile;
            }
        }
        catch (CoreException e) {
            SQLJEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "sqlj", 4, "create sqlj source", (Throwable)e));
            return null;
        }
        return null;
    }
}

