/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.sqlj.translator;

import com.sap.dictionary.tools.sqlj.SQLJEditorPlugin;
import com.sap.sql.sqlj.framework.TranslationException;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class Translator
extends IncrementalProjectBuilder {
    private static final String TRANSLATOR = "Translator";

    private void translateResource(IResource resource) {
        if (resource.getFileExtension() != null && resource.getFileExtension().equals("sqlj")) {
            try {
                FileEditorInput editorInput = new FileEditorInput((IFile)resource);
                SQLJEditorPlugin.getDefault().getTranslator(resource.getProject()).translate((IEditorInput)editorInput);
            }
            catch (TranslationException translateException) {
                SQLJEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.sap.dictionary.tools.sqlj", 4, "translate resource", (Throwable)translateException));
            }
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(TRANSLATOR, 50);
        monitor.setTaskName(TRANSLATOR);
        switch (kind) {
            case 6: {
                this.fullBild(monitor);
                break;
            }
            case 9: 
            case 10: {
                IResourceDelta lDelta = this.getDelta(this.getProject());
                if (lDelta == null) {
                    this.fullBild(monitor);
                    break;
                }
                this.incrementalBuild(lDelta, monitor);
                break;
            }
        }
        return null;
    }

    protected void fullBild(IProgressMonitor monitor) throws CoreException {
        this.getProject().accept((IResourceVisitor)new ResourceVisitor());
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new ResourceDeltaVisitor());
    }

    protected void startupOnInitialize() {
        super.startupOnInitialize();
    }

    class ResourceVisitor
    implements IResourceVisitor {
        ResourceVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            Translator.this.translateResource(resource);
            return true;
        }
    }

    class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        ResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResourceDelta[] resDelta = delta.getAffectedChildren();
            int i = 0;
            while (i < resDelta.length) {
                Translator.this.translateResource(resDelta[i].getResource());
                ++i;
            }
            return true;
        }
    }
}

