/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.sqlj.translator;

import com.sap.dictionary.tools.generation.eclipse.GenerationEclipse;
import com.sap.dictionary.tools.sqlj.SQLJEditorPlugin;
import com.sap.dictionary.tools.sqlj.SQLJNature;
import com.sap.dictionary.tools.sqlj.translator.SQLJTranslationUnit;
import com.sap.sql.sqlj.framework.TranslationException;
import com.sap.sql.sqlj.framework.ide.Options;
import com.sap.sql.sqlj.framework.ide.TranslationUnit;
import com.sap.sql.sqlj.framework.ide.Translator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.Util;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class SQLJTranslator {
    private Translator translator;
    private Options options;
    private IProject project;

    public SQLJTranslator(IProject project) {
        this.project = project;
    }

    public void translate(IEditorInput editorInput) throws TranslationException {
        if (this.isIgnoredResource(editorInput)) {
            return;
        }
        IProjectNature nature = null;
        try {
            nature = this.project.getNature("com.sap.ide.eclipse.component.provider.dcnature");
        }
        catch (CoreException e1) {
            SQLJEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.sap.dictionary.tools.sqlj", 4, "get dc nature", (Throwable)e1));
        }
        SQLJNature.setCompilerFilter();
        if (nature == null) {
            this.setOptions(editorInput);
        } else {
            this.setOptionsForDC(editorInput);
        }
        this.translator = new Translator(this.options, null, null);
        SQLJTranslationUnit translationUnit = null;
        try {
            translationUnit = new SQLJTranslationUnit(editorInput, false);
            this.translator.addUnit((TranslationUnit)translationUnit);
            this.translator.translate();
            Object var5_5 = null;
            translationUnit.remove();
            translationUnit = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            translationUnit.remove();
            translationUnit = null;
            throw throwable;
        }
    }

    private boolean isIgnoredResource(IEditorInput editorInput) {
        FileEditorInput fileInp = (FileEditorInput)editorInput;
        IFile sqljFile = fileInp.getFile();
        IProject proj = sqljFile.getProject();
        IJavaProject jProj = JavaCore.create((IProject)proj);
        try {
            IClasspathEntry[] classPathEntries = jProj.getResolvedClasspath(false);
            int i = 0;
            while (i < classPathEntries.length) {
                char[][] exclusionChars;
                int entryKind = classPathEntries[i].getEntryKind();
                if (entryKind == 3 && sqljFile.getFullPath().toOSString().startsWith(classPathEntries[i].getPath().toOSString()) && Util.isExcluded((IResource)sqljFile, (char[][])(exclusionChars = ((ClasspathEntry)classPathEntries[i]).fullExclusionPatternChars()))) {
                    sqljFile.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
                    return true;
                }
                ++i;
            }
        }
        catch (Exception e) {
            SQLJEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "sqlj", 4, "check ignored resources", (Throwable)e));
        }
        return false;
    }

    private void setOptions(IEditorInput editorInput) {
        String classPath = new String();
        String sourcePath = new String();
        String catalogReaderPath = new String("xml/file/");
        try {
            FileEditorInput fileInp = (FileEditorInput)editorInput;
            IFile sqljFile = fileInp.getFile();
            IProject proj = sqljFile.getProject();
            IJavaProject jProj = JavaCore.create((IProject)proj);
            IClasspathEntry[] classPathEntries = jProj.getResolvedClasspath(false);
            boolean classPathChanged = false;
            boolean sourcePathChanged = false;
            boolean catalogReaderPathChanged = false;
            int i = 0;
            while (i < classPathEntries.length) {
                int entryKind = classPathEntries[i].getEntryKind();
                if (entryKind == 3) {
                    if (sourcePathChanged) {
                        sourcePath = sourcePath.concat(";");
                    }
                    String projLocation = proj.getLocation().toString();
                    String sourcePathString = classPathEntries[i].getPath().removeFirstSegments(1).toString();
                    if (sourcePathString != "") {
                        sourcePathString = '/' + sourcePathString;
                    }
                    sourcePath = sourcePath.concat(projLocation).concat(sourcePathString);
                    sourcePathChanged = true;
                } else if (entryKind == 2) {
                    String projectPathString = classPathEntries[i].getPath().toString().substring(1);
                    IProject refProj = ResourcesPlugin.getWorkspace().getRoot().getProject(projectPathString);
                    if (refProj.exists()) {
                        IJavaProject refJproj = JavaCore.create((IProject)refProj);
                        if (classPathChanged) {
                            classPath = classPath.concat(";");
                        }
                        classPath = classPath.concat(refProj.getLocation().removeLastSegments(1).toOSString());
                        classPath = classPath.concat(refJproj.getOutputLocation().toOSString());
                        classPathChanged = true;
                        IProjectNature nature = null;
                        try {
                            nature = refProj.getNature("com.sap.dictionary.tools.archivebuilder.DictionaryNature");
                        }
                        catch (CoreException e1) {
                            SQLJEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "sqlj", 4, "get ddic nature", (Throwable)e1));
                        }
                        if (nature != null) {
                            if (catalogReaderPathChanged) {
                                catalogReaderPath = catalogReaderPath.concat(";");
                            }
                            IPath dictionaryGenSrcPathDbTables = refProj.getProject().getLocation().append(GenerationEclipse.getGenerationOutputPathInfix() + "/" + "dbtables");
                            catalogReaderPath = catalogReaderPath.concat(dictionaryGenSrcPathDbTables.toOSString());
                            catalogReaderPathChanged = true;
                        }
                    }
                } else {
                    if (classPathChanged) {
                        classPath = classPath.concat(";");
                    }
                    String classPathString = classPathEntries[i].getPath().toString();
                    classPath = classPath.concat(classPathString);
                    classPathChanged = true;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            SQLJEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "sqlj", 4, "set options for translator", (Throwable)e));
        }
        this.options = new Options();
        this.options.setCatalogReader(catalogReaderPath, null);
        this.options.setClasspath(classPath);
        this.options.setSource(sourcePath);
    }

    private void setOptionsForDC(IEditorInput editorInput) {
        String classPath = new String();
        String sourcePath = new String();
        String catalogReaderPath = new String("xml/file/");
        try {
            FileEditorInput fileInp = (FileEditorInput)editorInput;
            IFile sqljFile = fileInp.getFile();
            IProject proj = sqljFile.getProject();
            IJavaProject jProj = JavaCore.create((IProject)proj);
            IClasspathEntry[] classPathEntries = jProj.getResolvedClasspath(false);
            boolean classPathChanged = false;
            boolean sourcePathChanged = false;
            boolean catalogReaderPathChanged = false;
            int i = 0;
            while (i < classPathEntries.length) {
                String classPathString;
                int entryKind = classPathEntries[i].getEntryKind();
                if (entryKind == 3) {
                    if (sourcePathChanged) {
                        sourcePath = sourcePath.concat(";");
                    }
                    String projLocation = proj.getLocation().toString();
                    String sourcePathString = classPathEntries[i].getPath().removeFirstSegments(1).toString();
                    if (sourcePathString != "") {
                        sourcePathString = '/' + sourcePathString;
                    }
                    sourcePath = sourcePath.concat(projLocation).concat(sourcePathString);
                    sourcePathChanged = true;
                } else if (entryKind == 2) {
                    if (classPathChanged) {
                        classPath = classPath.concat(";");
                    }
                    classPathString = classPathEntries[i].getPath().toString();
                    classPath = classPath.concat(classPathString);
                    classPathChanged = true;
                    if (catalogReaderPathChanged) {
                        catalogReaderPath = catalogReaderPath.concat(";");
                    }
                    classPathString = classPathString.substring(1, classPathString.length());
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(classPathString);
                    IPath dictionaryGenSrcPathDbTables = project.getProject().getLocation().append(GenerationEclipse.getGenerationOutputPathInfix() + "/" + "dbtables");
                    catalogReaderPath = catalogReaderPath.concat(dictionaryGenSrcPathDbTables.toOSString());
                    catalogReaderPathChanged = true;
                } else if (entryKind == 1) {
                    if (catalogReaderPathChanged) {
                        catalogReaderPath = catalogReaderPath.concat(";");
                    }
                    classPathString = classPathEntries[i].getPath().toString();
                    catalogReaderPath = catalogReaderPath.concat(classPathString);
                    catalogReaderPathChanged = true;
                    if (classPathChanged) {
                        classPath = classPath.concat(";");
                    }
                    classPath = classPath.concat(classPathString);
                    classPathChanged = true;
                } else {
                    if (classPathChanged) {
                        classPath = classPath.concat(";");
                    }
                    classPathString = classPathEntries[i].getPath().toString();
                    classPath = classPath.concat(classPathString);
                    classPathChanged = true;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            SQLJEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "sqlj", 4, "set options for dc", (Throwable)e));
        }
        this.options = new Options();
        this.options.setCatalogReader(catalogReaderPath, null);
        this.options.setClasspath(classPath);
        this.options.setSource(sourcePath);
    }
}

