/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.sqlj.translator;

import com.sap.dictionary.tools.sqlj.translator.SQLJResourceHandlingHelper;
import com.sap.dictionary.tools.sqlj.translator.SQLJTranslationInput;
import com.sap.dictionary.tools.sqlj.translator.SQLJTranslationLog;
import com.sap.dictionary.tools.sqlj.translator.SQLJTranslationOutput;
import com.sap.sql.sqlj.framework.ClassResolver;
import com.sap.sql.sqlj.framework.ide.TranslationInput;
import com.sap.sql.sqlj.framework.ide.TranslationLog;
import com.sap.sql.sqlj.framework.ide.TranslationOutput;
import com.sap.sql.sqlj.framework.ide.TranslationUnit;
import com.sap.sql.sqlj.translator.ClassResolverImpl;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class SQLJTranslationUnit
implements TranslationUnit {
    private IFile file;
    private SQLJTranslationLog log;
    private FileEditorInput editorInput;
    private SQLJTranslationOutput sqljTranslationOutput;
    private SQLJTranslationInput sqljTranslationInput;
    private String packageName;
    private boolean suppressFileGeneration;

    public SQLJTranslationUnit(IEditorInput editorInput, boolean suppressFileGeneration) {
        this.editorInput = (FileEditorInput)editorInput;
        this.suppressFileGeneration = suppressFileGeneration;
    }

    public IEditorInput getEditorInput() {
        return this.editorInput;
    }

    public TranslationInput getInput() throws IOException {
        this.sqljTranslationInput = new SQLJTranslationInput(this);
        return this.sqljTranslationInput;
    }

    public TranslationOutput getOutput() throws IOException {
        this.sqljTranslationOutput = new SQLJTranslationOutput(this, this.suppressFileGeneration);
        return this.sqljTranslationOutput;
    }

    public TranslationLog getErrorLog() {
        if (this.log == null) {
            this.log = new SQLJTranslationLog(this);
        }
        return this.log;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String parm1) {
        this.packageName = parm1;
    }

    public IFile getJavaFile() {
        IPath sqljPath = this.editorInput.getFile().getFullPath();
        IPath javaPath = SQLJResourceHandlingHelper.getJavaFilePath(this.editorInput.getFile().getProject(), sqljPath);
        IFile javaFile = ResourcesPlugin.getWorkspace().getRoot().getFile(javaPath);
        return javaFile;
    }

    public void translationComplete(boolean parm1) throws IOException {
        if (parm1) {
            this.sqljTranslationOutput.saveSource();
            this.sqljTranslationOutput.saveProfile();
        }
        this.log.addResourceMarkers();
    }

    public ClassResolver getClassResolver() {
        return new ClassResolverImpl();
    }

    public File getInFile() {
        return null;
    }

    public File getOutFile() {
        return null;
    }

    public void remove() {
        this.log = null;
        this.sqljTranslationOutput = null;
        if (this.sqljTranslationInput != null) {
            this.sqljTranslationInput.closeReader();
            this.sqljTranslationInput = null;
        }
    }
}

