/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.sqlj.translator;

import com.sap.dictionary.tools.sqlj.SQLJEditorPlugin;
import com.sap.dictionary.tools.sqlj.translator.SQLJTranslationUnit;
import com.sap.sql.sqlj.framework.ide.TranslationOutput;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.part.FileEditorInput;

public class SQLJTranslationOutput
implements TranslationOutput {
    private SQLJTranslationUnit unit;
    private StringWriter sourceCodeWriter;
    private ByteArrayOutputStream serFileStream;
    private String serFileName;
    private boolean suppressFileGeneration;

    public SQLJTranslationOutput(SQLJTranslationUnit unit, boolean suppressFileGeneration) {
        this.unit = unit;
        this.sourceCodeWriter = new StringWriter();
        this.suppressFileGeneration = suppressFileGeneration;
    }

    public Writer getWriter() {
        return this.sourceCodeWriter;
    }

    public Writer createWriter(String parm1) throws IOException {
        return null;
    }

    public OutputStream createOutputStream(String parm1) throws IOException {
        this.serFileName = parm1;
        this.serFileStream = new ByteArrayOutputStream();
        return this.serFileStream;
    }

    void saveSource() {
        if (!this.suppressFileGeneration) {
            try {
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        IFile file = SQLJTranslationOutput.this.unit.getJavaFile();
                        String sc = SQLJTranslationOutput.this.sourceCodeWriter.toString();
                        byte[] bytes = sc.getBytes();
                        ByteArrayInputStream istream = new ByteArrayInputStream(bytes);
                        if (file.exists()) {
                            file.setContents((InputStream)istream, true, false, null);
                            file.setDerived(true);
                        } else {
                            String folderPath = file.getFullPath().segment(0);
                            int segment = 1;
                            while (segment < file.getFullPath().segmentCount() - 1) {
                                folderPath = folderPath.concat("/");
                                folderPath = folderPath.concat(file.getFullPath().segment(segment));
                                Path path = new Path(folderPath);
                                IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(folderPath));
                                if (!folder.exists()) {
                                    folder.create(false, false, null);
                                    if (segment == 1) {
                                        IClasspathEntry entry;
                                        IJavaProject jProject = JavaCore.create((IProject)file.getProject());
                                        IClasspathEntry[] classPathEntries = jProject.getRawClasspath();
                                        IClasspathEntry[] newClassPathEntries = new IClasspathEntry[classPathEntries.length + 1];
                                        System.arraycopy(classPathEntries, 0, newClassPathEntries, 0, classPathEntries.length);
                                        newClassPathEntries[newClassPathEntries.length - 1] = entry = JavaCore.newSourceEntry((IPath)path.makeAbsolute());
                                        jProject.setRawClasspath(newClassPathEntries, jProject.getOutputLocation(), null);
                                    }
                                }
                                ++segment;
                            }
                            file.create((InputStream)istream, false, null);
                            file.setDerived(true);
                        }
                        try {
                            ((InputStream)istream).close();
                        }
                        catch (IOException e) {
                            SQLJEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.sap.dictionary.tools.sqlj", 4, "close stream", (Throwable)e));
                        }
                        istream = null;
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception ex) {
                SQLJEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "sqlj", 4, "save source", (Throwable)ex));
            }
        }
    }

    void saveProfile() throws IOException {
        this.suppressFileGeneration = false;
        if (false && this.serFileStream != null) {
            byte[] bytes = this.serFileStream.toByteArray();
            this.serFileStream.close();
            this.serFileStream = null;
            ByteArrayInputStream istream = new ByteArrayInputStream(bytes);
            try {
                FileEditorInput sqljEditorInput = (FileEditorInput)this.unit.getEditorInput();
                IFile sqljFile = sqljEditorInput.getFile();
                IWorkspace workspace = sqljFile.getWorkspace();
                String path = sqljFile.getFullPath().toString();
                String javaFileName = path.substring(0, path.length() - sqljFile.getName().length()) + this.serFileName;
                IFile file = workspace.getRoot().getFile((IPath)new Path(javaFileName));
                if (file.exists()) {
                    file.setContents((InputStream)istream, true, false, null);
                } else {
                    file.create((InputStream)istream, false, null);
                }
            }
            catch (CoreException e) {
                SQLJEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "sqlj", 4, "save profile", (Throwable)e));
            }
        }
    }
}

