/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.sqlj.translator;

import com.sap.dictionary.tools.sqlj.SQLJEditorPlugin;
import com.sap.dictionary.tools.sqlj.translator.SQLJTranslationMessage;
import com.sap.dictionary.tools.sqlj.translator.SQLJTranslationUnit;
import com.sap.sql.sqlj.framework.ide.TranslationLog;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class SQLJTranslationLog
implements TranslationLog {
    private SQLJTranslationUnit unit;
    private ArrayList log;
    private static final String SQLJ_MESSAGE = "SQLJ: ";

    public SQLJTranslationLog(SQLJTranslationUnit unit) {
        this.unit = unit;
        this.log = new ArrayList();
    }

    public void logError(String parm1, int parm2, int parm3, int parm4, int parm5) {
        SQLJTranslationMessage msg = new SQLJTranslationMessage(0, parm1, parm2, parm3, parm4, parm5);
        this.log.add(msg);
    }

    public void logWarning(String parm1, int parm2, int parm3, int parm4, int parm5) {
        SQLJTranslationMessage msg = new SQLJTranslationMessage(1, parm1, parm2, parm3, parm4, parm5);
        this.log.add(msg);
    }

    public void logInfo(String parm1, int parm2, int parm3, int parm4, int parm5) {
        SQLJTranslationMessage msg = new SQLJTranslationMessage(2, parm1, parm2, parm3, parm4, parm5);
        this.log.add(msg);
    }

    public void addResourceMarkers() {
        try {
            IFile file = ((FileEditorInput)this.unit.getEditorInput()).getFile();
            file.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
            Iterator iter = ((AbstractList)this.log).iterator();
            while (iter.hasNext()) {
                SQLJTranslationMessage msg = (SQLJTranslationMessage)iter.next();
                HashMap<String, Integer> markerAttributes = new HashMap<String, Integer>();
                MarkerUtilities.setMessage(markerAttributes, (String)(SQLJ_MESSAGE + msg.getMessage()));
                MarkerUtilities.setLineNumber(markerAttributes, (int)msg.getBeginLine());
                switch (msg.getMessageType()) {
                    case 0: {
                        markerAttributes.put("severity", new Integer(2));
                        break;
                    }
                    case 1: {
                        markerAttributes.put("severity", new Integer(1));
                        break;
                    }
                    case 2: {
                        markerAttributes.put("severity", new Integer(0));
                    }
                }
                MarkerUtilities.createMarker((IResource)file, markerAttributes, (String)"org.eclipse.core.resources.problemmarker");
            }
        }
        catch (CoreException exc) {
            SQLJEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.sap.dictionary.tools.sqlj", 4, "add resource markers", (Throwable)exc));
        }
    }
}

