/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.sqlj.translator;

import com.sap.dictionary.tools.sqlj.SQLJEditorPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class SQLJResourceHandlingHelper {
    public static final String FILE_EXTENSION_SQLJ = "sqlj";
    public static final String FILE_EXTENSION_JAVA = "java";
    public static final String FILE_EXTENSION_CLASS = "class";
    public static final String GEN_FOLDER = "gen_sqlj";

    public static IPath getJavaFilePath(IProject project, IPath path) {
        if (!project.exists()) {
            return null;
        }
        IJavaProject jProject = JavaCore.create((IProject)project);
        IPath srcFolderPath = null;
        try {
            IClasspathEntry[] classPathEntries = jProject.getRawClasspath();
            int i = 0;
            while (i < classPathEntries.length) {
                if (classPathEntries[i].getEntryKind() == 3 && path.uptoSegment((srcFolderPath = classPathEntries[i].getPath()).segmentCount()).equals((Object)srcFolderPath)) {
                    Path javaPath = new Path(path.segment(0));
                    IPath sqljPath = null;
                    sqljPath = path.removeFirstSegments(srcFolderPath.segmentCount());
                    if (!srcFolderPath.equals((Object)project.getFullPath())) {
                        javaPath = javaPath.append((IPath)new Path(GEN_FOLDER));
                    }
                    javaPath = javaPath.append(sqljPath);
                    javaPath = javaPath.removeFileExtension();
                    javaPath = javaPath.addFileExtension(FILE_EXTENSION_JAVA);
                    return javaPath;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            SQLJEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.sap.dictionary.tools.sqlj", 4, "get java file path", (Throwable)e));
        }
        return null;
    }

    public static IFile getJavaFile(IFile sqljFile) {
        IPath javaPath = SQLJResourceHandlingHelper.getJavaFilePath(sqljFile.getProject(), sqljFile.getFullPath());
        if (javaPath == null) {
            return null;
        }
        IFile file = sqljFile.getWorkspace().getRoot().getFile(javaPath);
        return file;
    }

    public static IPath getSQLJFilePath(IProject project, IPath path) {
        IJavaProject jProject = JavaCore.create((IProject)project);
        IPath srcFolderPath = null;
        try {
            IClasspathEntry[] classPathEntries = jProject.getRawClasspath();
            int i = 0;
            while (i < classPathEntries.length) {
                if (classPathEntries[i].getEntryKind() == 3 && path.matchingFirstSegments(srcFolderPath = classPathEntries[i].getPath()) != srcFolderPath.segmentCount()) {
                    IPath sqljPath = srcFolderPath;
                    IPath javaPath = null;
                    javaPath = path.removeFirstSegments(srcFolderPath.segmentCount());
                    sqljPath = sqljPath.append(javaPath);
                    sqljPath = sqljPath.removeFileExtension();
                    sqljPath = sqljPath.addFileExtension(FILE_EXTENSION_SQLJ);
                    return sqljPath;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            SQLJEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.sap.dictionary.tools.sqlj", 4, "get sqlj file path", (Throwable)e));
        }
        return null;
    }

    public static IFile getSQLJFile(IFile javaFile) {
        IPath sqljPath = SQLJResourceHandlingHelper.getSQLJFilePath(javaFile.getProject(), javaFile.getFullPath());
        if (sqljPath != null) {
            IFile file = javaFile.getWorkspace().getRoot().getFile(sqljPath);
            return file;
        }
        return null;
    }

    public static String getClassFileLocation(IFile file) {
        String path = file.getFullPath().toString();
        IWorkspace workspace = file.getWorkspace();
        String classFileName = file.getName().substring(0, file.getName().length() - 4) + FILE_EXTENSION_CLASS;
        Path classFilePath = null;
        try {
            if (file.exists()) {
                ICompilationUnit compUnit = (ICompilationUnit)JavaCore.create((IFile)file);
                String packname = null;
                IPackageDeclaration[] decls = compUnit.getPackageDeclarations();
                if (decls.length != 0) {
                    packname = decls[0].getElementName();
                    packname = packname.replace('.', '/');
                }
                IProject proj = file.getProject();
                IJavaProject jProj = JavaCore.create((IProject)proj);
                String outputLocation = jProj.getOutputLocation().toString();
                classFilePath = packname == null ? new Path(outputLocation + '/' + classFileName) : new Path(outputLocation + "/" + packname + '/' + classFileName);
                IFile classFile = workspace.getRoot().getFile((IPath)classFilePath);
                return classFile.getLocation().toString();
            }
            return null;
        }
        catch (JavaModelException e) {
            SQLJEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, FILE_EXTENSION_SQLJ, 4, "get class file location", (Throwable)e));
            return null;
        }
    }
}

