/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.sqlj.translator;

import com.sap.dictionary.tools.sqlj.SQLJEditorPlugin;
import com.sap.dictionary.tools.sqlj.translator.SQLJResourceHandlingHelper;
import com.sap.sql.sqlj.tools.ClassMapper;
import com.sap.sql.sqlj.tools.SourceMapper;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class DebugInformationEnhancer
extends IncrementalProjectBuilder {
    private static final String DEBUG_ENHANCEMENT = "DebugInformationEnhancer";

    private void enhance(IResource resource) {
        if (resource.getFileExtension() != null && resource.getFileExtension().equals("sqlj")) {
            try {
                IPath javaPath = SQLJResourceHandlingHelper.getJavaFilePath(resource.getProject(), resource.getFullPath());
                if (javaPath == null) {
                    return;
                }
                IFile javaFile = ResourcesPlugin.getWorkspace().getRoot().getFile(javaPath);
                String javaFileLocation = javaFile.getLocation().toOSString();
                String classFileLocation = SQLJResourceHandlingHelper.getClassFileLocation(javaFile);
                if (classFileLocation == null) {
                    return;
                }
                if (!new File(classFileLocation).exists()) {
                    return;
                }
                System.out.println("JavaFilePath  = " + javaFileLocation);
                System.out.println("ClassFilePath = " + classFileLocation);
                int status = ClassMapper.mainStatus((String)classFileLocation, (String)javaFileLocation);
                resource.deleteMarkers("org.eclipse.jdt.core.problem", false, 0);
                IMarker[] markers = javaFile.findMarkers("org.eclipse.jdt.core.problem", false, 0);
                SourceMapper mapper = new SourceMapper(javaFileLocation);
                int i = 0;
                while (i < markers.length) {
                    Map javaMarkerAttributes = markers[i].getAttributes();
                    Integer javaLineNumber = (Integer)javaMarkerAttributes.get("lineNumber");
                    Integer severity = (Integer)javaMarkerAttributes.get("severity");
                    mapper.tgtLineToSrc(javaLineNumber.intValue(), 1);
                    int sqljLineNumber = mapper.startLine();
                    HashMap<String, Integer> sqljMarkerAttributes = new HashMap<String, Integer>();
                    MarkerUtilities.setMessage(sqljMarkerAttributes, (String)((String)javaMarkerAttributes.get("message")));
                    MarkerUtilities.setLineNumber(sqljMarkerAttributes, (int)sqljLineNumber);
                    sqljMarkerAttributes.put("severity", severity);
                    MarkerUtilities.createMarker((IResource)resource, sqljMarkerAttributes, (String)"org.eclipse.jdt.core.problem");
                    ++i;
                }
                javaFile.deleteMarkers("org.eclipse.jdt.core.problem", false, 0);
            }
            catch (Exception translateException) {
                SQLJEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.sap.dictionary.tools.sqlj", 4, "enhance", (Throwable)translateException));
            }
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(DEBUG_ENHANCEMENT, 50);
        monitor.setTaskName(DEBUG_ENHANCEMENT);
        switch (kind) {
            case 6: {
                this.fullBild(monitor);
                break;
            }
            case 9: 
            case 10: {
                IResourceDelta lDelta = this.getDelta(this.getProject());
                if (lDelta == null) {
                    this.fullBild(monitor);
                    break;
                }
                this.incrementalBuild(lDelta, monitor);
                break;
            }
        }
        return null;
    }

    protected void fullBild(IProgressMonitor monitor) throws CoreException {
        this.getProject().accept((IResourceVisitor)new ResourceVisitor());
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new ResourceDeltaVisitor());
    }

    protected void startupOnInitialize() {
        super.startupOnInitialize();
    }

    class ResourceVisitor
    implements IResourceVisitor {
        ResourceVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            DebugInformationEnhancer.this.enhance(resource);
            return true;
        }
    }

    class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        ResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResourceDelta[] resDelta = delta.getAffectedChildren();
            int i = 0;
            while (i < resDelta.length) {
                DebugInformationEnhancer.this.enhance(resDelta[i].getResource());
                ++i;
            }
            return true;
        }
    }
}

