/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.sqlj.jardesc;

import com.sap.dictionary.tools.sqlj.jardesc.JarFileExportOperation;
import com.sap.dictionary.tools.sqlj.jardesc.JarPackageActionDelegate;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.ProblemDialog;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.jarpackager.IJarDescriptionReader;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Shell;

public class CreateJarActionDelegate
extends JarPackageActionDelegate {
    public void run(IAction action) {
        MultiStatus mergedStatus;
        IFile[] descriptions = this.getDescriptionFiles(this.getSelection());
        int length = descriptions.length;
        if (length < 1) {
            return;
        }
        String message = length > 1 ? JarPackagerMessages.getString((String)"JarFileExportOperation.creationOfSomeJARsFailed") : JarPackagerMessages.getString((String)"JarFileExportOperation.jarCreationFailed");
        MultiStatus readStatus = new MultiStatus(JavaPlugin.getPluginId(), 0, message, null);
        JarPackageData[] jarPackages = this.readJarPackages(descriptions, readStatus);
        if (jarPackages.length > 0) {
            IStatus status = this.export(jarPackages);
            if (status == null) {
                return;
            }
            message = readStatus.getSeverity() == 4 ? readStatus.getMessage() : status.getMessage();
            mergedStatus = new MultiStatus(JavaPlugin.getPluginId(), status.getCode(), readStatus.getChildren(), message, null);
            mergedStatus.merge(status);
        } else {
            mergedStatus = readStatus;
        }
        if (!mergedStatus.isOK()) {
            ProblemDialog.open((Shell)this.getShell(), (String)JarPackagerMessages.getString((String)"CreateJarActionDelegate.jarExport.title"), null, (IStatus)mergedStatus);
        }
    }

    private JarPackageData[] readJarPackages(IFile[] descriptions, MultiStatus readStatus) {
        ArrayList<JarPackageData> jarPackagesList = new ArrayList<JarPackageData>(descriptions.length);
        int i = 0;
        while (i < descriptions.length) {
            JarPackageData jarPackage = this.readJarPackage(descriptions[i], readStatus);
            if (jarPackage != null) {
                jarPackagesList.add(jarPackage);
            }
            ++i;
        }
        return jarPackagesList.toArray(new JarPackageData[jarPackagesList.size()]);
    }

    private IStatus export(JarPackageData[] jarPackages) {
        Shell shell = this.getShell();
        JarFileExportOperation op = new JarFileExportOperation(jarPackages, shell);
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
            dialog.run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() != null) {
                ExceptionHandler.handle((InvocationTargetException)ex, (Shell)shell, (String)JarPackagerMessages.getString((String)"CreateJarActionDelegate.jarExportError.title"), (String)JarPackagerMessages.getString((String)"CreateJarActionDelegate.jarExportError.message"));
                return null;
            }
        }
        catch (InterruptedException e) {
            return null;
        }
        return op.getStatus();
    }

    /*
     * Loose catch block
     */
    protected JarPackageData readJarPackage(IFile description, MultiStatus readStatus) {
        JarPackageData jarPackage;
        block14: {
            IJarDescriptionReader reader;
            block13: {
                Assert.isLegal((boolean)description.isAccessible());
                Assert.isNotNull((Object)description.getFileExtension());
                Assert.isLegal((boolean)description.getFileExtension().equals("jardesc"));
                jarPackage = new JarPackageData();
                reader = null;
                reader = jarPackage.createJarDescriptionReader(description.getContents());
                reader.read(jarPackage);
                jarPackage.setSaveManifest(false);
                jarPackage.setSaveDescription(false);
                Object var9_5 = null;
                if (reader == null) break block13;
                readStatus.addAll(reader.getStatus());
            }
            try {
                if (reader != null) {
                    reader.close();
                }
                break block14;
            }
            catch (CoreException ex2) {
                String message2 = JarPackagerMessages.getFormattedString((String)"JarFileExportOperation.errorClosingJarPackageDescriptionReader", (Object)description.getFullPath());
                this.addToStatus(readStatus, jarPackage, message2, ex2);
            }
            break block14;
            {
                catch (CoreException ex) {
                    String message = JarPackagerMessages.getFormattedString((String)"JarFileExportOperation.errorReadingFile", (Object)description.getFullPath(), (Object)ex.getStatus().getMessage());
                    this.addToStatus(readStatus, jarPackage, message, ex);
                    JarPackageData jarPackageData = null;
                    Object var9_6 = null;
                    if (reader != null) {
                        readStatus.addAll(reader.getStatus());
                    }
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (CoreException ex2) {
                        String message2 = JarPackagerMessages.getFormattedString((String)"JarFileExportOperation.errorClosingJarPackageDescriptionReader", (Object)description.getFullPath());
                        this.addToStatus(readStatus, jarPackage, message2, ex2);
                    }
                    return jarPackageData;
                }
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                if (reader != null) {
                    readStatus.addAll(reader.getStatus());
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (CoreException ex2) {
                    String message2 = JarPackagerMessages.getFormattedString((String)"JarFileExportOperation.errorClosingJarPackageDescriptionReader", (Object)description.getFullPath());
                    this.addToStatus(readStatus, jarPackage, message2, ex2);
                }
                throw throwable;
            }
        }
        return jarPackage;
    }

    protected void addToStatus(MultiStatus multiStatus, JarPackageData jarPackage, String defaultMessage, CoreException ex) {
        IStatus status = ex.getStatus();
        String message = ex.getLocalizedMessage();
        if (message == null || message.length() < 1) {
            status = new Status(status.getSeverity(), status.getPlugin(), status.getCode(), defaultMessage, (Throwable)ex);
        }
        multiStatus.add(status);
    }
}

