/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.sqlj.editor;

import com.sap.dictionary.tools.sqlj.editor.IKeywordDetector;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.Assert;

public class SQLWordRule
implements IRule {
    protected static final int UNDEFINED = -1;
    protected IWordDetector fDetector;
    protected IKeywordDetector fKeywordDetector;
    protected IToken fDefaultToken;
    protected IToken fKeywordToken;
    protected int fColumn = -1;
    private StringBuffer fBuffer = new StringBuffer();

    public SQLWordRule(IWordDetector detector, IKeywordDetector keywordDetector, IToken defaultToken, IToken keywordToken) {
        Assert.isNotNull((Object)detector);
        Assert.isNotNull((Object)defaultToken);
        Assert.isNotNull((Object)keywordToken);
        this.fDetector = detector;
        this.fKeywordDetector = keywordDetector;
        this.fDefaultToken = defaultToken;
        this.fKeywordToken = keywordToken;
    }

    public void setColumnConstraint(int column) {
        if (column < 0) {
            column = -1;
        }
        this.fColumn = column;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        if (this.fDetector.isWordStart((char)c) && (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1)) {
            this.fBuffer.setLength(0);
            do {
                this.fBuffer.append((char)c);
            } while ((c = scanner.read()) != -1 && this.fDetector.isWordPart((char)c));
            scanner.unread();
            String tokenText = this.fBuffer.toString();
            if (this.fKeywordDetector.isKeyword(tokenText)) {
                return this.fKeywordToken;
            }
            if (this.fDefaultToken.isUndefined()) {
                this.unreadBuffer(scanner);
            }
            return this.fDefaultToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    protected void unreadBuffer(ICharacterScanner scanner) {
        int i = this.fBuffer.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }
}

