/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.sqlj.editor;

import com.sap.dictionary.tools.sqlj.translator.SQLJResourceHandlingHelper;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.ui.javaeditor.JavaMarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class SQLJResourceMarkerAnnotationModel
extends ResourceMarkerAnnotationModel {
    private IResource javaResource;

    public SQLJResourceMarkerAnnotationModel(IResource resource) {
        super(resource);
        IPath javaPath = SQLJResourceHandlingHelper.getJavaFilePath(resource.getProject(), resource.getFullPath());
        IWorkspace workspace = resource.getWorkspace();
        this.javaResource = workspace.getRoot().getFile(javaPath);
    }

    protected boolean isAcceptable(IMarker marker) {
        return true;
    }

    protected IMarker[] retrieveMarkers() throws CoreException {
        IMarker[] sqljMarkers = super.retrieveMarkers();
        IMarker[] javaMarkers = this.javaResource.findMarkers("org.eclipse.jdt.debug.javaLineBreakpointMarker", true, 0);
        IMarker[] markers = new IMarker[sqljMarkers.length + javaMarkers.length];
        System.arraycopy(sqljMarkers, 0, markers, 0, sqljMarkers.length);
        System.arraycopy(javaMarkers, 0, markers, sqljMarkers.length, javaMarkers.length);
        return markers;
    }

    protected MarkerAnnotation createMarkerAnnotation(IMarker marker) {
        return new JavaMarkerAnnotation(marker);
    }

    public void update() throws CoreException {
        this.removeAllAnnotations(false);
        IMarker[] markers = this.retrieveMarkers();
        if (markers != null) {
            int i = 0;
            while (i < markers.length) {
                this.addMarkerAnnotation(markers[i]);
                ++i;
            }
        }
        this.fireModelChanged();
    }
}

