/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.sqlj.editor;

import com.sap.dictionary.tools.sqlj.SQLJEditorPlugin;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.ui.text.BufferedDocumentScanner;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class SQLJPartitionScanner
implements IPartitionTokenScanner {
    private static final String SKIP = "__skip";
    public static final String JAVA_STRING = "__java_string";
    public static final String JAVA_SINGLE_LINE_COMMENT = "__java_singleline_comment";
    public static final String JAVA_MULTI_LINE_COMMENT = "__java_multiline_comment";
    public static final String JAVA_DOC = "__java_javadoc";
    public static final String SQLJ_TXT = "__sqlj";
    public static final String SQL_TXT = "__sql";
    public static final String SQL_SLC = "__sql_single_line_comment";
    public static final String SQL_MLC = "__sql_multi_line_comment";
    public static final String SQL_STRING = "__sql_string";
    public static final String SQL_DELIMITED_ID = "__sql_delimited_identifier";
    public static final String SQL_PC = "__sql_pseudo_comment";
    private static final int JAVA = 0;
    private static final int SINGLE_LINE_COMMENT = 1;
    private static final int MULTI_LINE_COMMENT = 2;
    private static final int JAVADOC = 3;
    private static final int CHARACTER = 4;
    private static final int STRING = 5;
    private static final int SQLJ = 6;
    private static final int SQL = 7;
    private static final int SQL_SINGLE_LINE_COMMENT = 8;
    private static final int SQL_MULTI_LINE_COMMENT = 9;
    private static final int SQL_STRING_LITERAL = 10;
    private static final int SQL_DELIMITED_IDENTIFIER = 11;
    private static final int SQL_PSEUDO_COMMENT = 12;
    private static final int NONE = 0;
    private static final int BACKSLASH = 1;
    private static final int SLASH = 2;
    private static final int SLASH_STAR = 3;
    private static final int SLASH_STAR_STAR = 4;
    private static final int STAR = 5;
    private static final int CARRIAGE_RETURN = 6;
    private static final int HASH = 7;
    private static final int HASH_S = 8;
    private static final int HASH_S_Q = 9;
    private static final int HASH_S_Q_L = 10;
    private static final int DASH = 11;
    private static final int DASH_DASH = 12;
    private static final int SLASH_STAR_AT = 13;
    private static final int DOUBLEQUOTE = 14;
    private static final int COLON = 15;
    private static final int COLON_BRACE = 16;
    private final BufferedDocumentScanner fScanner = new BufferedDocumentScanner(1000);
    private int fTokenOffset;
    private int fTokenLength;
    private int fState;
    private int fLast;
    private int fPrefixLength;
    private int enclosingState = 0;
    private int braceCount = 0;
    private int bracketCount = 0;
    private boolean wasColon = false;
    private final IToken[] fTokens = new IToken[]{new Token(null), new Token((Object)"__java_singleline_comment"), new Token((Object)"__java_multiline_comment"), new Token((Object)"__java_javadoc"), new Token((Object)"__skip"), new Token((Object)"__java_string"), new Token((Object)"__sqlj"), new Token((Object)"__sql"), new Token((Object)"__sql_single_line_comment"), new Token((Object)"__sql_multi_line_comment"), new Token((Object)"__sql_string"), new Token((Object)"__sql_delimited_identifier"), new Token((Object)"__sql_pseudo_comment"), new Token((Object)"__sql")};
    private static String[] colors = new String[]{"000000", "008040", "00FF80", "3f3fFF", "0000FF", "4040FF", "FF00FF", "FF0000", "007700", "000077", "007777", "777700", "770077", "FF7700", "77FF00", "FF0077"};

    public IToken nextToken() {
        this.fTokenOffset += this.fTokenLength;
        this.fTokenLength = this.fPrefixLength;
        block118: while (true) {
            int ch = this.fScanner.read();
            char c = (char)ch;
            switch (ch) {
                case -1: {
                    if (this.fTokenLength > 0) {
                        this.fLast = 0;
                        return this.preFix(this.fState, 0, 0, 0);
                    }
                    this.fLast = 0;
                    this.fPrefixLength = 0;
                    return Token.EOF;
                }
                case 13: {
                    if (this.fLast != 6) {
                        this.fLast = 6;
                        ++this.fTokenLength;
                        continue block118;
                    }
                    switch (this.fState) {
                        case 1: 
                        case 4: 
                        case 5: {
                            if (this.fTokenLength > 0) {
                                IToken token = this.fTokens[this.fState];
                                this.fLast = 6;
                                this.fPrefixLength = 1;
                                this.fState = 0;
                                return token;
                            }
                            this.consume();
                            continue block118;
                        }
                        case 0: {
                            if (this.enclosingState != 0 && this.braceCount == 0 && this.bracketCount == 0) {
                                IToken token = this.fTokens[this.fState];
                                this.fLast = 6;
                                this.fPrefixLength = 1;
                                this.fState = 7;
                                return token;
                            }
                            this.consume();
                            continue block118;
                        }
                        case 8: 
                        case 10: 
                        case 11: {
                            if (this.fTokenLength > 0) {
                                IToken token = this.fTokens[this.fState];
                                this.fLast = 6;
                                this.fPrefixLength = 1;
                                this.fState = 7;
                                return token;
                            }
                            this.consume();
                            continue block118;
                        }
                    }
                    this.consume();
                    continue block118;
                }
                case 10: {
                    switch (this.fState) {
                        case 1: 
                        case 4: 
                        case 5: {
                            return this.postFix(this.fState, 0);
                        }
                        case 8: 
                        case 10: 
                        case 11: {
                            return this.postFix(this.fState, 7);
                        }
                        case 0: {
                            if (this.enclosingState == 0 || this.braceCount != 0 || this.bracketCount != 0 || this.wasColon) break;
                            return this.postFix(0, 7);
                        }
                    }
                    this.consume();
                    continue block118;
                }
            }
            if (this.fLast == 6) {
                switch (this.fState) {
                    case 1: 
                    case 4: 
                    case 5: {
                        int newState;
                        int last;
                        switch (ch) {
                            case 47: {
                                last = 2;
                                newState = 0;
                                break;
                            }
                            case 42: {
                                last = 5;
                                newState = 0;
                                break;
                            }
                            case 39: {
                                last = 0;
                                newState = 4;
                                break;
                            }
                            case 34: {
                                last = 0;
                                newState = 5;
                                break;
                            }
                            case 13: {
                                last = 6;
                                newState = 0;
                                break;
                            }
                            case 92: {
                                last = 1;
                                newState = 0;
                                break;
                            }
                            case 35: {
                                last = 7;
                                newState = 0;
                                break;
                            }
                            default: {
                                last = 0;
                                newState = 0;
                            }
                        }
                        this.fLast = 0;
                        return this.preFix(this.fState, newState, last, 1);
                    }
                    case 8: 
                    case 10: 
                    case 11: {
                        int newState;
                        int last;
                        switch (ch) {
                            case 45: {
                                last = 11;
                                newState = 7;
                                break;
                            }
                            case 47: {
                                last = 2;
                                newState = 7;
                                break;
                            }
                            case 39: {
                                last = 0;
                                newState = 10;
                                break;
                            }
                            case 34: {
                                last = 0;
                                newState = 11;
                                break;
                            }
                            case 125: {
                                last = 0;
                                newState = 6;
                                break;
                            }
                            default: {
                                last = 0;
                                newState = 7;
                            }
                        }
                        this.fLast = 0;
                        return this.preFix(this.fState, newState, last, 1);
                    }
                }
            }
            block35 : switch (this.fState) {
                case 0: {
                    switch (ch) {
                        case 47: {
                            if (this.fLast == 2) {
                                if (this.fTokenLength > SQLJPartitionScanner.getLastLength(this.fLast)) {
                                    return this.preFix(0, 1, 0, 2);
                                }
                                this.preFix(0, 1, 0, 2);
                                this.fTokenOffset += this.fTokenLength;
                                this.fTokenLength = this.fPrefixLength;
                                break block35;
                            }
                            ++this.fTokenLength;
                            this.fLast = 2;
                            break block35;
                        }
                        case 42: {
                            if (this.fLast == 2) {
                                if (this.fTokenLength > SQLJPartitionScanner.getLastLength(this.fLast)) {
                                    return this.preFix(0, 2, 3, 2);
                                }
                                this.preFix(0, 2, 3, 2);
                                this.fTokenOffset += this.fTokenLength;
                                this.fTokenLength = this.fPrefixLength;
                                break block35;
                            }
                            this.consume();
                            break block35;
                        }
                        case 39: {
                            this.fLast = 0;
                            if (this.fTokenLength > 0) {
                                return this.preFix(0, 4, 0, 1);
                            }
                            this.preFix(0, 4, 0, 1);
                            this.fTokenOffset += this.fTokenLength;
                            this.fTokenLength = this.fPrefixLength;
                            break block35;
                        }
                        case 34: {
                            this.fLast = 0;
                            if (this.fTokenLength > 0) {
                                return this.preFix(0, 5, 0, 1);
                            }
                            this.preFix(0, 5, 0, 1);
                            this.fTokenOffset += this.fTokenLength;
                            this.fTokenLength = this.fPrefixLength;
                            break block35;
                        }
                        case 40: {
                            ++this.braceCount;
                            this.wasColon = false;
                            this.consume();
                            break block35;
                        }
                        case 91: {
                            ++this.bracketCount;
                            this.consume();
                            break block35;
                        }
                        case 41: {
                            --this.braceCount;
                            if (this.enclosingState != 0 && this.braceCount <= 0 && this.bracketCount <= 0) {
                                this.braceCount = 0;
                                this.bracketCount = 0;
                                return this.postFix(0, this.enclosingState);
                            }
                            this.consume();
                            break block35;
                        }
                        case 93: {
                            --this.bracketCount;
                            if (this.enclosingState != 0 && this.braceCount <= 0 && this.bracketCount <= 0) {
                                this.braceCount = 0;
                                this.bracketCount = 0;
                                return this.postFix(0, this.enclosingState);
                            }
                            this.consume();
                            break block35;
                        }
                    }
                    if (this.enclosingState != 0 && this.braceCount == 0 && this.bracketCount == 0) {
                        if (this.wasColon && Character.isJavaIdentifierStart(c)) {
                            this.wasColon = false;
                            this.consume();
                            break;
                        }
                        if (!this.wasColon && !Character.isJavaIdentifierPart(c)) {
                            if (ch == 125) {
                                this.fLast = 0;
                                this.enclosingState = 6;
                                if (this.fTokenLength > 0) {
                                    return this.preFix(0, 6, 0, 1);
                                }
                                this.preFix(7, 6, 0, 1);
                                this.fTokenOffset += this.fTokenLength;
                                this.fTokenLength = this.fPrefixLength;
                                break;
                            }
                            if (this.fTokenLength > 0) {
                                return this.preFix(0, this.enclosingState, 0, 1);
                            }
                            this.preFix(0, this.enclosingState, 0, 1);
                            this.fTokenOffset += this.fTokenLength;
                            this.fTokenLength = this.fPrefixLength;
                            break;
                        }
                        this.consume();
                        break;
                    }
                    switch (ch) {
                        case 35: {
                            ++this.fTokenLength;
                            this.fLast = 7;
                            break block35;
                        }
                        case 115: {
                            if (this.fLast == 7) {
                                ++this.fTokenLength;
                                this.fLast = 8;
                                break block35;
                            }
                            this.consume();
                            break block35;
                        }
                        case 113: {
                            if (this.fLast == 8) {
                                ++this.fTokenLength;
                                this.fLast = 9;
                                break block35;
                            }
                            this.consume();
                            break block35;
                        }
                        case 108: {
                            if (this.fLast == 9) {
                                this.enclosingState = 6;
                                if (this.fTokenLength > SQLJPartitionScanner.getLastLength(this.fLast)) {
                                    return this.preFix(0, 6, 10, 4);
                                }
                                this.preFix(0, 6, 10, 4);
                                this.fTokenOffset += this.fTokenLength;
                                this.fTokenLength = this.fPrefixLength;
                                break block35;
                            }
                            this.consume();
                            break block35;
                        }
                    }
                    this.consume();
                    break;
                }
                case 1: 
                case 8: {
                    this.consume();
                    break;
                }
                case 3: {
                    switch (ch) {
                        case 47: {
                            switch (this.fLast) {
                                case 4: {
                                    return this.postFix(2, 0);
                                }
                                case 5: {
                                    return this.postFix(3, 0);
                                }
                            }
                            this.consume();
                            break block35;
                        }
                        case 42: {
                            ++this.fTokenLength;
                            this.fLast = 5;
                            break block35;
                        }
                    }
                    this.consume();
                    break;
                }
                case 2: {
                    switch (ch) {
                        case 42: {
                            if (this.fLast == 3) {
                                this.fLast = 4;
                                ++this.fTokenLength;
                                this.fState = 3;
                                break block35;
                            }
                            ++this.fTokenLength;
                            this.fLast = 5;
                            break block35;
                        }
                        case 47: {
                            if (this.fLast == 5) {
                                return this.postFix(2, 0);
                            }
                            this.consume();
                            break block35;
                        }
                    }
                    this.consume();
                    break;
                }
                case 5: {
                    switch (ch) {
                        case 92: {
                            this.fLast = this.fLast == 1 ? 0 : 1;
                            ++this.fTokenLength;
                            break block35;
                        }
                        case 34: {
                            if (this.fLast != 1) {
                                return this.postFix(5, 0);
                            }
                            this.consume();
                            break block35;
                        }
                    }
                    this.consume();
                    break;
                }
                case 4: {
                    switch (ch) {
                        case 92: {
                            this.fLast = this.fLast == 1 ? 0 : 1;
                            ++this.fTokenLength;
                            break block35;
                        }
                        case 39: {
                            if (this.fLast != 1) {
                                return this.postFix(4, 0);
                            }
                            this.consume();
                            break block35;
                        }
                    }
                    this.consume();
                    break;
                }
                case 6: {
                    switch (ch) {
                        case 59: {
                            this.enclosingState = 0;
                            return this.postFix(6, 0);
                        }
                        case 123: {
                            this.enclosingState = 7;
                            return this.postFix(6, 7);
                        }
                        case 40: {
                            this.fLast = 0;
                            ++this.braceCount;
                            if (this.fTokenLength > 0) {
                                return this.preFix(6, 0, 0, 1);
                            }
                            this.preFix(6, 0, 0, 1);
                            this.fTokenOffset += this.fTokenLength;
                            this.fTokenLength = this.fPrefixLength;
                            break block35;
                        }
                        case 91: {
                            this.fLast = 0;
                            ++this.bracketCount;
                            if (this.fTokenLength > 0) {
                                return this.preFix(6, 0, 0, 1);
                            }
                            this.preFix(6, 0, 0, 1);
                            this.fTokenOffset += this.fTokenLength;
                            this.fTokenLength = this.fPrefixLength;
                            break block35;
                        }
                    }
                    this.consume();
                    break;
                }
                case 9: {
                    switch (ch) {
                        case 64: {
                            if (this.fLast == 3) {
                                this.fLast = 13;
                                ++this.fTokenLength;
                                this.fState = 12;
                                break block35;
                            }
                            this.consume();
                            break block35;
                        }
                        case 47: {
                            if (this.fLast == 5) {
                                return this.postFix(9, 7);
                            }
                            this.consume();
                            break block35;
                        }
                        case 42: {
                            ++this.fTokenLength;
                            this.fLast = 5;
                            break block35;
                        }
                    }
                    this.consume();
                    break;
                }
                case 12: {
                    switch (ch) {
                        case 47: {
                            switch (this.fLast) {
                                case 5: {
                                    return this.postFix(12, 7);
                                }
                            }
                            this.consume();
                            break block35;
                        }
                        case 42: {
                            ++this.fTokenLength;
                            this.fLast = 5;
                            break block35;
                        }
                    }
                    this.consume();
                    break;
                }
                case 10: {
                    switch (ch) {
                        case 39: {
                            return this.postFix(10, 7);
                        }
                    }
                    this.consume();
                    break;
                }
                case 11: {
                    switch (ch) {
                        case 34: {
                            return this.postFix(11, 7);
                        }
                    }
                    this.consume();
                    break;
                }
                case 7: {
                    switch (ch) {
                        case 125: {
                            this.fLast = 0;
                            this.enclosingState = 6;
                            if (this.fTokenLength > 0) {
                                return this.preFix(7, 6, 0, 1);
                            }
                            this.preFix(7, 6, 0, 1);
                            this.fTokenOffset += this.fTokenLength;
                            this.fTokenLength = this.fPrefixLength;
                            break block35;
                        }
                        case 39: {
                            this.fLast = 0;
                            if (this.fTokenLength > 0) {
                                return this.preFix(7, 10, 0, 1);
                            }
                            this.preFix(7, 10, 0, 1);
                            this.fTokenOffset += this.fTokenLength;
                            this.fTokenLength = this.fPrefixLength;
                            break block35;
                        }
                        case 34: {
                            this.fLast = 0;
                            if (this.fTokenLength > 0) {
                                return this.preFix(7, 11, 0, 1);
                            }
                            this.preFix(7, 11, 0, 1);
                            this.fTokenOffset += this.fTokenLength;
                            this.fTokenLength = this.fPrefixLength;
                            break block35;
                        }
                        case 45: {
                            if (this.fLast == 11) {
                                if (this.fTokenLength > SQLJPartitionScanner.getLastLength(this.fLast)) {
                                    return this.preFix(7, 8, 0, 2);
                                }
                                this.preFix(7, 8, 0, 2);
                                this.fTokenOffset += this.fTokenLength;
                                this.fTokenLength = this.fPrefixLength;
                                break block35;
                            }
                            ++this.fTokenLength;
                            this.fLast = 11;
                            break block35;
                        }
                        case 47: {
                            ++this.fTokenLength;
                            this.fLast = 2;
                            break block35;
                        }
                        case 42: {
                            if (this.fLast == 2) {
                                if (this.fTokenLength > SQLJPartitionScanner.getLastLength(this.fLast)) {
                                    return this.preFix(7, 9, 3, 2);
                                }
                                this.preFix(7, 9, 3, 2);
                                this.fTokenOffset += this.fTokenLength;
                                this.fTokenLength = this.fPrefixLength;
                                break block35;
                            }
                            this.consume();
                            break block35;
                        }
                        case 58: {
                            IToken token = this.postFix(7, 0);
                            this.wasColon = true;
                            return token;
                        }
                    }
                    this.consume();
                }
            }
        }
    }

    private static final int getLastLength(int last) {
        switch (last) {
            case 0: {
                return 0;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 14: {
                return 1;
            }
            case 3: 
            case 8: 
            case 12: {
                return 2;
            }
            case 4: 
            case 9: 
            case 13: {
                return 3;
            }
            case 10: {
                return 4;
            }
        }
        return -1;
    }

    private final void consume() {
        ++this.fTokenLength;
        this.fLast = 0;
    }

    private final IToken postFix(int state, int newState) {
        ++this.fTokenLength;
        this.fLast = 0;
        this.fState = newState;
        this.fPrefixLength = 0;
        return this.fTokens[state];
    }

    private final IToken preFix(int state, int newState, int last, int prefixLength) {
        this.fTokenLength -= SQLJPartitionScanner.getLastLength(this.fLast);
        this.fLast = last;
        this.fPrefixLength = prefixLength;
        IToken token = this.fTokens[state];
        this.fState = newState;
        return token;
    }

    private static int getState(String contentType) {
        if (contentType == null) {
            return 0;
        }
        if (contentType.equals(JAVA_SINGLE_LINE_COMMENT)) {
            return 1;
        }
        if (contentType.equals(JAVA_MULTI_LINE_COMMENT)) {
            return 2;
        }
        if (contentType.equals(JAVA_DOC)) {
            return 3;
        }
        if (contentType.equals(JAVA_STRING)) {
            return 5;
        }
        if (contentType.equals(SKIP)) {
            return 4;
        }
        if (contentType.equals(SQL_TXT)) {
            return 7;
        }
        if (contentType.equals(SQLJ_TXT)) {
            return 6;
        }
        return 0;
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        this.scanFromStartToOffset(document, partitionOffset, length);
        int oldEnclosingState = this.enclosingState;
        this.setRange(document, offset, length);
        this.fState = contentType == null ? 0 : (contentType.equals(SQL_TXT) ? 7 : (contentType.equals(SQL_STRING) ? (offset == partitionOffset ? 7 : 10) : (contentType.equals(SQLJ_TXT) ? (offset == partitionOffset ? 0 : 6) : (contentType.equals(SQL_SLC) ? (offset == partitionOffset ? 7 : 8) : (contentType.equals(SQL_MLC) ? (offset == partitionOffset ? 7 : 9) : (contentType.equals(SQL_DELIMITED_ID) ? (offset == partitionOffset ? 7 : 11) : (contentType.equals(SQL_PC) ? (offset == partitionOffset ? 7 : 12) : (offset == partitionOffset ? 0 : SQLJPartitionScanner.getState(contentType)))))))));
        this.enclosingState = oldEnclosingState;
        this.fTokenOffset = partitionOffset;
        this.fTokenLength = 0;
        this.fPrefixLength = offset - partitionOffset;
    }

    private void scanFromStartToOffset(IDocument document, int offset, int length) {
        this.setRange(document, 0, offset + length);
        while (this.fTokenOffset + this.fTokenLength < offset) {
            this.nextToken();
        }
        this.fTokenLength = 0;
        this.fPrefixLength = offset - this.fTokenOffset;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.fScanner.setRange(document, offset, length);
        this.fTokenOffset = offset;
        this.fTokenLength = 0;
        this.fPrefixLength = 0;
        this.fLast = 0;
        this.fState = 0;
        this.enclosingState = 0;
        this.braceCount = 0;
        this.bracketCount = 0;
    }

    public int getTokenLength() {
        return this.fTokenLength;
    }

    public int getTokenOffset() {
        return this.fTokenOffset;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        SQLJPartitionScanner me = new SQLJPartitionScanner();
        me.run(args[0], args[1]);
    }

    /*
     * WARNING - void declaration
     */
    private void run(String in, String out) throws FileNotFoundException, IOException {
        IToken token;
        File inFile = new File(in);
        FileReader reader = new FileReader(inFile);
        char[] buffer = new char[1024];
        StringBuffer stringBuffer = new StringBuffer();
        int total = 0;
        try {
            int read;
            while ((read = reader.read(buffer)) > 0) {
                void var7_8;
                stringBuffer.append(buffer, 0, (int)var7_8);
                total += var7_8;
            }
        }
        catch (IOException ex) {
            SQLJEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.sap.dictionary.tools.sqlj", 4, "run", (Throwable)ex));
        }
        String theText = stringBuffer.toString();
        Document doc = new Document(theText);
        this.fScanner.setRange((IDocument)doc, 0, total);
        buffer = theText.toCharArray();
        File outFile = new File(out);
        FileWriter writer = new FileWriter(outFile);
        writer.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">");
        writer.write("<html><head><title>Test</title></head><body><p style=\"line-height: 100%; text-indent: 0; word-spacing: 0; margin: 0\"><code>");
        long t1 = System.currentTimeMillis();
        while ((token = this.nextToken()) != Token.EOF) {
        }
        long t2 = System.currentTimeMillis();
        System.out.println(t2 - t1 + " ms");
        writer.write("</code></body></html>");
        writer.close();
    }
}

