/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.sqlj.editor;

import com.sap.dictionary.tools.sqlj.SQLJEditorPlugin;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.CompositeActionGroup;
import org.eclipse.jdt.internal.ui.javaeditor.GotoErrorAction;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.internal.ui.javaeditor.TogglePresentationAction;
import org.eclipse.jdt.internal.ui.javaeditor.ToggleTextHoverAction;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.StatusBarUpdater;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jdt.ui.actions.CCPActionGroup;
import org.eclipse.jdt.ui.actions.GenerateActionGroup;
import org.eclipse.jdt.ui.actions.JavaSearchActionGroup;
import org.eclipse.jdt.ui.actions.MemberFilterActionGroup;
import org.eclipse.jdt.ui.actions.OpenAction;
import org.eclipse.jdt.ui.actions.OpenViewActionGroup;
import org.eclipse.jdt.ui.actions.RefactorActionGroup;
import org.eclipse.jdt.ui.actions.ShowActionGroup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class SQLJOutlinePage
extends Page
implements IContentOutlinePage {
    private IJavaElement fInput;
    private String fContextMenuID;
    private Menu fMenu;
    private JavaOutlineViewer fOutlineViewer;
    private JavaEditor fEditor;
    private MemberFilterActionGroup fMemberFilterActionGroup;
    private ListenerList fSelectionChangedListeners = new ListenerList();
    private Hashtable fActions = new Hashtable();
    private TogglePresentationAction fTogglePresentation;
    private ToggleTextHoverAction fToggleTextHover;
    private GotoErrorAction fPreviousError;
    private GotoErrorAction fNextError;
    private TextOperationAction fShowJavadoc;
    private OpenAction fOpenAction;
    private CompositeActionGroup fActionGroups;
    private CCPActionGroup fCCPActionGroup;

    public SQLJOutlinePage(String contextMenuID, JavaEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fContextMenuID = contextMenuID;
        this.fEditor = editor;
        this.fTogglePresentation = new TogglePresentationAction();
        this.fToggleTextHover = new ToggleTextHoverAction();
        this.fPreviousError = new GotoErrorAction("PreviousError.", false);
        this.fPreviousError.setImageDescriptor(JavaPluginImages.DESC_TOOL_GOTO_PREV_ERROR);
        this.fNextError = new GotoErrorAction("NextError.", true);
        this.fNextError.setImageDescriptor(JavaPluginImages.DESC_TOOL_GOTO_NEXT_ERROR);
        this.fShowJavadoc = (TextOperationAction)this.fEditor.getAction("ShowJavaDoc");
        this.fTogglePresentation.setEditor((ITextEditor)editor);
        this.fToggleTextHover.setEditor((ITextEditor)editor);
        this.fPreviousError.setEditor((ITextEditor)editor);
        this.fNextError.setEditor((ITextEditor)editor);
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.addSelectionChangedListener(listener);
        } else {
            this.fSelectionChangedListeners.add((Object)listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.removeSelectionChangedListener(listener);
        } else {
            this.fSelectionChangedListeners.remove((Object)listener);
        }
    }

    public void setSelection(ISelection selection) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.setSelection(selection);
        }
    }

    public ISelection getSelection() {
        if (this.fOutlineViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.fOutlineViewer.getSelection();
    }

    private void registerToolbarActions() {
        IToolBarManager toolBarManager = this.getSite().getActionBars().getToolBarManager();
        if (toolBarManager != null) {
            LexicalSortingAction action = new LexicalSortingAction();
            toolBarManager.add((IAction)action);
            this.fMemberFilterActionGroup = new MemberFilterActionGroup((StructuredViewer)this.fOutlineViewer, "JavaOutlineViewer");
            this.fMemberFilterActionGroup.contributeToToolBar(toolBarManager);
        }
    }

    public void createControl(Composite parent) {
        Tree tree = new Tree(parent, 2);
        AppearanceAwareLabelProvider lprovider = new AppearanceAwareLabelProvider(1090519561, 1);
        this.fOutlineViewer = new JavaOutlineViewer(tree);
        this.fOutlineViewer.setContentProvider((IContentProvider)new ChildrenProvider());
        this.fOutlineViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)lprovider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        Object[] listeners = this.fSelectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            this.fSelectionChangedListeners.remove(listeners[i]);
            this.fOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)listeners[i]);
            ++i;
        }
        MenuManager manager = new MenuManager(this.fContextMenuID, this.fContextMenuID);
        manager.setRemoveAllWhenShown(true);
        IPageSite site = this.getSite();
        site.setSelectionProvider((ISelectionProvider)this.fOutlineViewer);
        this.fOpenAction = new OpenAction((IWorkbenchSite)site);
        site.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this.fOpenAction);
        ActionGroup[] actionGroupArray = new ActionGroup[6];
        actionGroupArray[0] = new OpenViewActionGroup((Page)this);
        actionGroupArray[1] = new ShowActionGroup((Page)this);
        this.fCCPActionGroup = new CCPActionGroup((Page)this);
        actionGroupArray[2] = this.fCCPActionGroup;
        actionGroupArray[3] = new RefactorActionGroup((Page)this);
        actionGroupArray[4] = new GenerateActionGroup((Page)this);
        actionGroupArray[5] = new JavaSearchActionGroup((Page)this);
        this.fActionGroups = new CompositeActionGroup(actionGroupArray);
        IActionBars bars = site.getActionBars();
        bars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ShowJavaDoc", (IAction)this.fShowJavadoc);
        bars.setGlobalActionHandler("togglePresentation", (IAction)this.fTogglePresentation);
        this.fActionGroups.fillActionBars(bars);
        bars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.Open", (IAction)this.fOpenAction);
        IStatusLineManager statusLineManager = site.getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            StatusBarUpdater updater = new StatusBarUpdater(statusLineManager);
            this.fOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)updater);
        }
        this.registerToolbarActions();
        this.fOutlineViewer.setInput(this.fInput);
    }

    public void dispose() {
        if (this.fEditor == null) {
            return;
        }
        this.fEditor.outlinePageClosed();
        this.fEditor = null;
        Object[] listeners = this.fSelectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            this.fSelectionChangedListeners.remove(listeners[i]);
            ++i;
        }
        this.fSelectionChangedListeners = null;
        if (this.fMenu != null && !this.fMenu.isDisposed()) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
        if (this.fActionGroups != null) {
            this.fActionGroups.dispose();
        }
        this.fTogglePresentation.setEditor(null);
        this.fToggleTextHover.setEditor(null);
        this.fPreviousError.setEditor(null);
        this.fNextError.setEditor(null);
        this.fOutlineViewer = null;
        super.dispose();
    }

    public Control getControl() {
        if (this.fOutlineViewer != null) {
            return this.fOutlineViewer.getControl();
        }
        return null;
    }

    public void setInput(IJavaElement inputElement) {
        this.fInput = inputElement;
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.setInput(this.fInput);
        }
    }

    public void select(ISourceReference reference) {
        IStructuredSelection ss;
        List elements;
        ISelection s;
        if (this.fOutlineViewer != null && (s = this.fOutlineViewer.getSelection()) instanceof IStructuredSelection && !(elements = (ss = (IStructuredSelection)s).toList()).contains(reference)) {
            s = reference == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)reference);
            this.fOutlineViewer.setSelection(s, true);
        }
    }

    public void setAction(String actionID, IAction action) {
        Assert.isNotNull((Object)actionID);
        if (action == null) {
            this.fActions.remove(actionID);
        } else {
            this.fActions.put(actionID, action);
        }
    }

    public IAction getAction(String actionID) {
        Assert.isNotNull((Object)actionID);
        return (IAction)this.fActions.get(actionID);
    }

    public void setFocus() {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.getControl().setFocus();
        }
    }

    private boolean isInnerType(IJavaElement element) {
        if (element.getElementType() == 7) {
            IJavaElement parent = element.getParent();
            int type = parent.getElementType();
            return type != 5 && type != 6;
        }
        return false;
    }

    class LexicalSortingAction
    extends Action {
        private JavaElementSorter fSorter = new JavaElementSorter();

        public LexicalSortingAction() {
            this.setText(JavaEditorMessages.getString((String)"JavaOutlinePage.Sort.label"));
            JavaPluginImages.setLocalImageDescriptors((IAction)this, (String)"alphab_sort_co.gif");
            this.setToolTipText(JavaEditorMessages.getString((String)"JavaOutlinePage.Sort.tooltip"));
            this.setDescription(JavaEditorMessages.getString((String)"JavaOutlinePage.Sort.description"));
            boolean checked = JavaPlugin.getDefault().getPreferenceStore().getBoolean("LexicalSortingAction.isChecked");
            this.valueChanged(checked, false);
        }

        public void run() {
            this.valueChanged(this.isChecked(), true);
        }

        private void valueChanged(boolean on, boolean store) {
            this.setChecked(on);
            SQLJOutlinePage.this.fOutlineViewer.setSorter((ViewerSorter)(on ? this.fSorter : null));
            if (store) {
                JavaPlugin.getDefault().getPreferenceStore().setValue("LexicalSortingAction.isChecked", on);
            }
        }
    }

    class JavaOutlineViewer
    extends TreeViewer {
        private Item fReusedExpandedItem;

        public JavaOutlineViewer(Tree tree) {
            super(tree);
            this.setAutoExpandLevel(-1);
        }

        public void reconcile(IJavaElementDelta delta) {
            if (this.getSorter() == null) {
                Widget w = this.findItem(SQLJOutlinePage.this.fInput);
                if (w != null && !w.isDisposed()) {
                    this.update(w, delta);
                }
            } else {
                this.refresh();
            }
        }

        protected void internalExpandToLevel(Widget node, int level) {
            IJavaElement je;
            Item i;
            if (node instanceof Item && (i = (Item)node).getData() instanceof IJavaElement && ((je = (IJavaElement)i.getData()).getElementType() == 12 || SQLJOutlinePage.this.isInnerType(je)) && i != this.fReusedExpandedItem) {
                this.setExpanded(i, false);
                return;
            }
            super.internalExpandToLevel(node, level);
        }

        protected void reuseTreeItem(Item item, Object element) {
            Item[] c = this.getChildren((Widget)item);
            if (c != null && c.length > 0) {
                if (this.getExpanded(item)) {
                    this.fReusedExpandedItem = item;
                }
                int k = 0;
                while (k < c.length) {
                    if (c[k].getData() != null) {
                        this.disassociate(c[k]);
                    }
                    c[k].dispose();
                    ++k;
                }
            }
            this.updateItem((Widget)item, element);
            this.updatePlus(item, element);
            this.internalExpandToLevel((Widget)item, -1);
            this.fReusedExpandedItem = null;
        }

        protected boolean mustUpdateParent(IJavaElementDelta delta, IJavaElement element) {
            if (element instanceof IMethod) {
                if ((delta.getKind() & 1) != 0) {
                    try {
                        return ((IMethod)element).isMainMethod();
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log((Throwable)e);
                    }
                }
                return "main".equals(element.getElementName());
            }
            return false;
        }

        protected ISourceRange getSourceRange(IJavaElement element) throws JavaModelException {
            if (element instanceof IMember) {
                return ((IMember)element).getNameRange();
            }
            if (element instanceof ISourceReference) {
                return ((ISourceReference)element).getSourceRange();
            }
            return null;
        }

        protected boolean overlaps(ISourceRange range, int start, int end) {
            return start <= range.getOffset() + range.getLength() - 1 && range.getOffset() <= end;
        }

        protected boolean filtered(IJavaElement parent, IJavaElement child) {
            Object[] result = new Object[]{child};
            ViewerFilter[] filters = this.getFilters();
            int i = 0;
            while (i < filters.length) {
                if ((result = filters[i].filter((Viewer)this, (Object)parent, result)).length == 0) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        protected void update(Widget w, IJavaElementDelta delta) {
            Item item;
            IJavaElement parent = delta.getElement();
            IJavaElementDelta[] affected = delta.getAffectedChildren();
            Item[] children = this.getChildren(w);
            boolean doUpdateParent = false;
            Vector<Item> deletions = new Vector<Item>();
            Vector<IJavaElementDelta> additions = new Vector<IJavaElementDelta>();
            int i = 0;
            while (i < affected.length) {
                IJavaElementDelta affectedDelta = affected[i];
                IJavaElement affectedElement = affectedDelta.getElement();
                int status = affected[i].getKind();
                int j = 0;
                while (j < children.length) {
                    if (affectedElement.equals(children[j].getData())) break;
                    ++j;
                }
                if (j == children.length) {
                    if ((status & 4) != 0 && (affectedDelta.getFlags() & 2) != 0 && !this.filtered(parent, affectedElement)) {
                        additions.addElement(affectedDelta);
                    }
                } else {
                    item = children[j];
                    if ((status & 2) != 0) {
                        deletions.addElement(item);
                        doUpdateParent = doUpdateParent || this.mustUpdateParent(affectedDelta, affectedElement);
                    } else if ((status & 4) != 0) {
                        int change = affectedDelta.getFlags();
                        boolean bl = doUpdateParent = doUpdateParent || this.mustUpdateParent(affectedDelta, affectedElement);
                        if ((change & 2) != 0) {
                            if (this.filtered(parent, affectedElement)) {
                                deletions.addElement(item);
                            } else {
                                this.updateItem((Widget)item, affectedElement);
                            }
                        }
                        if ((change & 1) != 0) {
                            this.updateItem((Widget)item, affectedElement);
                        }
                        if ((change & 8) != 0) {
                            this.update((Widget)item, affectedDelta);
                        }
                    }
                }
                ++i;
            }
            IJavaElementDelta[] add = delta.getAddedChildren();
            if (additions.size() > 0) {
                IJavaElementDelta[] tmp = new IJavaElementDelta[add.length + additions.size()];
                System.arraycopy(add, 0, tmp, 0, add.length);
                int i2 = 0;
                while (i2 < additions.size()) {
                    tmp[i2 + add.length] = (IJavaElementDelta)additions.elementAt(i2);
                    ++i2;
                }
                add = tmp;
            }
            int i3 = 0;
            while (i3 < add.length) {
                block28: {
                    try {
                        IJavaElement e = add[i3].getElement();
                        if (this.filtered(parent, e)) break block28;
                        doUpdateParent = doUpdateParent || this.mustUpdateParent(add[i3], e);
                        ISourceRange rng = this.getSourceRange(e);
                        int start = rng.getOffset();
                        int end = start + rng.getLength() - 1;
                        Item last = null;
                        item = null;
                        children = this.getChildren(w);
                        int j = 0;
                        while (j < children.length) {
                            block29: {
                                item = children[j];
                                IJavaElement r = (IJavaElement)item.getData();
                                if (r == null) break block28;
                                try {
                                    rng = this.getSourceRange(r);
                                    if (this.overlaps(rng, start, end)) {
                                        this.reuseTreeItem(item, e);
                                        break block28;
                                    }
                                    if (rng.getOffset() <= start) break block29;
                                    if (last != null && deletions.contains(last)) {
                                        deletions.removeElement(last);
                                        this.reuseTreeItem(last, e);
                                    } else {
                                        this.createTreeItem(w, e, j);
                                    }
                                    break block28;
                                }
                                catch (JavaModelException x) {
                                    SQLJEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.sap.dictionary.tools.sqlj", 4, "deleted element in outline page", (Throwable)x));
                                }
                            }
                            last = item;
                            ++j;
                        }
                        if (last != null && deletions.contains(last)) {
                            deletions.removeElement(last);
                            this.reuseTreeItem(last, e);
                        } else {
                            this.createTreeItem(w, e, -1);
                        }
                    }
                    catch (JavaModelException x) {
                        // empty catch block
                    }
                }
                ++i3;
            }
            Enumeration e = deletions.elements();
            while (e.hasMoreElements()) {
                item = (Item)e.nextElement();
                this.disassociate(item);
                item.dispose();
            }
            if (doUpdateParent) {
                this.updateItem(w, delta.getElement());
            }
        }

        protected void handleLabelProviderChanged(LabelProviderChangedEvent event) {
            IResource resource;
            ProblemsLabelDecorator.ProblemsLabelChangedEvent e;
            Object input = this.getInput();
            if (event instanceof ProblemsLabelDecorator.ProblemsLabelChangedEvent && (e = (ProblemsLabelDecorator.ProblemsLabelChangedEvent)event).isMarkerChange() && input instanceof ICompilationUnit) {
                return;
            }
            Object[] changed = event.getElements();
            if (changed != null && (resource = this.getUnderlyingResource()) != null) {
                int i = 0;
                while (i < changed.length) {
                    if (changed[i].equals(resource)) {
                        event = new LabelProviderChangedEvent((IBaseLabelProvider)event.getSource());
                        break;
                    }
                    ++i;
                }
            }
            super.handleLabelProviderChanged(event);
        }

        private IResource getUnderlyingResource() {
            Object input = this.getInput();
            if (input instanceof ICompilationUnit) {
                ICompilationUnit cu = (ICompilationUnit)input;
                if (cu.isWorkingCopy()) {
                    return cu.getOriginalElement().getResource();
                }
                return cu.getResource();
            }
            if (input instanceof IClassFile) {
                return ((IClassFile)input).getResource();
            }
            return null;
        }
    }

    class ChildrenProvider
    implements ITreeContentProvider {
        private ElementChangedListener fListener;

        ChildrenProvider() {
        }

        protected boolean matches(IJavaElement element) {
            if (element.getElementType() == 9) {
                String name = element.getElementName();
                return name != null && name.indexOf(60) >= 0;
            }
            return false;
        }

        protected IJavaElement[] filter(IJavaElement[] children) {
            boolean initializers = false;
            int i = 0;
            while (i < children.length) {
                if (this.matches(children[i])) {
                    initializers = true;
                    break;
                }
                ++i;
            }
            if (!initializers) {
                return children;
            }
            Vector<IJavaElement> v = new Vector<IJavaElement>();
            int i2 = 0;
            while (i2 < children.length) {
                if (!this.matches(children[i2])) {
                    v.addElement(children[i2]);
                }
                ++i2;
            }
            Object[] result = new IJavaElement[v.size()];
            v.copyInto(result);
            return result;
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof IParent) {
                IParent c = (IParent)parent;
                try {
                    return this.filter(c.getChildren());
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            return new Object[0];
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            if (child instanceof IJavaElement) {
                IJavaElement e = (IJavaElement)child;
                return e.getParent();
            }
            return null;
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof IParent) {
                IParent c = (IParent)parent;
                try {
                    IJavaElement[] children = this.filter(c.getChildren());
                    return children != null && children.length > 0;
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            return false;
        }

        public boolean isDeleted(Object o) {
            return false;
        }

        public void dispose() {
            if (this.fListener != null) {
                JavaCore.removeElementChangedListener((IElementChangedListener)this.fListener);
                this.fListener = null;
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            boolean isCU = newInput instanceof ICompilationUnit;
            if (isCU && this.fListener == null) {
                this.fListener = new ElementChangedListener();
                JavaCore.addElementChangedListener((IElementChangedListener)this.fListener);
            } else if (!isCU && this.fListener != null) {
                JavaCore.removeElementChangedListener((IElementChangedListener)this.fListener);
                this.fListener = null;
            }
        }
    }

    class ElementChangedListener
    implements IElementChangedListener {
        ElementChangedListener() {
        }

        public void elementChanged(ElementChangedEvent e) {
            if (SQLJOutlinePage.this.getControl() == null) {
                return;
            }
            Display d = SQLJOutlinePage.this.getControl().getDisplay();
            if (d != null) {
                d.asyncExec(new Runnable(this, e){
                    private final /* synthetic */ ElementChangedEvent val$e;
                    private final /* synthetic */ ElementChangedListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public void run() {
                        IJavaElementDelta delta = this.this$1.findElement((ICompilationUnit)SQLJOutlinePage.access$100(ElementChangedListener.access$000(this.this$1)), this.val$e.getDelta());
                        if (delta != null && SQLJOutlinePage.access$200(ElementChangedListener.access$000(this.this$1)) != null) {
                            SQLJOutlinePage.access$200(ElementChangedListener.access$000(this.this$1)).reconcile(delta);
                        }
                    }
                });
            }
        }

        protected IJavaElementDelta findElement(ICompilationUnit unit, IJavaElementDelta delta) {
            if (delta == null || unit == null) {
                return null;
            }
            IJavaElement element = delta.getElement();
            if (unit.equals(element)) {
                return delta;
            }
            if (element.getElementType() > 6) {
                return null;
            }
            IJavaElementDelta[] children = delta.getAffectedChildren();
            if (children == null || children.length == 0) {
                return null;
            }
            int i = 0;
            while (i < children.length) {
                IJavaElementDelta d = this.findElement(unit, children[i]);
                if (d != null) {
                    return d;
                }
                ++i;
            }
            return null;
        }

        static /* synthetic */ SQLJOutlinePage access$000(ElementChangedListener x0) {
            return x0.SQLJOutlinePage.this;
        }
    }
}

