/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.sqlj.editor;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.template.ContextType;
import org.eclipse.jdt.internal.corext.template.ContextTypeRegistry;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.ExperimentalResultCollector;
import org.eclipse.jdt.internal.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProcessor;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ResultCollector;
import org.eclipse.jdt.internal.ui.text.template.TemplateEngine;
import org.eclipse.jdt.internal.ui.text.template.TemplateProposal;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;

public class SQLJCompletionProcessor
extends JavaCompletionProcessor {
    private IEditorInput fEditorInput;
    private IJavaElement fElement;
    private ResultCollector fCollector;
    private IWorkingCopyManager fManager;
    private IContextInformationValidator fValidator;
    private char[] fProposalAutoActivationSet;
    private Comparator fComparator;
    private boolean fAllowAddImports;
    private TemplateEngine fTemplateEngine;
    private ExperimentalResultCollector fExperimentalCollector;

    public SQLJCompletionProcessor(IJavaElement element) {
        super(null);
        this.fElement = element;
        this.fCollector = new ResultCollector();
        this.fManager = JavaPlugin.getDefault().getWorkingCopyManager();
        ContextType contextType = ContextTypeRegistry.getInstance().getContextType("java");
        if (contextType != null) {
            this.fTemplateEngine = new TemplateEngine(contextType);
        }
        this.fExperimentalCollector = new ExperimentalResultCollector();
        this.fAllowAddImports = true;
    }

    private ICompletionProposal[] order(ICompletionProposal[] proposals) {
        if (this.fComparator != null) {
            Arrays.sort(proposals, this.fComparator);
        }
        return proposals;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        JavaCompletionProposal[] results;
        Shell shell;
        Point selection;
        ICompilationUnit unit = (ICompilationUnit)this.fElement;
        if (JavaPlugin.getDefault().getPreferenceStore().getBoolean("content_assist_fill_method_arguments")) {
            try {
                if (unit != null) {
                    this.fExperimentalCollector.reset(offset, unit.getJavaProject(), (ICompilationUnit)(this.fAllowAddImports ? unit : null));
                    this.fExperimentalCollector.setViewer(viewer);
                    selection = viewer.getSelectedRange();
                    if (selection.y > 0) {
                        this.fExperimentalCollector.setReplacementLength(selection.y);
                    }
                    unit.codeComplete(offset, (ICompletionRequestor)this.fExperimentalCollector);
                }
            }
            catch (JavaModelException x) {
                shell = viewer.getTextWidget().getShell();
            }
            results = this.fExperimentalCollector.getResults();
        } else {
            try {
                if (unit != null) {
                    this.fCollector.reset(offset, unit.getJavaProject(), (ICompilationUnit)(this.fAllowAddImports ? unit : null));
                    selection = viewer.getSelectedRange();
                    if (selection.y > 0) {
                        this.fCollector.setReplacementLength(selection.y);
                    }
                    unit.codeComplete(offset, (ICompletionRequestor)this.fCollector);
                }
            }
            catch (JavaModelException x) {
                shell = viewer.getTextWidget().getShell();
            }
            results = this.fCollector.getResults();
        }
        if (this.fTemplateEngine != null) {
            try {
                this.fTemplateEngine.reset();
                this.fTemplateEngine.complete(viewer, offset, unit);
            }
            catch (JavaModelException x) {
                shell = viewer.getTextWidget().getShell();
            }
            TemplateProposal[] templateResults = this.fTemplateEngine.getResults();
            IJavaCompletionProposal[] total = new IJavaCompletionProposal[results.length + templateResults.length];
            System.arraycopy(templateResults, 0, total, 0, templateResults.length);
            System.arraycopy(results, 0, total, templateResults.length, results.length);
            results = total;
        }
        return this.order((ICompletionProposal[])results);
    }
}

