/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.sqlj.editor;

import com.sap.dictionary.tools.sqlj.SQLJEditorPlugin;
import com.sap.dictionary.tools.sqlj.translator.SQLJResourceHandlingHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitDocumentProvider;
import org.eclipse.jdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class SQLJCompilationUnitProvider
implements ITextListener {
    private IEditorInput javaEditorInput;
    private IEditorInput sqljEditorInput;
    private static CompilationUnitDocumentProvider docProvider;
    private static WorkingCopyManager workingCopyManager;

    private static CompilationUnitDocumentProvider getDocProvider() {
        if (docProvider == null) {
            docProvider = new CompilationUnitDocumentProvider();
        }
        return docProvider;
    }

    private static WorkingCopyManager getWorkingCopyManager() {
        if (workingCopyManager == null) {
            workingCopyManager = new WorkingCopyManager(SQLJCompilationUnitProvider.getDocProvider());
        }
        return workingCopyManager;
    }

    public SQLJCompilationUnitProvider(IEditorInput editorInput) {
        this.sqljEditorInput = editorInput;
        try {
            FileEditorInput sqljEditorInput = (FileEditorInput)editorInput;
            IFile file = sqljEditorInput.getFile();
            IPath javaPath = SQLJResourceHandlingHelper.getJavaFilePath(file.getProject(), file.getFullPath());
            IFile javaFile = file.getWorkspace().getRoot().getFile(javaPath);
            this.javaEditorInput = new FileEditorInput(javaFile);
            CompilationUnitDocumentProvider docProvider = SQLJCompilationUnitProvider.getDocProvider();
            docProvider.connect((Object)this.javaEditorInput);
            this.update();
        }
        catch (Exception exc) {
            SQLJEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.sap.dictionary.tools.sqlj", 4, "init", (Throwable)exc));
        }
    }

    public ICompilationUnit getCompilationUnit() {
        return SQLJCompilationUnitProvider.getWorkingCopyManager().getWorkingCopy(this.javaEditorInput);
    }

    public IEditorInput getEditorInput() {
        return this.javaEditorInput;
    }

    public void textChanged(TextEvent event) {
        this.update();
    }

    private void update() {
        Document sqljDocument = (Document)SQLJEditorPlugin.getDocumentProvider().getDocument(this.sqljEditorInput);
        String sourceCode = sqljDocument.get();
        CompilationUnitDocumentProvider docProvider = SQLJCompilationUnitProvider.getDocProvider();
        Document javaDocument = (Document)docProvider.getDocument((Object)this.javaEditorInput);
        if (javaDocument != null) {
            javaDocument.set(sourceCode);
            ICompilationUnit compUnit = SQLJCompilationUnitProvider.getWorkingCopyManager().getWorkingCopy(this.javaEditorInput);
            try {
                compUnit.reconcile();
            }
            catch (JavaModelException e) {
                SQLJEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.sap.dictionary.tools.sqlj", 4, "compilation unit reconcile", (Throwable)e));
            }
        }
    }
}

