/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.sqlj.editor;

import com.sap.dictionary.tools.sqlj.editor.SQLJEditor;
import java.io.Reader;
import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocAccess;
import org.eclipse.jdt.internal.corext.javadoc.SingleCharReader;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.HTMLPrinter;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jdt.internal.ui.text.javadoc.JavaDoc2HTMLTextReader;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabels;
import org.eclipse.jdt.ui.text.java.hover.IJavaEditorTextHover;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;

public class JavaTypeHover
implements IJavaEditorTextHover {
    private SQLJEditor fEditor;
    private IJavaEditorTextHover fProblemHover;
    private final int LABEL_FLAGS = 39136439;

    public void setEditor(IEditorPart editor) {
        this.fEditor = (SQLJEditor)editor;
    }

    private ICodeAssist getCodeAssist() {
        if (this.fEditor != null) {
            return this.fEditor.getCompilationUnit();
        }
        return null;
    }

    private String getInfoText(IMember member) {
        return JavaElementLabels.getElementLabel((IJavaElement)member, (int)39136439);
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return JavaWordFinder.findWord((IDocument)textViewer.getDocument(), (int)offset);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        ICodeAssist resolve = this.getCodeAssist();
        if (resolve != null) {
            try {
                IJavaElement[] result = resolve.codeSelect(hoverRegion.getOffset(), hoverRegion.getLength());
                if (result == null) {
                    return null;
                }
                int nResults = result.length;
                if (nResults == 0) {
                    return null;
                }
                StringBuffer buffer = new StringBuffer();
                if (nResults > 1) {
                    int i = 0;
                    while (i < result.length) {
                        HTMLPrinter.startBulletList((StringBuffer)buffer);
                        IJavaElement curr = result[i];
                        if (curr instanceof IMember) {
                            HTMLPrinter.addBullet((StringBuffer)buffer, (String)this.getInfoText((IMember)curr));
                        }
                        HTMLPrinter.endBulletList((StringBuffer)buffer);
                        ++i;
                    }
                } else {
                    IJavaElement curr = result[0];
                    if (curr instanceof IMember) {
                        IMember member = (IMember)curr;
                        HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)this.getInfoText(member));
                        SingleCharReader reader = JavaDocAccess.getJavaDoc((IMember)member, (boolean)true);
                        if (reader != null) {
                            HTMLPrinter.addParagraph((StringBuffer)buffer, (Reader)new JavaDoc2HTMLTextReader((Reader)reader));
                        }
                    }
                }
                if (buffer.length() > 0) {
                    HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0);
                    HTMLPrinter.addPageEpilog((StringBuffer)buffer);
                    return buffer.toString();
                }
            }
            catch (JavaModelException x) {
                JavaPlugin.log((Throwable)x);
            }
        }
        return null;
    }
}

