/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.sqlj.debug;

import com.sap.dictionary.tools.sqlj.SQLJEditorPlugin;
import com.sap.dictionary.tools.sqlj.translator.SQLJResourceHandlingHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.ui.ISourcePresentation;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.ui.JavaUISourceLocator;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.launching.sourcelookup.IJavaSourceLocation;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class SQLJUISourceLocator
implements IPersistableSourceLocator,
ISourcePresentation {
    private JavaUISourceLocator javaSourceLocator;
    private Object sourceElement;

    public SQLJUISourceLocator(ISourceLocator sourceLocator) {
        this.javaSourceLocator = (JavaUISourceLocator)sourceLocator;
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        this.sourceElement = this.javaSourceLocator.getSourceElement(stackFrame);
        return this.sourceElement;
    }

    public IEditorInput getEditorInput(Object element) {
        JavaElement unit = (JavaElement)this.sourceElement;
        try {
            IEditorInput inp = EditorUtility.getEditorInput((Object)element);
            if (inp instanceof FileEditorInput) {
                IFile javaFile = (IFile)unit.getCorrespondingResource();
                IPath sqljPath = SQLJResourceHandlingHelper.getSQLJFilePath(javaFile.getProject(), javaFile.getFullPath());
                IFile sqljFile = javaFile.getWorkspace().getRoot().getFile(sqljPath);
                if (sqljFile.exists()) {
                    return new FileEditorInput(sqljFile);
                }
                return inp;
            }
            return inp;
        }
        catch (JavaModelException e) {
            SQLJEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.sap.dictionary.tools.sqlj", 4, "get editor input", (Throwable)e));
            return null;
        }
    }

    public String getEditorId(IEditorInput input, Object element) {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor descriptor = registry.getDefaultEditor(input.getName());
        if (descriptor != null) {
            return descriptor.getId();
        }
        return null;
    }

    public String getMemento() throws CoreException {
        return this.javaSourceLocator.getMemento();
    }

    public void initializeDefaults(ILaunchConfiguration configuration) throws CoreException {
        this.javaSourceLocator.initializeDefaults(configuration);
    }

    public void initializeFromMemento(String memento) throws CoreException {
        this.javaSourceLocator.initializeFromMemento(memento);
    }

    public IJavaSourceLocation[] getSourceLocations() {
        return this.javaSourceLocator.getSourceLocations();
    }

    public void setSourceLocations(IJavaSourceLocation[] locations) {
        this.javaSourceLocator.setSourceLocations(locations);
    }
}

