/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.sqlj.actions;

import com.sap.dictionary.tools.sqlj.SQLJEditorPlugin;
import com.sap.dictionary.tools.sqlj.editor.SQLJEditor;
import com.sap.dictionary.tools.sqlj.editor.SQLJResourceMarkerAnnotationModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.actions.BreakpointLocationVerifier;
import org.eclipse.jdt.internal.debug.ui.actions.ManageBreakpointRulerAction;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.ITextEditor;

public class SQLJBreakpointRulerAction
extends ManageBreakpointRulerAction {
    public SQLJBreakpointRulerAction(IVerticalRulerInfo ruler, ITextEditor editor) {
        super(ruler, editor);
    }

    protected boolean breakpointElementInEditor(IBreakpointManager manager, IMarker marker) {
        return true;
    }

    protected List getMarkers() {
        ArrayList<IMarker> breakpoints = new ArrayList<IMarker>();
        IEditorInput editorInput = ((SQLJEditor)this.getTextEditor()).getEditorInput();
        IFile resource = ((FileEditorInput)editorInput).getFile();
        IDocument document = this.getDocument();
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        if (model != null) {
            try {
                IMarker[] markers = null;
                if (resource instanceof IFile) {
                    markers = resource.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2);
                } else {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    markers = root.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2);
                }
                if (markers != null) {
                    IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                    int i = 0;
                    while (i < markers.length) {
                        IBreakpoint breakpoint = breakpointManager.getBreakpoint(markers[i]);
                        int lineNumber = (Integer)breakpoint.getMarker().getAttribute("lineNumber");
                        int rulerLine = this.getVerticalRulerInfo().getLineOfLastMouseButtonActivity() + 1;
                        if (breakpoint != null && breakpointManager.isRegistered(breakpoint) && lineNumber == rulerLine) {
                            breakpoints.add(markers[i]);
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException x) {
                JavaPlugin.logErrorStatus((String)JavaEditorMessages.getString((String)"ManageBreakpoints.error.retrieving.message"), (IStatus)x.getStatus());
            }
        }
        return breakpoints;
    }

    protected void addMarker() {
        IEditorInput sqljEditorInput = this.getTextEditor().getEditorInput();
        IFile sqljFile = ((FileEditorInput)sqljEditorInput).getFile();
        IEditorInput editorInput = ((SQLJEditor)this.getTextEditor()).getJavaEditorInput();
        IDocument document = this.getDocument();
        int rulerLine = this.getVerticalRulerInfo().getLineOfLastMouseButtonActivity();
        try {
            BreakpointLocationVerifier bv = new BreakpointLocationVerifier();
            int lineNumber = bv.getValidBreakpointLocation(document, rulerLine);
            if (lineNumber > 0) {
                IRegion line = document.getLineInformation(lineNumber - 1);
                IType type = null;
                if (editorInput instanceof IClassFileEditorInput) {
                    IClassFileEditorInput input = (IClassFileEditorInput)editorInput;
                    type = input.getClassFile().getType();
                } else if (editorInput instanceof IFileEditorInput) {
                    ICompilationUnit unit = ((SQLJEditor)this.getTextEditor()).getCompilationUnit();
                    IJavaElement e = unit.getElementAt(line.getOffset());
                    if (e instanceof IType) {
                        type = (IType)e;
                    } else if (e != null && e instanceof IMember) {
                        type = ((IMember)e).getDeclaringType();
                    }
                }
                if (type != null && JDIDebugModel.lineBreakpointExists((String)type.getFullyQualifiedName(), (int)lineNumber) == null) {
                    HashMap<String, String> attributes = new HashMap<String, String>(10);
                    JavaCore.addJavaElementMarkerAttributes(attributes, (IJavaElement)type);
                    attributes.put("org.eclipse.jdt.debug.ui.JAVA_ELEMENT_HANDLE_ID", type.getHandleIdentifier());
                    IJavaLineBreakpoint bp = JDIDebugModel.createLineBreakpoint((IResource)sqljFile, (String)type.getFullyQualifiedName(), (int)lineNumber, (int)line.getOffset(), (int)(line.getOffset() + line.getLength()), (int)0, (boolean)true, attributes);
                    SQLJResourceMarkerAnnotationModel model = (SQLJResourceMarkerAnnotationModel)SQLJEditorPlugin.getDocumentProvider().getAnnotationModel(sqljEditorInput);
                    model.update();
                }
            }
        }
        catch (DebugException e) {
            Shell shell = this.getTextEditor().getSite().getShell();
            ErrorDialog.openError((Shell)shell, (String)JavaEditorMessages.getString((String)"ManageBreakpoints.error.adding.title1"), (String)JavaEditorMessages.getString((String)"ManageBreakpoints.error.adding.message1"), (IStatus)e.getStatus());
        }
        catch (CoreException e) {
            Shell shell = this.getTextEditor().getSite().getShell();
            ErrorDialog.openError((Shell)shell, (String)JavaEditorMessages.getString((String)"ManageBreakpoints.error.adding.title2"), (String)JavaEditorMessages.getString((String)"ManageBreakpoints.error.adding.message2"), (IStatus)e.getStatus());
        }
        catch (BadLocationException e) {
            Shell shell = this.getTextEditor().getSite().getShell();
            ErrorDialog.openError((Shell)shell, (String)JavaEditorMessages.getString((String)"ManageBreakpoints.error.adding.title3"), (String)JavaEditorMessages.getString((String)"ManageBreakpoints.error.adding.message3"), null);
        }
    }

    protected void removeMarkers(List markers) {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        try {
            Iterator e = markers.iterator();
            while (e.hasNext()) {
                IBreakpoint breakpoint = breakpointManager.getBreakpoint((IMarker)e.next());
                breakpointManager.removeBreakpoint(breakpoint, true);
                IEditorInput sqljEditorInput = this.getTextEditor().getEditorInput();
                SQLJResourceMarkerAnnotationModel model = (SQLJResourceMarkerAnnotationModel)SQLJEditorPlugin.getDocumentProvider().getAnnotationModel(sqljEditorInput);
                model.update();
            }
        }
        catch (CoreException e) {
            Shell shell = this.getTextEditor().getSite().getShell();
            ErrorDialog.openError((Shell)shell, (String)JavaEditorMessages.getString((String)"ManageBreakpoints.error.removing.title1"), (String)JavaEditorMessages.getString((String)"ManageBreakpoints.error.removing.message1"), (IStatus)e.getStatus());
        }
    }

    public IResource getBreakpointResource(IMember member) throws CoreException {
        IResource res;
        ICompilationUnit cu = member.getCompilationUnit();
        if (cu != null && cu.isWorkingCopy()) {
            member = (IMember)cu.getOriginal((IJavaElement)member);
        }
        if ((res = member.getUnderlyingResource()) == null) {
            res = member.getJavaProject().getProject();
        }
        return res;
    }
}

