/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.sqlj;

import com.sap.dictionary.tools.sqlj.SQLJEditorPlugin;
import com.sap.dictionary.tools.sqlj.translator.SQLJResourceHandlingHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public class SQLJResourceChangeListener
implements IResourceChangeListener,
IResourceDeltaVisitor {
    public boolean visit(IResourceDelta delta) throws CoreException {
        String ext = delta.getResource().getFullPath().getFileExtension();
        if (ext != null && ext.equals("sqlj")) {
            switch (delta.getKind()) {
                case 1: {
                    IProject newSQLJProject = delta.getResource().getProject();
                    SQLJEditorPlugin.setNature(newSQLJProject);
                    break;
                }
                case 4: {
                    break;
                }
                case 2: {
                    IFile javaFile = SQLJResourceHandlingHelper.getJavaFile((IFile)delta.getResource());
                    if (javaFile == null) break;
                    javaFile.delete(true, false, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        return true;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            if (event.getDelta() != null) {
                event.getDelta().accept((IResourceDeltaVisitor)this);
            }
        }
        catch (CoreException e) {
            SQLJEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.sap.dictionary.tools.sqlj", 4, "accept resource deltas", (Throwable)e));
        }
    }
}

